/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.title.model.metadata.asset;

import com.google.gwt.user.client.rpc.IsSerializable;
import com.tandbergtv.cms.portal.content.client.title.model.ICopyable;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.IUIAssetVisitor;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIAssetFile;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIComplexField;
import java.util.ArrayList;
import java.util.List;

public abstract class UIAsset
implements IsSerializable,
ICopyable {
    private static final String ROOT_FIELD_NAME = "Metadata";
    private Long id;
    private UIAsset parentAsset;
    private boolean active = true;
    private UIComplexField rootField;
    private List<UIAssetFile> files = new ArrayList<UIAssetFile>();

    public UIAsset() {
        this.rootField = new UIComplexField();
        this.rootField.setParentAsset(this);
        this.rootField.setName(ROOT_FIELD_NAME);
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public UIAsset getRootAsset() {
        return this.parentAsset != null ? this.parentAsset.getRootAsset() : this;
    }

    public UIAsset getParentAsset() {
        return this.parentAsset;
    }

    public void setParentAsset(UIAsset parentAsset) {
        this.parentAsset = parentAsset;
    }

    public abstract String getAssetType();

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public UIComplexField getRootField() {
        return this.rootField;
    }

    public List<UIAssetFile> getFiles() {
        return this.files;
    }

    public void addFile(UIAssetFile file) {
        file.setParentAsset(this);
        if (!this.files.contains(file)) {
            this.files.add(file);
        }
    }

    public boolean removeFile(UIAssetFile file) {
        boolean result = this.files.remove(file);
        if (result) {
            file.setParentAsset(null);
        }
        return result;
    }

    @Override
    public abstract UIAsset createCopy();

    protected void copyProperties(UIAsset copy) {
        copy.setId(this.getId());
        copy.setActive(this.isActive());
        copy.rootField = this.rootField.createCopy();
        for (UIAssetFile file : this.getFiles()) {
            copy.addFile(file.createCopy());
        }
    }

    public abstract void accept(IUIAssetVisitor var1);
}

