/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.title.view.history;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.title.model.history.UITitleHistory;
import com.tandbergtv.cms.portal.content.client.title.service.ReadDeletedTitleException;
import com.tandbergtv.cms.portal.content.client.title.view.TitleErrorPanel;
import com.tandbergtv.cms.portal.content.client.title.view.history.HistoryPanel;
import com.tandbergtv.cms.portal.content.client.title.view.history.ProgressItemDataProvider;
import com.tandbergtv.cms.portal.content.client.title.view.history.ProgressItemRecord;
import com.tandbergtv.cms.portal.content.client.title.view.history.TitleHistoryTab;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Table;

class ProgressHistoryPanel
extends HistoryPanel {
    private ProgressItemDataProvider dataProvider;
    private Table<Long, ProgressItemRecord> table;

    public ProgressHistoryPanel(TitleHistoryTab parent) {
        super(parent);
        this.setStyleName("title-history-panel");
    }

    @Override
    protected void initialize() {
        this.dataProvider = new ProgressItemDataProvider(this);
        this.table = new Table((DataProvider)this.dataProvider);
        LabelWidget blankLabel = new LabelWidget("");
        this.setWidget((Widget)blankLabel);
    }

    private void showLoadingMessage() {
        String message = this.getTab().getViewMessages().historyLoading();
        this.setWidget((Widget)new LabelWidget(message));
    }

    @Override
    public void refresh() {
        this.showLoadingMessage();
        if (!this.table.isInitialized()) {
            this.table.initialize((AsyncCallback)new AsyncCallback<Void>(){

                public void onFailure(Throwable caught) {
                }

                public void onSuccess(Void result) {
                    ProgressHistoryPanel.this.table.refresh();
                }
            });
        } else {
            this.table.refresh();
        }
    }

    void handleGetRecordsSuccess(UITitleHistory history, int recordCount) {
        if (recordCount == 0) {
            String message = this.getTab().getViewMessages().historyNotPresent();
            LabelWidget label = new LabelWidget(message);
            this.setWidget((Widget)label);
        } else {
            this.setWidget((Widget)this.table);
        }
        this.getTab().hideBusyIndicator();
        this.getTab().markUpdated();
    }

    void handleGetRecordsFailure(Throwable caught) {
        if (caught instanceof ReadDeletedTitleException) {
            this.getTab().showSevereError(caught.getMessage());
        } else {
            TitleHistoryTab tab = this.getTab();
            String message = tab.getViewMessages().historyFetchFailure(caught.getMessage());
            TitleErrorPanel errorPanel = new TitleErrorPanel(message);
            errorPanel.setSize("100%", "100%");
            errorPanel.addEventListener(new TitleErrorPanel.EventListener(){

                @Override
                public void onRefreshClicked(TitleErrorPanel panel) {
                    ProgressHistoryPanel.this.refresh();
                }
            });
            this.setWidget((Widget)errorPanel);
        }
        this.getTab().hideBusyIndicator();
    }
}

