/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.title.view.history;

import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.ContentComponent;
import com.tandbergtv.cms.portal.content.client.title.model.UITitle;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.UITitleMetadata;
import com.tandbergtv.cms.portal.content.client.title.view.TitleView;
import com.tandbergtv.cms.portal.content.client.title.view.TitleViewTab;
import com.tandbergtv.cms.portal.content.client.title.view.history.MetadataHistoryPanel;
import com.tandbergtv.cms.portal.content.client.title.view.history.ProgressHistoryPanel;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIAssetSpecification;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneApplication;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;

public class TitleHistoryTab
extends TitleViewTab {
    private ProgressHistoryPanel progressHistoryPanel;
    private MetadataHistoryPanel metadataHistoryPanel;
    private Timer refreshTimer = null;
    private static final int DEFAULT_REFRESH_RATE = 180;
    private static final int MINIMUM_REFRESH_RATE = 30;

    public TitleHistoryTab(TitleView parent) {
        super(parent);
    }

    @Override
    protected void initialize() {
        this.progressHistoryPanel = new ProgressHistoryPanel(this);
        this.metadataHistoryPanel = new MetadataHistoryPanel(this);
        this.progressHistoryPanel.setWidth(String.valueOf(super.getTabWidth() - 20) + "px");
        this.metadataHistoryPanel.setWidth(String.valueOf(super.getTabWidth() - 20) + "px");
        this.getContainer().setWidget((Widget)this.progressHistoryPanel);
        this.getContainer().setWidth(String.valueOf(super.getTabWidth() - 20) + "px");
    }

    @Override
    public void refresh() {
        this.showBusyIndicator();
        this.getContainer().setWidget((Widget)this.progressHistoryPanel);
        this.progressHistoryPanel.refresh();
        this.metadataHistoryPanel.refresh();
        this.metadataHistoryPanel.setWidth(String.valueOf(super.getTabWidth() - 20) + "px");
    }

    @Override
    protected void markUpdated() {
        super.markUpdated();
    }

    protected void onLoad() {
        super.onLoad();
        if (this.refreshTimer != null) {
            this.refreshTimer.cancel();
            this.refreshTimer = null;
        }
        NeptuneApplication application = NeptuneApplication.getApplication();
        ContentComponent component = (ContentComponent)application.getComponent(ContentComponent.class);
        String refreshRateValue = component.getTitleHistoryViewRefreshRate();
        int refreshRate = 180;
        try {
            if (refreshRateValue != null && refreshRateValue.trim().length() > 0 && (refreshRate = Integer.parseInt(refreshRateValue.trim())) < 30) {
                refreshRate = 30;
            }
        }
        catch (Exception e) {
            refreshRate = 180;
        }
        this.refreshTimer = new Timer(){

            public void run() {
                TitleHistoryTab.this.handleTimerEvent();
            }
        };
        this.refreshTimer.scheduleRepeating(refreshRate * 1000);
    }

    protected void onUnload() {
        super.onUnload();
        if (this.refreshTimer != null) {
            this.refreshTimer.cancel();
            this.refreshTimer = null;
        }
    }

    private void handleTimerEvent() {
        if (!this.progressHistoryPanel.isAttached()) {
            return;
        }
        boolean visible = true;
        ProgressHistoryPanel widget = this.progressHistoryPanel;
        while (widget != null && visible) {
            visible &= widget.isVisible();
            widget = widget.getParent();
        }
        if (visible && this.getViewInput() != null && !this.isStale()) {
            this.getViewInput().invalidateHistory();
            this.refresh();
        }
    }

    void showTitleRevision(final String titleRevision) {
        Long titleId = this.getViewInput().getTitleId();
        if (titleId == null) {
            return;
        }
        this.showBusyIndicator();
        this.getViewInput().getSpecification((AsyncCallback<UIAssetSpecification>)new NeptuneAsyncCallback<UIAssetSpecification>(){

            public void onNeptuneSuccess(UIAssetSpecification result) {
                TitleHistoryTab.this.handleGetSpecificationSuccess(titleRevision, result);
            }

            public void onNeptuneFailure(Throwable caught) {
                TitleHistoryTab.this.handleGetSpecificationFailure(caught);
            }
        });
    }

    private void handleGetSpecificationSuccess(final String titleRevision, final UIAssetSpecification specification) {
        Long titleId = this.getViewInput().getTitleId();
        this.getViewService().getTitleMetadata(titleId, titleRevision, (AsyncCallback<UITitleMetadata>)new NeptuneAsyncCallback<UITitleMetadata>(){

            public void onNeptuneSuccess(UITitleMetadata result) {
                TitleHistoryTab.this.handleGetTitleMetadataSuccess(titleRevision, specification, result);
            }

            public void onNeptuneFailure(Throwable caught) {
                TitleHistoryTab.this.handleGetTitleMetadataFailure(titleRevision, caught);
            }
        });
    }

    private void handleGetSpecificationFailure(Throwable caught) {
        String error = caught != null ? caught.getLocalizedMessage() : "";
        String name = this.getViewInput().getSpecificationName();
        String message = name != null ? this.getViewMessages().specificationFetchFailure(name, error) : this.getViewMessages().defaultSpecificationFetchFailure(error);
        this.showErrorPanel(message);
        this.hideBusyIndicator();
    }

    private void handleGetTitleMetadataSuccess(String revision, UIAssetSpecification specification, UITitleMetadata result) {
        this.getTitleView().setFeedbackMessage(null);
        this.metadataHistoryPanel.setInput(revision, specification, result);
        this.getContainer().setWidget((Widget)this.metadataHistoryPanel);
        this.hideBusyIndicator();
    }

    private void handleGetTitleMetadataFailure(String revision, Throwable caught) {
        String error = caught.getLocalizedMessage();
        String message = this.getViewMessages().titleRevisionFetchError(revision, error);
        this.getViewInput().invalidateHistory();
        this.showErrorPanel(message);
        this.hideBusyIndicator();
    }

    void showProgressHistory(boolean titleUpdated, String infoMessage, boolean invalidateHistory) {
        this.getTitleView().setFeedbackMessage(infoMessage);
        this.getContainer().setWidget((Widget)this.progressHistoryPanel);
        if (titleUpdated) {
            UITitle title = new UITitle();
            title.setId(title.getId());
            this.onTitleUpdated(title);
        } else if (invalidateHistory) {
            this.getViewInput().invalidateHistory();
        }
        if (titleUpdated || invalidateHistory) {
            this.refresh();
        }
    }

    @Override
    protected void onTabSelected() {
        if (!this.isStale()) {
            this.getViewInput().invalidateHistory();
            this.refresh();
        }
    }

    @Override
    protected int getTabHeight() {
        return super.getTabHeight();
    }

    @Override
    protected int getTabWidth() {
        return super.getTabWidth();
    }

    @Override
    protected void showBusyIndicator() {
        super.showBusyIndicator();
    }

    @Override
    protected void hideBusyIndicator() {
        super.hideBusyIndicator();
    }

    @Override
    protected void showSevereError(String message) {
        super.showSevereError(message);
    }
}

