/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.title.view.metadata;

import com.tandbergtv.cms.portal.content.client.title.model.metadata.UITitleValidationMessage;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.UITitleValidationMessageType;
import com.tandbergtv.cms.portal.content.client.title.view.asset.AssetValidationMessage;
import java.util.ArrayList;
import java.util.List;

public class TitleValidationViewInput {
    private List<UITitleValidationMessage> titleValidationMessages = new ArrayList<UITitleValidationMessage>();
    private List<AssetValidationMessage> assetValidationMessages = new ArrayList<AssetValidationMessage>();

    public List<UITitleValidationMessage> getTitleValidationMessages() {
        return this.titleValidationMessages;
    }

    public List<AssetValidationMessage> getAssetValidationMessages() {
        return this.assetValidationMessages;
    }

    public void clearMessages() {
        this.titleValidationMessages.clear();
        this.assetValidationMessages.clear();
    }

    public boolean hasValidationMessages() {
        return this.titleValidationMessages.size() > 0 || this.assetValidationMessages.size() > 0;
    }

    public int getMessageCount() {
        return this.titleValidationMessages.size() + this.assetValidationMessages.size();
    }

    public int getErrorMessageCount() {
        int count = this.getMessageCount(UITitleValidationMessageType.Error);
        return count += this.assetValidationMessages.size();
    }

    public int getWarningMessageCount() {
        return this.getMessageCount(UITitleValidationMessageType.Warning);
    }

    public int getInformationMessageCount() {
        return this.getMessageCount(UITitleValidationMessageType.Information);
    }

    private int getMessageCount(UITitleValidationMessageType messageType) {
        int count = 0;
        for (UITitleValidationMessage message : this.titleValidationMessages) {
            if (!messageType.equals((Object)message.getMessageType())) continue;
            ++count;
        }
        return count;
    }
}

