/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.server.title;

import com.tandbergtv.cms.contentmgmt.service.asset.ITitleManager;
import com.tandbergtv.cms.contentmgmt.service.asset.ITitleSearchService;
import com.tandbergtv.cms.portal.content.client.model.UiAsset;
import com.tandbergtv.cms.portal.content.client.model.UiColumn;
import com.tandbergtv.cms.portal.content.client.model.UiField;
import com.tandbergtv.cms.portal.content.client.model.UiTitle;
import com.tandbergtv.cms.portal.content.client.model.UiTitleList;
import com.tandbergtv.cms.portal.content.client.rpc.title.TitleSearchService;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UITitleFilter;
import com.tandbergtv.cms.portal.ui.title.server.search.SearchCriteriaBuilder;
import com.tandbergtv.cms.portal.util.transaction.TransactionEnforcer;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.metadatamanager.model.Group;
import com.tandbergtv.metadatamanager.model.Item;
import com.tandbergtv.metadatamanager.util.AssetUtil;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;
import com.tandbergtv.neptune.widgettoolkit.server.remote.NeptuneRemoteService;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.workflow.util.SearchCriteria;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import org.aspectj.runtime.internal.AroundClosure;

public class TitleSearchServiceImpl
implements TitleSearchService,
NeptuneRemoteService {
    private ITitleSearchService searchService = (ITitleSearchService)InjectionUtil.injectInstance((String)"cms/TitleSearch/local", ITitleSearchService.class);
    private ITitleManager titleManager = (ITitleManager)InjectionUtil.injectInstance((String)"cms/TitleManager/local", ITitleManager.class);

    public String getRelativePath() {
        return "service/content/titleSearchService";
    }

    public Class<?> getServiceImplementation() {
        return this.getClass();
    }

    @Override
    @Transactional
    public UiTitleList getTitles(UITitleFilter titleFilter, List<UiColumn> columns) {
        UITitleFilter uITitleFilter = titleFilter;
        List<UiColumn> list = columns;
        return (UiTitleList)TitleSearchServiceImpl.getTitles_aroundBody1$advice(this, uITitleFilter, list, TransactionEnforcer.aspectOf(), TitleSearchServiceImpl.class.getDeclaredMethod("getTitles", UITitleFilter.class, List.class).getAnnotation(Transactional.class), null);
    }

    @Override
    @Transactional
    public UiTitleList getTitles(List<Long> titleids, List<UiColumn> columns) throws NeptuneException {
        List<Long> list = titleids;
        List<UiColumn> list2 = columns;
        return (UiTitleList)TitleSearchServiceImpl.getTitles_aroundBody3$advice(this, list, list2, TransactionEnforcer.aspectOf(), TitleSearchServiceImpl.class.getDeclaredMethod("getTitles", List.class, List.class).getAnnotation(Transactional.class), null);
    }

    private UiTitle prepareUiObject(Title title, List<UiColumn> columns) {
        UiTitle uiTitle = new UiTitle();
        uiTitle.setTitleId(title.getId());
        UiAsset uiAsset = new UiAsset();
        uiAsset.setId(title.getAsset().getId());
        List<UiField> fields = this.getColumnFields(title, columns);
        for (UiField f : fields) {
            uiAsset.addField(f);
        }
        uiTitle.setAsset(uiAsset);
        return uiTitle;
    }

    private List<UiField> getColumnFields(Title t, List<UiColumn> columns) {
        Asset a = t.getAsset();
        ArrayList<UiField> fields = new ArrayList<UiField>();
        for (UiColumn uiCol : columns) {
            UiField f = new UiField();
            f.setDisplayName(uiCol.getDisplayName());
            if (uiCol.isMetadata()) {
                f.setParentAssetType(uiCol.getSectionName());
                f.setName(uiCol.getName());
                Field metadataField = this.getMetadataField(a, uiCol);
                if (metadataField != null) {
                    f.setValue(metadataField.getValue());
                    fields.add(f);
                    continue;
                }
                fields.add(f);
                continue;
            }
            fields.add(this.getTitleField(t, uiCol));
        }
        return fields;
    }

    private Field getMetadataField(Asset a, UiColumn uiCol) {
        for (Field f : a.getAllDescendantAssetFields()) {
            if (!f.getTtvXPath().equalsIgnoreCase(uiCol.getName()) || !this.getParentAssetType(f).equalsIgnoreCase(uiCol.getSectionName())) continue;
            return f;
        }
        return null;
    }

    private String getParentAssetType(Field field) {
        Asset parentAsset = new AssetUtil().unWrap(field.getParentAsset());
        if (parentAsset instanceof Group) {
            return ((Group)parentAsset).getType().toString();
        }
        if (parentAsset instanceof Item) {
            return ((Item)parentAsset).getType().toString();
        }
        return null;
    }

    private UiField getTitleField(Title t, UiColumn uiCol) {
        UiField f = new UiField();
        f.setName(uiCol.getName());
        f.setDisplayName(uiCol.getDisplayName());
        try {
            java.lang.reflect.Field field = Title.class.getDeclaredField(uiCol.getName());
            field.setAccessible(true);
            f.setValue(String.valueOf(field.get(t)));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get field " + uiCol.getName() + " from asset", e);
        }
        return f;
    }

    private static final /* synthetic */ UiTitleList getTitles_aroundBody0(TitleSearchServiceImpl this_, UITitleFilter titleFilter, List columns) {
        SearchCriteriaBuilder criteriaBuilder = new SearchCriteriaBuilder();
        SearchCriteria criteria = criteriaBuilder.buildCriteria(titleFilter);
        Collection matchingTitles = this_.searchService.search(criteria);
        ArrayList<UiTitle> uiTitles = new ArrayList<UiTitle>();
        for (Title t : matchingTitles) {
            uiTitles.add(this_.prepareUiObject(t, columns));
        }
        int count = this_.searchService.count(criteria);
        return new UiTitleList(count, uiTitles);
    }

    /*
     * WARNING - void declaration
     */
    private static final /* synthetic */ Object getTitles_aroundBody1$advice(TitleSearchServiceImpl this_, UITitleFilter transactional, List ajc_aroundClosure, TransactionEnforcer transactionEnforcer, Transactional transactional2, AroundClosure aroundClosure) {
        void isTransactionOwner;
        void e;
        TransactionManager transactionManager = null;
        boolean bl = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            bl = transactionManager.getTransaction() == null;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        if (!bl) {
            void var10_11 = e;
            void var11_12 = isTransactionOwner;
            return TitleSearchServiceImpl.getTitles_aroundBody0(this_, transactional, ajc_aroundClosure);
        }
        try {
            transactionManager.begin();
            void var12_13 = e;
            void var13_14 = isTransactionOwner;
            UiTitleList uiTitleList = TitleSearchServiceImpl.getTitles_aroundBody0(this_, transactional, ajc_aroundClosure);
            transactionManager.commit();
            return uiTitleList;
        }
        catch (Exception exception) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)exception);
            try {
                transactionManager.rollback();
            }
            catch (Exception exception2) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)exception2);
            }
            throw new RuntimeException(exception);
        }
    }

    private static final /* synthetic */ UiTitleList getTitles_aroundBody2(TitleSearchServiceImpl this_, List titleids, List columns) {
        ArrayList<UiTitle> uiTitles = new ArrayList<UiTitle>();
        Iterator iterator = titleids.iterator();
        while (iterator.hasNext()) {
            long id = (Long)iterator.next();
            Title t = this_.titleManager.getTitle(Long.valueOf(id));
            uiTitles.add(this_.prepareUiObject(t, columns));
        }
        return new UiTitleList(titleids.size(), uiTitles);
    }

    /*
     * WARNING - void declaration
     */
    private static final /* synthetic */ Object getTitles_aroundBody3$advice(TitleSearchServiceImpl this_, List transactional, List ajc_aroundClosure, TransactionEnforcer transactionEnforcer, Transactional transactional2, AroundClosure aroundClosure) {
        void isTransactionOwner;
        void e;
        TransactionManager transactionManager = null;
        boolean bl = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            bl = transactionManager.getTransaction() == null;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        if (!bl) {
            void var10_11 = e;
            void var11_12 = isTransactionOwner;
            return TitleSearchServiceImpl.getTitles_aroundBody2(this_, transactional, ajc_aroundClosure);
        }
        try {
            transactionManager.begin();
            void var12_13 = e;
            void var13_14 = isTransactionOwner;
            UiTitleList uiTitleList = TitleSearchServiceImpl.getTitles_aroundBody2(this_, transactional, ajc_aroundClosure);
            transactionManager.commit();
            return uiTitleList;
        }
        catch (Exception exception) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)exception);
            try {
                transactionManager.rollback();
            }
            catch (Exception exception2) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)exception2);
            }
            throw new RuntimeException(exception);
        }
    }
}

