/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.marvin.services;

import com.tandbergtv.watchpoint.pmm.entities.titlefilter.TreExpList;
import com.tandbergtv.watchpoint.pmm.entities.titlefilter.TreExpNode;
import com.tandbergtv.watchpoint.pmm.entities.titlefilter.TreExpValue;
import com.tandbergtv.watchpoint.pmm.entities.titlefilter.TreLogicalOperator;
import com.tandbergtv.watchpoint.pmm.entities.titlefilter.TrePredicate;
import com.tandbergtv.watchpoint.pmm.entities.titlefilter.TrePredicateRightValue;
import com.tandbergtv.watchpoint.pmm.entities.titlefilter.ret.RetNode;
import com.tandbergtv.watchpoint.pmm.entities.titlefilter.ret.RetOperand;
import com.tandbergtv.watchpoint.pmm.entities.titlefilter.ret.RetOperator;
import com.tandbergtv.watchpoint.pmm.entities.titlefilter.ret.RetTree;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;

public class TestTreeConvert {
    @Test
    public void testOneValueNode() {
        RetTree tree = this.getOneValueNode("field1", "EQUAL", "value1").getAsOptimizedTree();
        Assert.assertTrue((boolean)(tree.getRoot() instanceof RetOperand));
        Assert.assertTrue((tree.getRoot().getLeft() == null ? 1 : 0) != 0);
        Assert.assertTrue((tree.getRoot().getRight() == null ? 1 : 0) != 0);
    }

    @Test
    public void testOneValueNodePredicate() {
        RetTree tree = this.getOneValueNode("field1", "EQUAL", "value1").getAsOptimizedTree();
        Assert.assertTrue((((RetOperand)tree.getRoot()).getPredicate() != null ? 1 : 0) != 0);
        Assert.assertTrue((((RetOperand)tree.getRoot()).getPredicate().getFieldLeft() != null ? 1 : 0) != 0);
    }

    @Test
    public void testOneListNode() {
        int leafNodes = 4;
        RetTree tree = this.getOneListNode(leafNodes, "AND").getAsOptimizedTree();
        RetNode currNode = tree.getRoot();
        int i = 1;
        while (i < leafNodes) {
            Assert.assertTrue((boolean)(currNode instanceof RetOperator));
            Assert.assertTrue((currNode.getLeft() != null ? 1 : 0) != 0);
            Assert.assertTrue((currNode.getRight() != null ? 1 : 0) != 0);
            Assert.assertTrue((boolean)(currNode.getLeft() instanceof RetOperand));
            Assert.assertTrue((boolean)((RetOperand)currNode.getLeft()).getPredicate().getFieldLeft().equals("field" + i));
            Assert.assertTrue((currNode.getLeft().getLeft() == null ? 1 : 0) != 0);
            Assert.assertTrue((currNode.getLeft().getRight() == null ? 1 : 0) != 0);
            currNode = currNode.getRight();
            ++i;
        }
        Assert.assertTrue((boolean)(currNode instanceof RetOperand));
        Assert.assertTrue((boolean)((RetOperand)currNode).getPredicate().getFieldLeft().equals("field" + leafNodes));
        Assert.assertTrue((currNode.getLeft() == null ? 1 : 0) != 0);
        Assert.assertTrue((currNode.getRight() == null ? 1 : 0) != 0);
    }

    @Test
    public void testOneListNodeWithOneValue() {
        RetTree tree = this.getOneListNode(1, "OR").getAsOptimizedTree();
        Assert.assertTrue((boolean)(tree.getRoot() instanceof RetOperand));
        Assert.assertTrue((tree.getRoot().getLeft() == null ? 1 : 0) != 0);
        Assert.assertTrue((tree.getRoot().getRight() == null ? 1 : 0) != 0);
    }

    @Test
    public void testOptimization() {
        TreExpList list1 = new TreExpList();
        list1.setOperator("AND");
        TreExpList list2 = new TreExpList();
        list2.setOperator("OR");
        TreExpList list3 = new TreExpList();
        list3.setOperator("AND");
        list3.addItem((TreExpNode)this.getOneListNode(1, "OR"));
        list2.addItem((TreExpNode)list3);
        list1.addItem((TreExpNode)list2);
        RetTree tree = list1.getAsOptimizedTree();
        Assert.assertTrue((boolean)(tree.getRoot() instanceof RetOperand));
        Assert.assertTrue((tree.getRoot().getLeft() == null ? 1 : 0) != 0);
        Assert.assertTrue((tree.getRoot().getRight() == null ? 1 : 0) != 0);
    }

    @Test
    public void testMultipleListNode() {
        TreExpList list1 = this.getOneListNode(1, "AND");
        TreExpList list2 = this.getOneListNode(1, "OR");
        TreExpList list3 = this.getOneListNode(2, "AND");
        TreExpList list4 = this.getOneListNode(2, "OR");
        list3.addItem((TreExpNode)list4);
        list1.addItem((TreExpNode)list3);
        list1.addItem((TreExpNode)list2);
        RetTree tree = list1.getAsOptimizedTree();
        RetNode node = tree.getRoot();
        Assert.assertTrue((node instanceof RetOperator && ((RetOperator)node).getOperator() == "AND" ? 1 : 0) != 0);
        Assert.assertTrue((node.getLeft() instanceof RetOperand && ((RetOperand)node.getLeft()).getPredicate().getFieldLeft().equals("field1") ? 1 : 0) != 0);
        node = node.getRight();
        Assert.assertTrue((node instanceof RetOperator && ((RetOperator)node).getOperator() == "AND" ? 1 : 0) != 0);
        Assert.assertTrue((node.getRight() instanceof RetOperand && ((RetOperand)node.getRight()).getPredicate().getFieldLeft().equals("field1") ? 1 : 0) != 0);
        node = node.getLeft();
        Assert.assertTrue((node instanceof RetOperator && ((RetOperator)node).getOperator() == "AND" ? 1 : 0) != 0);
        Assert.assertTrue((node.getLeft() instanceof RetOperand && ((RetOperand)node.getLeft()).getPredicate().getFieldLeft().equals("field1") ? 1 : 0) != 0);
        node = node.getRight();
        Assert.assertTrue((node instanceof RetOperator && ((RetOperator)node).getOperator() == "AND" ? 1 : 0) != 0);
        Assert.assertTrue((node.getLeft() instanceof RetOperand && ((RetOperand)node.getLeft()).getPredicate().getFieldLeft().equals("field2") ? 1 : 0) != 0);
        node = node.getRight();
        Assert.assertTrue((node instanceof RetOperator && ((RetOperator)node).getOperator() == "OR" ? 1 : 0) != 0);
        Assert.assertTrue((node.getLeft() instanceof RetOperand && ((RetOperand)node.getLeft()).getPredicate().getFieldLeft().equals("field1") ? 1 : 0) != 0);
        Assert.assertTrue((node.getRight() instanceof RetOperand && ((RetOperand)node.getRight()).getPredicate().getFieldLeft().equals("field2") ? 1 : 0) != 0);
    }

    private TreExpList getOneListNode(int count, String operator) {
        TreExpList result = new TreExpList();
        result.setOperator(operator);
        int i = 1;
        while (i <= count) {
            result.addItem(this.getOneValueNode("field" + i, "EQUAL", "value" + i));
            ++i;
        }
        return result;
    }

    private TreExpNode getOneValueNode(String field, String OperatorName, String value) {
        TreLogicalOperator op = TreLogicalOperator.lookUp((String)OperatorName);
        ArrayList<String> values = new ArrayList<String>();
        values.add(value);
        TreExpValue result = new TreExpValue((TrePredicate)new TrePredicateRightValue(field, "TITLE", values, op));
        return result;
    }
}

