/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.marvin.engine;

import com.tandbergtv.marvin.engine.EvaluatorException;
import com.tandbergtv.marvin.engine.IDeterminating;
import com.tandbergtv.marvin.engine.IllegalOperationException;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.watchpoint.pmm.entities.titlefilter.TrePredicate;
import com.tandbergtv.watchpoint.pmm.entities.titlefilter.TrePredicateRightValue;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class DateDeterminating
implements IDeterminating {
    private Date value;
    private Date comparison;
    private String exceptionMsg = "value must be a date";
    private Field field;

    public DateDeterminating(TrePredicate predicate, Field field) throws EvaluatorException {
        this.field = field;
        if (!this.containsUnparsable()) {
            this.value = this.getValue(field);
        }
        if (predicate instanceof TrePredicateRightValue) {
            this.comparison = this.getComparison((TrePredicateRightValue)predicate);
        }
    }

    private Date getComparison(TrePredicateRightValue predicate) throws EvaluatorException {
        try {
            String s = (String)predicate.getValue().get(0);
            Date date = this.isInteger(s) ? this.getRelativeDate(s) : this.parseDate(s);
            return this.firstDateHell(date);
        }
        catch (ParseException ide) {
            throw new EvaluatorException(this.exceptionMsg, ide);
        }
    }

    public Date getRelativeDate(String s) {
        int numDays = this.getInteger(s);
        Calendar cal = GregorianCalendar.getInstance();
        cal.setTime(new Date());
        cal.add(10, numDays * 24);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    private Date parseDate(String date) throws ParseException {
        String format = "yyyy-MM-dd";
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        return formatter.parse(date.substring(0, format.length()));
    }

    private boolean isInteger(String s) {
        try {
            if (!s.isEmpty()) {
                Integer.parseInt(s);
            }
            return true;
        }
        catch (NumberFormatException ex) {
            return false;
        }
    }

    private int getInteger(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    private Date getValue(Field field) throws EvaluatorException {
        if (field == null || this.containsUnparsable()) {
            return null;
        }
        if (!field.getDataType().equals("date")) {
            throw new EvaluatorException(String.valueOf(this.exceptionMsg) + " - is not a date");
        }
        Date date = (Date)field.getTypedValue();
        return this.firstDateHell(date);
    }

    private Date firstDateHell(Date date) {
        Calendar cal = GregorianCalendar.getInstance();
        cal.setTime(date);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    @Override
    public boolean equal() {
        if (this.value == null) {
            return false;
        }
        return this.value.equals(this.comparison);
    }

    @Override
    public boolean greaterThan() {
        if (this.value == null) {
            return false;
        }
        return this.value.after(this.comparison);
    }

    @Override
    public boolean greaterThanEqual() {
        if (this.value == null) {
            return false;
        }
        return this.value.after(this.comparison) || this.value.equals(this.comparison);
    }

    @Override
    public boolean in() throws IllegalOperationException {
        throw new IllegalOperationException();
    }

    @Override
    public boolean isEmpty() throws IllegalOperationException {
        return this.field == null;
    }

    @Override
    public boolean isNotEmpty() {
        return this.field != null;
    }

    @Override
    public boolean lessThan() {
        if (this.value == null) {
            return false;
        }
        return this.value.before(this.comparison);
    }

    @Override
    public boolean lessThanEqual() {
        if (this.value == null) {
            return false;
        }
        return this.value.before(this.comparison) || this.value.equals(this.comparison);
    }

    @Override
    public boolean contains() throws IllegalOperationException {
        throw new IllegalOperationException();
    }

    @Override
    public boolean notEqual() {
        return !this.equal();
    }

    @Override
    public boolean notIn() throws IllegalOperationException {
        throw new IllegalOperationException();
    }

    @Override
    public boolean lengthEquals() throws IllegalOperationException {
        throw new IllegalOperationException();
    }

    @Override
    public boolean lengthGreaterThan() throws IllegalOperationException {
        throw new IllegalOperationException();
    }

    @Override
    public boolean lengthLessThan() throws IllegalOperationException {
        throw new IllegalOperationException();
    }

    @Override
    public boolean regex() throws IllegalOperationException {
        throw new IllegalOperationException();
    }

    @Override
    public boolean startsWith() throws IllegalOperationException {
        throw new IllegalOperationException();
    }

    @Override
    public boolean endsWith() throws IllegalOperationException {
        throw new IllegalOperationException();
    }

    @Override
    public boolean greaterThanToday() {
        return this.greaterThan();
    }

    @Override
    public boolean lessThanToday() {
        return this.lessThan();
    }

    @Override
    public boolean containsUnparsable() {
        if (this.field == null) {
            return false;
        }
        return this.field.getParsable() == false;
    }

    @Override
    public boolean doesNotContain() throws IllegalOperationException {
        throw new IllegalOperationException();
    }

    @Override
    public boolean tierEquals(int tier) throws IllegalOperationException {
        throw new IllegalOperationException();
    }

    public Date getValue() {
        return this.value;
    }

    public Date getComparison() {
        return this.comparison;
    }
}

