/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.marvin.engine;

import com.tandbergtv.cms.contentmgmt.service.asset.ITitleSearchService;
import com.tandbergtv.marvin.engine.Actionator;
import com.tandbergtv.marvin.engine.Determinator;
import com.tandbergtv.marvin.engine.EvaluatorException;
import com.tandbergtv.marvin.engine.EvaluatorResults;
import com.tandbergtv.marvin.engine.IllegalOperationException;
import com.tandbergtv.marvin.udt.RuleResults;
import com.tandbergtv.marvin.udt.TreAction;
import com.tandbergtv.marvin.udt.TreActionParameterValue;
import com.tandbergtv.marvin.udt.TreRule;
import com.tandbergtv.marvin.udt.TreRuleSet;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.metadatamanager.model.FieldTree;
import com.tandbergtv.metadatamanager.model.FieldTreeNode;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.entities.titlefilter.TreExpNode;
import com.tandbergtv.watchpoint.pmm.entities.titlefilter.TrePredicate;
import com.tandbergtv.watchpoint.pmm.entities.titlefilter.TrePredicateComplex;
import com.tandbergtv.watchpoint.pmm.entities.titlefilter.TreTitleFilter;
import com.tandbergtv.watchpoint.pmm.entities.titlefilter.ret.RetNode;
import com.tandbergtv.watchpoint.pmm.entities.titlefilter.ret.RetOperand;
import com.tandbergtv.watchpoint.pmm.entities.titlefilter.ret.RetOperator;
import com.tandbergtv.watchpoint.pmm.entities.titlefilter.ret.RetTree;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;

public class Evaluator {
    private static final Logger logger = Logger.getLogger(Evaluator.class);

    public RuleResults evaluateRules(TreRuleSet ruleset, Title title) throws EvaluatorException, IllegalOperationException, IllegalArgumentException, IllegalAccessException, InvocationTargetException, ClassNotFoundException, InstantiationException {
        logger.info((Object)("Evaluating Rules for Rule Id:" + ruleset.getRuleSetId() + "Name = \"" + ruleset.getRuleName() + "\" Enabled:" + ruleset.getEnabled()));
        List rules = ruleset.getRules();
        RuleResults result = new RuleResults(title);
        for (TreRule rule : rules) {
            EvaluatorResults evalResults;
            TreExpNode expnode = rule.getConditions();
            RetNode node = null;
            if (expnode != null) {
                RetTree tree = expnode.getAsOptimizedTree();
                node = tree.getRoot();
            }
            if (!(evalResults = this.evaluateNode(node, title)).passed()) continue;
            RuleResults actionResult = this.triggerAction(rule, title, evalResults);
            result.merge(actionResult);
        }
        return result;
    }

    public boolean evaluateTitleFilter(TreRuleSet rules, Title title) throws EvaluatorException, IllegalOperationException {
        logger.info((Object)("evaluate: " + rules.getRuleName()));
        TreTitleFilter filter = rules.getFilter();
        if (!filter.hasCriteria()) {
            return true;
        }
        if (!rules.getEnabled().booleanValue()) {
            logger.info((Object)("SKIPPED EVALUATING TITLE FILTERS OF DISABLED RULESET:" + rules.getRuleName()));
            return true;
        }
        TreExpNode expnode = filter.getRootNode();
        RetTree tree = expnode.getAsOptimizedTree();
        RetNode node = tree.getRoot();
        logger.info((Object)("EVALUATING TITLE FILTERS:" + rules.getRuleName()));
        if (this.evaluateNode(node, title).passed()) {
            logger.info((Object)"Adding to filtered titles:");
            return true;
        }
        return false;
    }

    private EvaluatorResults evaluateNode(RetNode node, Title title) throws EvaluatorException, IllegalOperationException {
        if (node == null) {
            return new EvaluatorResults(true);
        }
        if (node instanceof RetOperand) {
            String sectionType;
            RetOperand operand = (RetOperand)node;
            TrePredicate predicate = operand.getPredicate();
            String xpath = predicate.getFieldLeft();
            if (xpath.equals(sectionType = predicate.getFieldLeftSectionType()) || xpath == null) {
                List assets = title.getAsset().getAllAssetsOfType(sectionType);
                if (assets.size() == 0) {
                    return this.evaluatePredicateNoData(predicate, operand);
                }
                return this.evaluatePredicateOnAssetWithAssets(predicate, assets, operand);
            }
            List<FieldTree> fieldTrees = this.getFieldTrees(title, sectionType, xpath);
            if (fieldTrees.size() == 0) {
                return this.evaluatePredicateNoData(predicate, operand);
            }
            return this.evaluatePredicateFieldTree(predicate, operand, fieldTrees);
        }
        EvaluatorResults result = new EvaluatorResults();
        RetOperator op = (RetOperator)node;
        EvaluatorResults left = this.evaluateNode(op.left, title);
        if (op.getOperator().equals("AND") && !left.passed()) {
            return result;
        }
        EvaluatorResults right = this.evaluateNode(op.right, title);
        if (op.getOperator().equals("AND") && !right.passed()) {
            return result;
        }
        if (left.passed() && right.passed()) {
            result = left;
            result.mergeResults(right);
        } else if (left.passed()) {
            result = left;
        } else if (right.passed()) {
            result = right;
        }
        return result;
    }

    private EvaluatorResults evaluatePredicateNoData(TrePredicate predicate, RetOperand operand) throws EvaluatorException, IllegalOperationException {
        EvaluatorResults result = new EvaluatorResults();
        if (predicate instanceof TrePredicateComplex) {
            TrePredicateComplex complexPredicate = (TrePredicateComplex)predicate;
            result.setPassed(true);
            for (TrePredicate pred : complexPredicate.getChildren()) {
                if (Determinator.determine(pred)) continue;
                result.setPassed(false);
            }
        } else {
            result.setPassed(Determinator.determine(operand.getPredicate()));
        }
        return result;
    }

    private EvaluatorResults evaluatePredicateOnAssetWithAssets(TrePredicate predicate, List<Asset> assets, RetOperand operand) throws EvaluatorException, IllegalOperationException {
        EvaluatorResults result = new EvaluatorResults();
        for (Asset asset : assets) {
            boolean passes = true;
            if (predicate instanceof TrePredicateComplex) {
                passes = this.evaluateComplex((TrePredicateComplex)predicate, asset);
            } else if (!Determinator.determine(operand.getPredicate(), asset)) {
                passes = false;
            }
            if (!passes) continue;
            result.setPassed(passes);
            result.addMatchedAsset(asset);
        }
        return result;
    }

    private ArrayList<Field> getFieldsForXpath(Asset asset, String xpath) {
        ArrayList<Field> list = new ArrayList<Field>();
        for (Field f : asset.getFields()) {
            if (!f.getTtvXPath().startsWith(xpath)) continue;
            list.add(f);
        }
        return list;
    }

    private EvaluatorResults evaluatePredicateFieldTree(TrePredicate predicate, RetOperand operand, List<FieldTree> fieldTrees) throws EvaluatorException, IllegalOperationException {
        EvaluatorResults result = new EvaluatorResults();
        for (FieldTree ftree : fieldTrees) {
            boolean passes = true;
            if (predicate instanceof TrePredicateComplex) {
                passes = this.evaluateComplex((TrePredicateComplex)predicate, ftree);
            } else {
                String xpath = predicate.getFieldLeft();
                String sectionType = predicate.getFieldLeftSectionType();
                List<Field> fields = this.getFields(ftree, xpath, sectionType, true);
                passes = this.evaluateComplexHelper(operand.getPredicate(), fields);
            }
            if (!passes) continue;
            result.setPassed(passes);
            result.addMatchedItem(ftree);
        }
        return result;
    }

    private boolean evaluateComplex(TrePredicateComplex complexPredicate, Asset asset) throws IllegalOperationException, EvaluatorException {
        for (TrePredicate pred : complexPredicate.getChildren()) {
            ArrayList<Field> fields;
            if (pred instanceof TrePredicateComplex) {
                logger.error((Object)"DUDE, you can't have complex within complex. It makes my brain hurt.");
                return false;
            }
            if (!(pred.getFieldLeft() == null || pred.getFieldLeftSectionType().equals(pred.getFieldLeft()) ? !Determinator.determine(pred, asset) : !this.evaluateComplexHelper(pred, fields = this.getFieldsForXpath(asset, pred.getFieldLeft())))) continue;
            return false;
        }
        return true;
    }

    private boolean evaluateComplex(TrePredicateComplex complexPredicate, FieldTree ftree) throws IllegalOperationException, EvaluatorException {
        for (TrePredicate pred : complexPredicate.getChildren()) {
            if (pred instanceof TrePredicateComplex) {
                logger.error((Object)"DUDE, you can't have complex within complex. It makes my brain hurt.");
                return false;
            }
            List<Field> fields = this.getFields(ftree, pred.getFieldLeft(), pred.getFieldLeftSectionType(), true);
            if (this.evaluateComplexHelper(pred, fields)) continue;
            return false;
        }
        return true;
    }

    private boolean evaluateComplexHelper(TrePredicate predicate, List<Field> fields) throws IllegalOperationException, EvaluatorException {
        if (fields.size() == 0) {
            return Determinator.determine(predicate);
        }
        for (Field field : fields) {
            if (!Determinator.determine(predicate, field)) continue;
            return true;
        }
        return false;
    }

    private List<FieldTree> breakApartFieldTree(List<FieldTree> fieldTree) {
        ArrayList<FieldTree> trees = new ArrayList<FieldTree>();
        for (FieldTree tree : fieldTree) {
            for (FieldTreeNode node : tree.getRootElement().getChildren()) {
                FieldTree yeffedTree = new FieldTree();
                FieldTreeNode root = new FieldTreeNode();
                root.setName(tree.getRootElement().getName());
                root.addChild(node);
                yeffedTree.setRootElement(root);
                trees.add(yeffedTree);
            }
        }
        return trees;
    }

    private List<FieldTree> getFieldTrees(Title title, String assetType, String xpath) {
        Asset asset = title.getAsset();
        return this.breakApartFieldTree(asset.getFieldTreeForXpath(assetType, xpath));
    }

    private List<Field> getFields(FieldTree fieldTree, String xpath, String assetType, boolean includeChildren) {
        if (fieldTree == null) {
            return new ArrayList<Field>();
        }
        FieldTreeNode root = fieldTree.getRootElement();
        ArrayList<Field> fields = new ArrayList<Field>();
        this.getFieldsRec(root, xpath, assetType, fields, includeChildren);
        return fields;
    }

    private void getFieldsRec(FieldTreeNode fieldTreeNode, String xpath, String assetType, List<Field> fields, boolean includeChildren) {
        List children = fieldTreeNode.getChildren();
        if (fieldTreeNode.getField() != null) {
            Field field = fieldTreeNode.getField();
            String fieldXpath = field.getTtvXPath();
            String fieldAssetType = field.getParentAsset().getAssetType();
            if (fieldXpath.equals(xpath) && fieldAssetType.equals(assetType)) {
                fields.add(field);
            } else if (includeChildren && fieldAssetType.equals(assetType) && (String.valueOf(fieldXpath) + "/").startsWith(String.valueOf(xpath) + "/")) {
                fields.add(field);
            }
        }
        if (children != null) {
            for (FieldTreeNode childNode : children) {
                this.getFieldsRec(childNode, xpath, assetType, fields, includeChildren);
            }
        }
    }

    private RuleResults triggerAction(TreRule rule, Title title, EvaluatorResults evalResults) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, ClassNotFoundException, InstantiationException {
        Actionator actionator = new Actionator();
        List actions = rule.getActions();
        for (TreAction action : actions) {
            logger.info((Object)action.getMethod());
            List params = action.getParams();
            for (TreActionParameterValue param : params) {
                logger.info((Object)(param.getValueId() + param.getName() + " " + param.getValue() + " literal=" + param.getIsLiteral()));
            }
        }
        return actionator.actionate(actions, title, evalResults);
    }

    public Collection<Title> grabAllTitles() {
        ITitleSearchService searchService = (ITitleSearchService)InjectionUtil.injectInstance((String)"cms/TitleSearch/local", ITitleSearchService.class);
        Collection matchingTitles = searchService.search(null);
        return matchingTitles;
    }
}

