/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.marvin.engine;

import com.tandbergtv.marvin.engine.EvaluatorException;
import com.tandbergtv.marvin.engine.IDeterminating;
import com.tandbergtv.marvin.engine.IllegalOperationException;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.watchpoint.pmm.entities.titlefilter.TrePredicate;
import com.tandbergtv.watchpoint.pmm.entities.titlefilter.TrePredicateRightValue;
import java.util.ArrayList;
import java.util.List;

public class LongDeterminating
implements IDeterminating {
    private Field field;
    private TrePredicate predicate;

    public LongDeterminating(TrePredicate predicate, Field field) throws EvaluatorException {
        this.field = field;
        this.predicate = predicate;
    }

    private Long getLongLhs() throws EvaluatorException {
        if (this.containsUnparsable() || this.field == null) {
            return null;
        }
        return (Long)this.field.getTypedValue();
    }

    private Long getRhsAsLong() throws EvaluatorException {
        List<Long> list = this.getRhsAsLongList();
        if (list.size() == 1) {
            return list.get(0);
        }
        throw new EvaluatorException("Predicate with ID and operator " + this.predicate.getOperator().getName() + " has a list as a RHS.");
    }

    private List<Long> getRhsAsLongList() throws EvaluatorException {
        TrePredicateRightValue rightPredicate = (TrePredicateRightValue)this.predicate;
        if (rightPredicate.getValue().size() == 0) {
            throw new EvaluatorException("Predicate with ID and operator " + this.predicate.getOperator().getName() + " is missing a RHS.");
        }
        try {
            ArrayList<Long> values = new ArrayList<Long>();
            for (String predVal : rightPredicate.getValue()) {
                values.add(Long.parseLong(predVal));
            }
            return values;
        }
        catch (NumberFormatException e) {
            throw new EvaluatorException("value must be a long number", e);
        }
    }

    @Override
    public boolean equal() throws EvaluatorException {
        Long lhs = this.getLongLhs();
        return lhs != null && lhs.equals(this.getRhsAsLong());
    }

    @Override
    public boolean greaterThan() throws EvaluatorException {
        Long lhs = this.getLongLhs();
        return lhs != null && this.getLongLhs().compareTo(this.getRhsAsLong()) > 0;
    }

    @Override
    public boolean greaterThanEqual() throws EvaluatorException {
        Long lhs = this.getLongLhs();
        return lhs != null && this.getLongLhs().compareTo(this.getRhsAsLong()) >= 0;
    }

    @Override
    public boolean in() throws EvaluatorException {
        Long value = this.getLongLhs();
        if (value == null) {
            return false;
        }
        for (Long compVal : this.getRhsAsLongList()) {
            if (!value.equals(compVal)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() throws IllegalOperationException {
        return this.field == null;
    }

    @Override
    public boolean isNotEmpty() {
        return this.field != null;
    }

    @Override
    public boolean lessThan() throws EvaluatorException {
        return this.field != null && this.getLongLhs().compareTo(this.getRhsAsLong()) < 0;
    }

    @Override
    public boolean lessThanEqual() throws EvaluatorException {
        return this.field != null && this.getLongLhs().compareTo(this.getRhsAsLong()) <= 0;
    }

    @Override
    public boolean contains() throws IllegalOperationException {
        throw new IllegalOperationException();
    }

    @Override
    public boolean doesNotContain() throws IllegalOperationException {
        return !this.contains();
    }

    @Override
    public boolean notEqual() throws EvaluatorException {
        return !this.equal();
    }

    @Override
    public boolean notIn() throws IllegalOperationException, EvaluatorException {
        return !this.in();
    }

    @Override
    public boolean lengthEquals() throws IllegalOperationException {
        throw new IllegalOperationException();
    }

    @Override
    public boolean lengthGreaterThan() throws IllegalOperationException {
        throw new IllegalOperationException();
    }

    @Override
    public boolean lengthLessThan() throws IllegalOperationException {
        throw new IllegalOperationException();
    }

    @Override
    public boolean regex() throws IllegalOperationException {
        throw new IllegalOperationException();
    }

    @Override
    public boolean startsWith() throws IllegalOperationException {
        throw new IllegalOperationException();
    }

    @Override
    public boolean endsWith() throws IllegalOperationException {
        throw new IllegalOperationException();
    }

    @Override
    public boolean greaterThanToday() throws IllegalOperationException {
        throw new IllegalOperationException();
    }

    @Override
    public boolean lessThanToday() throws IllegalOperationException {
        throw new IllegalOperationException();
    }

    @Override
    public boolean containsUnparsable() {
        if (this.field == null) {
            return false;
        }
        return this.field.getParsable() == false;
    }

    @Override
    public boolean tierEquals(int tier) throws IllegalOperationException {
        throw new IllegalOperationException();
    }
}

