/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.marvin.metadata;

import com.tandbergtv.marvin.metadata.SchemaThingHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class SchemaNode {
    private String nodeName;
    private SchemaNode parent;
    private Element elem;
    private HashMap<String, String> attrs = new HashMap();
    private List<SchemaNode> children = new ArrayList<SchemaNode>();
    private Class<Object> mappedClass;
    private boolean simpleType;

    public Class<Object> getMappedClass() {
        return this.mappedClass;
    }

    public SchemaNode(String nodeName) {
        this.nodeName = nodeName;
    }

    public void setMappedClass(Class<Object> mappedClass) {
        this.mappedClass = mappedClass;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public Element getElem() {
        return this.elem;
    }

    public void setElem(Element elem) {
        this.elem = elem;
    }

    public SchemaNode(Element elem) {
        this.nodeName = elem.getAttribute("name");
        this.elem = elem;
        this.populateAttr(elem);
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    public SchemaNode getParent() {
        return this.parent;
    }

    public void setParent(SchemaNode parent) {
        this.parent = parent;
    }

    public void addAttr(String name, String value) {
        this.attrs.put(name, value);
    }

    public void addChild(SchemaNode child) {
        if (child != null) {
            child.parent = this;
            this.children.add(child);
        }
    }

    public boolean isSimpleType() {
        return this.simpleType;
    }

    public void setSimpleType(boolean simpleType) {
        this.simpleType = simpleType;
    }

    public String getQName() {
        String s = "";
        String token = ".";
        SchemaNode parent = this.parent;
        while (parent != null) {
            s = String.valueOf(s) + parent.getNodeName() + token;
            parent = parent.getParent();
        }
        s = SchemaThingHelper.reverseStringByToken(s, token);
        s = String.valueOf(s) + this.nodeName;
        return s;
    }

    private void populateAttr(Element elem) {
        NamedNodeMap eAttrs = elem.getAttributes();
        int i = 0;
        while (i < eAttrs.getLength()) {
            Attr attr = (Attr)eAttrs.item(i);
            this.attrs.put(attr.getName(), attr.getValue());
            ++i;
        }
    }
}

