/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.rules.ui.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.shared.HandlerManager;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIAssetSpecification;
import com.tandbergtv.cms.portal.ui.title.client.service.specification.UISpecificationClientManager;
import com.tandbergtv.cms.rules.ui.client.RulesConstants;
import com.tandbergtv.cms.rules.ui.client.RulesTab;
import com.tandbergtv.cms.rules.ui.client.common.RulesConfirmation;
import com.tandbergtv.cms.rules.ui.client.common.events.ConfirmationEvent;
import com.tandbergtv.cms.rules.ui.client.common.events.ConfirmationHandler;
import com.tandbergtv.cms.rules.ui.client.common.events.TabChangeEvent;
import com.tandbergtv.cms.rules.ui.client.common.events.TabChangeHandler;
import com.tandbergtv.cms.rules.ui.client.data.Packages;
import com.tandbergtv.cms.rules.ui.client.validation.ValidationTestPanel;
import com.tandbergtv.neptune.widgettoolkit.client.application.PortletFactory;
import com.tandbergtv.neptune.widgettoolkit.client.application.Service;
import com.tandbergtv.neptune.widgettoolkit.client.application.SingletonWidgetFactory;
import com.tandbergtv.neptune.widgettoolkit.client.application.WidgetFactory;
import com.tandbergtv.neptune.widgettoolkit.client.component.ComponentBase;
import com.tandbergtv.neptune.widgettoolkit.client.menu.GroupMenuItem;
import com.tandbergtv.neptune.widgettoolkit.client.menu.MenuItemBase;
import com.tandbergtv.neptune.widgettoolkit.client.menu.WidgetMenuItem;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import java.util.ArrayList;
import java.util.List;

public class RulesComponent
extends ComponentBase {
    private RulesConstants myConstants = (RulesConstants)GWT.create(RulesConstants.class);
    private static RulesComponent instance = new RulesComponent();
    private static Panel workaround;
    private NeptuneSecurity security;
    private HandlerManager handlerManager;
    private RulesTab tabNormalize;
    private RulesTab tabValidate;
    private RulesTab tabProcess;
    private UIAssetSpecification spec;
    private boolean hasErrors = false;
    private Packages currentPackage = Packages.NORMALIZATION;

    public RulesComponent() {
        this.tabNormalize = new RulesTab(Packages.NORMALIZATION);
        this.tabValidate = new RulesTab(Packages.VALIDATION);
        this.tabProcess = new RulesTab(Packages.PROCESSING);
        this.handlerManager = new HandlerManager((Object)this, true);
    }

    public static RulesComponent getInstance() {
        return instance;
    }

    public RulesTab getTab(Packages panel) {
        switch (panel) {
            case NORMALIZATION: {
                return this.tabNormalize;
            }
            case VALIDATION: {
                return this.tabValidate;
            }
            case PROCESSING: {
                return this.tabProcess;
            }
        }
        return null;
    }

    public static Panel getWorkaround() {
        return workaround;
    }

    public static void setWorkaround(Panel panel) {
        workaround = panel;
    }

    public void setContents(Packages packages, Panel contents, String confirm) {
        if (confirm != null && !confirm.isEmpty()) {
            final Packages pkg = packages;
            final Panel widget = contents;
            RulesConfirmation.show(confirm, new ConfirmationHandler(){

                @Override
                public void confirm(ConfirmationEvent event) {
                    if (event.isConfirm()) {
                        RulesComponent.this.setContents(pkg, widget);
                    }
                }
            });
        } else {
            this.setContents(packages, contents);
        }
    }

    public void setContents(Packages packages, Panel widget) {
        RulesTab oldTab = this.getTab(this.currentPackage);
        Widget contents = oldTab.getTabContents();
        if (contents != null) {
            contents.removeFromParent();
        }
        this.getTab(packages).setContents((Widget)widget);
        this.currentPackage = packages;
    }

    public List<MenuItemBase> listTabs(NeptuneSecurity security) {
        ArrayList<MenuItemBase> tabs = new ArrayList<MenuItemBase>();
        this.security = security;
        if (security.isUserInRole("RulesManagement_View")) {
            ArrayList<WidgetMenuItem> rulesGroup = new ArrayList<WidgetMenuItem>();
            rulesGroup.add(this.createNormalisationPanel());
            rulesGroup.add(this.createValidationPanel());
            rulesGroup.add(this.createProcessingPanel());
            tabs.add((MenuItemBase)new GroupMenuItem(this.myConstants.ruleLabel(), rulesGroup));
        }
        TabChangeHandler handler = new TabChangeHandler(){

            @Override
            public void tabChange(TabChangeEvent event) {
                if (!event.isDead()) {
                    Packages pkg = event.getPackage();
                    Panel target = event.getTarget();
                    RulesComponent.getInstance().setContents(pkg, target);
                }
            }
        };
        this.tabNormalize.addHandler(handler);
        this.tabValidate.addHandler(handler);
        this.tabProcess.addHandler(handler);
        this.loadSpecification();
        return tabs;
    }

    public List<PortletFactory> listPortlets(NeptuneSecurity security) {
        return null;
    }

    public HandlerManager getHandlerManager() {
        return this.handlerManager;
    }

    public <E extends Service> List<E> listServices(Class<E> clazz, NeptuneSecurity security) {
        return new ArrayList();
    }

    public NeptuneSecurity getSecurity() {
        return this.security;
    }

    public RulesConstants getConstants() {
        return this.myConstants;
    }

    public boolean isReady() {
        return this.spec != null;
    }

    public boolean hasErrors() {
        return this.hasErrors;
    }

    public UIAssetSpecification getSpecification() {
        return this.spec;
    }

    private WidgetMenuItem createNormalisationPanel() {
        String label = this.myConstants.normalizationLabel();
        return new WidgetMenuItem(label, (WidgetFactory)this.tabNormalize);
    }

    private WidgetMenuItem createValidationPanel() {
        String label = this.myConstants.validationLabel();
        return new WidgetMenuItem(label, (WidgetFactory)this.tabValidate);
    }

    private WidgetMenuItem createProcessingPanel() {
        String label = this.myConstants.ContentProcessingLabel();
        return new WidgetMenuItem(label, (WidgetFactory)this.tabProcess);
    }

    private WidgetMenuItem createValidationTestPanel() {
        ValidationTestPanel v = new ValidationTestPanel();
        return new WidgetMenuItem("Run Rule Run", (WidgetFactory)new SingletonWidgetFactory((Widget)v));
    }

    protected void loadSpecification() {
        UISpecificationClientManager specMan = UISpecificationClientManager.getInstance();
        specMan.getDefault((AsyncCallback)new NeptuneAsyncCallback<UIAssetSpecification>(){

            public void onNeptuneSuccess(UIAssetSpecification result) {
                RulesComponent.this.spec = result;
                RulesComponent.this.getTab(RulesComponent.this.currentPackage).getInstance();
            }

            public void onNeptuneFailure(Throwable caught) {
                RulesComponent.this.hasErrors = true;
            }
        });
    }

    public void setSecurity(NeptuneSecurity security) {
        this.security = security;
    }

    public void setSpecification(UIAssetSpecification spec) {
        this.spec = spec;
    }
}

