/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.rules.ui.client.common;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.rules.ui.client.RulesComponent;
import com.tandbergtv.cms.rules.ui.client.RulesConstants;
import com.tandbergtv.cms.rules.ui.client.common.WizardItem;
import com.tandbergtv.cms.rules.ui.client.common.WizardPane;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.DockContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

public class WizardPanel
extends VerticalContainer {
    private int currentIndex = 1;
    private VerticalContainer contents;
    private ButtonWidget nextLink;
    private ButtonWidget prevLink;
    private DockContainer links;
    private HorizontalContainer instructionPanel;
    private LabelWidget instructionsLabel;
    private RulesConstants rulesConstants = RulesComponent.getInstance().getConstants();

    public WizardPanel() {
        this.nextLink = this.createNextButton();
        this.prevLink = this.createPrevButton();
        this.links = new DockContainer();
        this.links.add((Widget)this.prevLink, DockContainer.LINE_START);
        this.links.add((Widget)this.nextLink, DockContainer.LINE_END);
        this.links.setCellHorizontalAlignment((Widget)this.prevLink, DockContainer.ALIGN_LEFT);
        this.links.setCellHorizontalAlignment((Widget)this.nextLink, DockContainer.ALIGN_RIGHT);
        this.links.setStyleName("rule-wizard-link-width");
        this.contents = new VerticalContainer();
        this.instructionPanel = new HorizontalContainer();
        this.instructionsLabel = new LabelWidget();
        this.instructionPanel.setStyleName("wizard-panel");
        this.instructionsLabel.setStyleName("rules-wizard-instructions");
        this.add((Widget)this.instructionPanel);
        this.add((Widget)this.instructionsLabel);
        this.add((Widget)this.contents);
        this.add((Widget)this.links);
    }

    private ButtonWidget createPrevButton() {
        ButtonWidget button = new ButtonWidget(this.rulesConstants.prevLink());
        button.setText(this.rulesConstants.prevLink());
        button.setVisible(false);
        button.addStyleDependentName("action-button");
        button.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                WizardPanel wizardPanel = WizardPanel.this;
                wizardPanel.currentIndex = wizardPanel.currentIndex - 1;
                WizardPanel.this.updatePanelDisplay();
            }
        });
        return button;
    }

    private ButtonWidget createNextButton() {
        ButtonWidget button = new ButtonWidget(this.rulesConstants.nextLink());
        button.setText(this.rulesConstants.nextLink());
        button.addStyleDependentName("action-button");
        button.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (WizardPanel.this.validateCurrentPane()) {
                    WizardPanel wizardPanel = WizardPanel.this;
                    wizardPanel.currentIndex = wizardPanel.currentIndex + 1;
                    WizardPanel.this.updatePanelDisplay();
                }
            }
        });
        return button;
    }

    public void show(boolean isNewRule) {
        if (!isNewRule) {
            this.showAllPanels();
            this.nextLink.setVisible(false);
            this.prevLink.setVisible(false);
            this.instructionPanel.setVisible(false);
        } else {
            this.currentIndex = 1;
            this.instructionPanel.setVisible(true);
            this.updatePanelDisplay();
        }
    }

    public void addStepPanel(String name, WizardPane item, String instructions) {
        WizardItem newItem = new WizardItem(item, instructions);
        newItem.setVisible(false);
        this.contents.add((Widget)newItem);
        this.contents.setCellHorizontalAlignment((Widget)newItem, HasHorizontalAlignment.ALIGN_CENTER);
        LabelWidget instruction = new LabelWidget(name);
        instruction.setStyleName("wizard-link-off");
        this.instructionPanel.add((Widget)instruction);
        this.instructionPanel.setCellHorizontalAlignment((Widget)instruction, HasHorizontalAlignment.ALIGN_CENTER);
        this.instructionPanel.setCellVerticalAlignment((Widget)instruction, HasVerticalAlignment.ALIGN_MIDDLE);
    }

    public void addStepPanel(String name, WizardPane item) {
        this.addStepPanel(name, item, "");
    }

    private void showAllPanels() {
        int i = 0;
        while (i < this.contents.getWidgetCount()) {
            Widget w = this.contents.getWidget(i);
            w.setVisible(true);
            ++i;
        }
    }

    private void showCurrentStepOnly() {
        int i = 0;
        while (i < this.contents.getWidgetCount()) {
            this.contents.getWidget(i).setVisible(false);
            ++i;
        }
        if (this.currentIndex <= this.contents.getWidgetCount()) {
            this.contents.getWidget(this.currentIndex - 1).setVisible(true);
        }
        WizardItem item = (WizardItem)this.contents.getWidget(this.currentIndex - 1);
        this.instructionsLabel.setText(item.getInstructions());
        this.setInstructionOn(this.currentIndex - 1);
    }

    private void setInstructionOn(int onIndex) {
        int i = 0;
        while (i < this.instructionPanel.getWidgetCount()) {
            Widget off = this.instructionPanel.getWidget(i);
            off.setStyleName("wizard-link-off");
            ++i;
        }
        Widget on = this.instructionPanel.getWidget(onIndex);
        on.setStyleName("wizard-link-selected");
    }

    private void updatePanelDisplay() {
        this.showCurrentStepOnly();
        if (this.currentIndex <= 1) {
            this.prevLink.setVisible(false);
        } else if (this.currentIndex < this.contents.getWidgetCount()) {
            this.prevLink.setVisible(true);
            this.nextLink.setVisible(true);
        } else if (this.currentIndex == this.contents.getWidgetCount()) {
            this.nextLink.setVisible(false);
            this.showAllPanels();
        }
    }

    public boolean validateAllItems() {
        int i = 0;
        while (i < this.contents.getWidgetCount()) {
            WizardItem w = (WizardItem)this.contents.getWidget(i);
            if (!w.getPane().validate()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean validateCurrentPane() {
        WizardItem w = (WizardItem)this.contents.getWidget(this.currentIndex - 1);
        return w.getPane().validate();
    }

    public void clear() {
        this.nextLink.setVisible(true);
        this.instructionPanel.clear();
        this.contents.clear();
    }
}

