/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.rules.ui.client.common.rulelisting;

import com.allen_sauer.gwt.dnd.client.DragHandler;
import com.allen_sauer.gwt.dnd.client.DragHandlerAdapter;
import com.allen_sauer.gwt.dnd.client.drop.DropController;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerManager;
import com.google.gwt.user.client.ui.AbsolutePanel;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.rules.ui.client.RulesComponent;
import com.tandbergtv.cms.rules.ui.client.common.Permissions;
import com.tandbergtv.cms.rules.ui.client.common.RulesConfirmation;
import com.tandbergtv.cms.rules.ui.client.common.RulesUiException;
import com.tandbergtv.cms.rules.ui.client.common.events.ConfirmationEvent;
import com.tandbergtv.cms.rules.ui.client.common.events.ConfirmationHandler;
import com.tandbergtv.cms.rules.ui.client.common.events.TabChangeEvent;
import com.tandbergtv.cms.rules.ui.client.common.events.TabChangeHandler;
import com.tandbergtv.cms.rules.ui.client.common.rulelisting.MoveCallback;
import com.tandbergtv.cms.rules.ui.client.common.rulelisting.RowDragController;
import com.tandbergtv.cms.rules.ui.client.common.rulelisting.RowDropController;
import com.tandbergtv.cms.rules.ui.client.common.rulelisting.TableRow;
import com.tandbergtv.cms.rules.ui.client.data.Packages;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.CheckBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.HTMLWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ImageWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.FlexTableContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class OrderableTable
extends VerticalContainer {
    private static final String DRAG_HANDLE_IMAGE_URL = "cms_rules_ui/images/drag_drop_cue.gif";
    private static int HEADER_ROW = 0;
    private int DRAG_COLUMN;
    private int CHKBOX_COLUMN;
    private boolean hasChkBox;
    private boolean isDirty;
    private int curColIndex;
    private FlexTableContainer table;
    private RowDragController rowDragger;
    private List<String> columns = new ArrayList<String>(8);
    private List<String> displayNames = new ArrayList<String>();
    private String idColName;

    public OrderableTable(String idColName) {
        NeptuneSecurity security = RulesComponent.getInstance().getSecurity();
        this.isDirty = false;
        this.idColName = idColName;
        this.hasChkBox = false;
        this.curColIndex = 0;
        this.table = new FlexTableContainer();
        this.rowDragger = this.createDragDropHandler(this.table);
        this.hasChkBox = security.isUserInRole(Permissions.DELETE);
        this.addDragColumn();
        this.addCheckboxColumn(this.hasChkBox);
        this.add((Widget)this.table);
    }

    public void addColumn(String displayName, String name) {
        int index = this.curColIndex++;
        String hdr_style = "table-header-row";
        String txt_style = "table-header-nonSortable-text";
        LabelWidget label = new LabelWidget(displayName);
        label.addStyleName(txt_style);
        this.table.setWidget(0, index, (Widget)label);
        this.table.getRowFormatter().setStyleName(0, hdr_style);
        this.columns.add(name);
        this.displayNames.add(displayName);
    }

    public void addItem(int row, String col, HTMLWidget value) throws RulesUiException {
        String styleName;
        int index = this.columns.indexOf(col);
        int dataRow = row + HEADER_ROW + 1;
        String string = styleName = dataRow % 2 == 0 ? "table-data-even-row" : "table-data-odd-row";
        if (index != -1) {
            ImageWidget handle = new ImageWidget(DRAG_HANDLE_IMAGE_URL);
            this.rowDragger.makeDraggable((Widget)handle);
            this.table.setWidget(dataRow, this.DRAG_COLUMN, (Widget)handle);
            this.table.setWidget(dataRow, index + this.CHKBOX_COLUMN + 1, (Widget)value);
            this.table.getRowFormatter().setStyleName(dataRow, styleName);
            value.setStyleName("table-data-link");
            if (this.hasChkBox) {
                this.table.setWidget(dataRow, this.CHKBOX_COLUMN, (Widget)this.createCheckbox());
            }
        } else {
            throw new RulesUiException("adding to unknown column: " + col);
        }
        if (this.getIdColumn() == -1) {
            throw new RulesUiException("ID Column not set");
        }
    }

    public List<TableRow> getTableRows() {
        ArrayList<TableRow> rows = new ArrayList<TableRow>();
        int i = HEADER_ROW + 1;
        while (i < this.table.getRowCount()) {
            rows.add(this.getTableRow(i));
            ++i;
        }
        return rows;
    }

    public TableRow getTableRow(int rowIndex) {
        TableRow row = new TableRow(this.columns, this.isChecked(rowIndex));
        int j = 0;
        while (j < this.getColumnCount()) {
            String cellValue = this.getText(rowIndex, j);
            row.setValue(this.columns.get(j), cellValue);
            ++j;
        }
        return row;
    }

    public void resetDirty() {
        this.isDirty = false;
    }

    public int getColumnCount() {
        return this.curColIndex - this.CHKBOX_COLUMN - 1;
    }

    public int getRowCount() {
        return this.table.getRowCount() - (HEADER_ROW + 1);
    }

    public List<Integer> getSelectedIds() {
        ArrayList<Integer> ids = new ArrayList<Integer>();
        int idColIndex = this.getIdColumn();
        int row = HEADER_ROW + 1;
        while (row < this.table.getRowCount()) {
            String id = this.table.getText(row, idColIndex);
            CheckBox checkBox = (CheckBox)this.table.getWidget(row, this.CHKBOX_COLUMN);
            if (checkBox.getValue().booleanValue()) {
                ids.add(Integer.parseInt(id));
            }
            ++row;
        }
        return ids;
    }

    public boolean isChecked(int row) {
        Widget w = this.table.getWidget(row, this.CHKBOX_COLUMN);
        return w instanceof CheckBox && ((CheckBox)w).isEnabled();
    }

    public Iterator<TableRow> rowIterator() {
        return new RowIterator(this);
    }

    public void clear() {
        int offset = this.curColIndex - this.columns.size();
        String hdr_style = "table-header-row";
        String txt_style = "table-header-nonSortable-text";
        System.out.println(this.table.getRowCount());
        this.table.clear();
        int row = 0;
        while (row < this.table.getRowCount()) {
            this.table.removeRow(0);
            ++row;
        }
        if (this.hasChkBox) {
            this.table.setWidget(HEADER_ROW, this.CHKBOX_COLUMN, (Widget)this.createTopCheckBox());
        }
        this.table.setWidget(HEADER_ROW, this.DRAG_COLUMN, (Widget)new LabelWidget(""));
        int i = 0;
        while (i < this.columns.size()) {
            String display = this.displayNames.get(i);
            LabelWidget label = new LabelWidget(display);
            label.addStyleName(txt_style);
            this.table.setWidget(0, i + offset, (Widget)label);
            ++i;
        }
        this.table.getRowFormatter().setStyleName(0, hdr_style);
    }

    private void addCheckboxColumn(boolean hasCheckBox) {
        if (hasCheckBox) {
            CheckBoxWidget chkBox = this.createTopCheckBox();
            this.CHKBOX_COLUMN = this.curColIndex++;
            this.table.setWidget(HEADER_ROW, this.CHKBOX_COLUMN, (Widget)chkBox);
        }
    }

    private void addDragColumn() {
        this.DRAG_COLUMN = this.curColIndex++;
        this.table.setWidget(HEADER_ROW, this.DRAG_COLUMN, (Widget)new LabelWidget(""));
    }

    private int getIdColumn() {
        return this.columns.indexOf(this.idColName) + this.CHKBOX_COLUMN + 1;
    }

    private RowDragController createDragDropHandler(FlexTableContainer table) {
        RootPanel boundaryPanel = RootPanel.get();
        Style boundaryStyle = boundaryPanel.getElement().getStyle();
        boundaryStyle.setProperty("position", "relative");
        RowDragController rowDragger = new RowDragController((AbsolutePanel)boundaryPanel);
        rowDragger.addDragHandler((DragHandler)new DragHandlerAdapter());
        RowDropController controller = new RowDropController(table, new MoveCallback(){

            @Override
            public void move(int currentIndex, int newIndex) {
                OrderableTable.this.isDirty = true;
            }
        });
        rowDragger.registerDropController((DropController)controller);
        return rowDragger;
    }

    private CheckBoxWidget createCheckbox() {
        CheckBoxWidget cBox = new CheckBoxWidget();
        cBox.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                int i = HEADER_ROW;
                int j = OrderableTable.this.CHKBOX_COLUMN;
                CheckBoxWidget topChk = (CheckBoxWidget)OrderableTable.this.table.getWidget(i, j);
                topChk.setValue(Boolean.valueOf(false));
            }
        });
        return cBox;
    }

    private CheckBoxWidget createTopCheckBox() {
        CheckBoxWidget cbox = new CheckBoxWidget();
        cbox.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                int i = 1;
                while (i < OrderableTable.this.table.getRowCount()) {
                    int j = OrderableTable.this.CHKBOX_COLUMN;
                    CheckBoxWidget src = (CheckBoxWidget)event.getSource();
                    CheckBoxWidget cur = (CheckBoxWidget)OrderableTable.this.table.getWidget(i, j);
                    cur.setValue(src.getValue());
                    ++i;
                }
            }
        });
        return cbox;
    }

    private void addTabChangeHandler() {
        TabChangeHandler handler = new TabChangeHandler(){

            @Override
            public void tabChange(TabChangeEvent event) {
                if (OrderableTable.this.isDirty) {
                    RulesComponent.setWorkaround((Panel)OrderableTable.this.getParent());
                    event.kill();
                    String msg = "Sure you want to move on buddy?";
                    Packages pkg = event.getPackage();
                    Panel target = event.getTarget();
                    Panel src = event.getSource();
                    RulesConfirmation.show(msg, OrderableTable.this.getChangeConfirm(pkg, src, target));
                }
            }
        };
        RulesComponent component = RulesComponent.getInstance();
        HandlerManager hman = component.getHandlerManager();
        hman.addHandler(TabChangeEvent.TYPE, (EventHandler)handler);
    }

    private ConfirmationHandler getChangeConfirm(final Packages pkg, Panel source, final Panel target) {
        return new ConfirmationHandler(){

            @Override
            public void confirm(ConfirmationEvent event) {
                RulesComponent.setWorkaround((Panel)OrderableTable.this.getParent());
                if (event.isConfirm()) {
                    RulesComponent.setWorkaround((Panel)OrderableTable.this.getParent());
                    RulesComponent.getInstance().setContents(pkg, target);
                    OrderableTable.this.isDirty = false;
                } else {
                    Panel p = RulesComponent.getWorkaround();
                    RulesComponent.getInstance().setContents(pkg, p);
                }
            }
        };
    }

    private String getText(int row, int col) {
        return this.table.getText(row + HEADER_ROW + 1, col + this.CHKBOX_COLUMN + 1);
    }

    private class RowIterator
    implements Iterator<TableRow> {
        int cursor = 0;
        OrderableTable tbl;

        public RowIterator(OrderableTable table) {
            this.tbl = table;
        }

        @Override
        public boolean hasNext() {
            return this.cursor < this.tbl.getRowCount();
        }

        @Override
        public TableRow next() {
            return this.tbl.getTableRow(this.cursor++);
        }

        @Override
        public void remove() {
        }
    }
}

