/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.rules.ui.client.normalization;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.TreeItem;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.ui.title.client.criteria.CriteriaListingPanel;
import com.tandbergtv.cms.portal.ui.title.client.criteria.PredicateRow;
import com.tandbergtv.cms.portal.ui.title.client.criteria.XmlTreeObject;
import com.tandbergtv.cms.portal.ui.title.client.model.search.IUITitleFilterNode;
import com.tandbergtv.cms.portal.ui.title.client.model.search.RulesOperator;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UITitleFilterListNode;
import com.tandbergtv.cms.rules.ui.client.RulesComponent;
import com.tandbergtv.cms.rules.ui.client.RulesConstants;
import com.tandbergtv.cms.rules.ui.client.data.UIAction;
import com.tandbergtv.cms.rules.ui.client.data.UIRule;
import com.tandbergtv.cms.rules.ui.client.normalization.NormalizationActionBox;
import com.tandbergtv.cms.rules.ui.client.normalization.NormalizationRulePanel;
import com.tandbergtv.cms.rules.ui.client.validation.RulePanelHelper;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TextBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class NormalizationRule
extends CriteriaListingPanel {
    private RulesConstants myConstants = RulesComponent.getInstance().getConstants();
    private UIRule rule;
    private List<NormalizationActionBox> actionBoxes = new ArrayList<NormalizationActionBox>();
    private VerticalContainer actionContainer = new VerticalContainer();
    private NormalizationRulePanel parentPanel;
    private Map<XmlTreeObject, TreeItem> variables = new HashMap<XmlTreeObject, TreeItem>();
    private TextBoxWidget indexWidget;
    private int index;

    public NormalizationRule(NormalizationRulePanel parentPanel, int index) {
        this(new UIRule(), parentPanel, index);
    }

    public NormalizationRule(UIRule rule, NormalizationRulePanel parentPanel, int index) {
        super(RulesComponent.getInstance().getSpecification());
        this.searchOperatorType = new RulesOperator();
        this.rule = rule;
        this.index = index;
        this.parentPanel = parentPanel;
        this.putTheUiTogether();
    }

    public UIRule getRule() {
        UIRule result = this.rule == null ? new UIRule() : this.rule;
        UITitleFilterListNode list = new UITitleFilterListNode();
        RulePanelHelper.populateTree(list, this.getRoot());
        result.setUiTitleFilterNode((IUITitleFilterNode)list);
        ArrayList<UIAction> actions = new ArrayList<UIAction>();
        for (NormalizationActionBox abox : this.actionBoxes) {
            actions.add(abox.getAction());
        }
        result.setActions(actions);
        return result;
    }

    private Widget buildReorder() {
        SimpleContainer reorderContainer = new SimpleContainer();
        reorderContainer.setStyleName("rule-order-pos");
        this.indexWidget = new TextBoxWidget(String.valueOf(this.index + 1));
        this.indexWidget.setVisibleLength(4);
        this.indexWidget.setMaxLength(4);
        this.indexWidget.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                int newIndex;
                String text = NormalizationRule.this.indexWidget.getText();
                try {
                    newIndex = Integer.parseInt(text) - 1;
                }
                catch (NumberFormatException ex) {
                    NormalizationRule.this.indexWidget.setText(String.valueOf(NormalizationRule.this.index + 1));
                    return;
                }
                NormalizationRule.this.parentPanel.reorder(NormalizationRule.this, newIndex);
            }
        });
        reorderContainer.add((Widget)this.indexWidget);
        return reorderContainer;
    }

    public void enableReorder(boolean reorderEnabled) {
        this.indexWidget.setReadOnly(!reorderEnabled);
        String style = reorderEnabled ? "rule-order-editable" : "rule-order-noneditable";
        this.indexWidget.setStyleName(style);
    }

    private void putTheUiTogether() {
        this.clear();
        this.setStyleName("validation-criteria-panel");
        this.add(this.buildReorder());
        this.add((Widget)super.getWarningMessageBox());
        this.add((Widget)new LabelWidget(this.myConstants.normalizationPanelLabel1()));
        ButtonWidget delButton = this.deleteButton();
        this.initializeTree(this.rule.getUiTitleFilterNode(), 1);
        this.add((Widget)new LabelWidget(this.myConstants.normalizationPanelLabel2()));
        this.add((Widget)this.actionContainer);
        this.add((Widget)delButton);
        this.enableReorder(this.parentPanel.isReorderEnabled());
        this.initializeActions();
    }

    private void initializeActions() {
        if (this.rule.getActions() == null || this.rule.getActions().size() == 0) {
            this.addAction();
        } else {
            for (UIAction uiaction : this.rule.getActions()) {
                NormalizationActionBox abox = new NormalizationActionBox(uiaction, this, this.variables.values());
                this.addAction(abox);
                abox.setAddVisiblilty(false);
            }
            this.actionBoxes.get(this.actionBoxes.size() - 1).setAddVisiblilty(true);
        }
        this.resetBoxDeletes();
    }

    public void addAction() {
        NormalizationActionBox abox = new NormalizationActionBox(this, this.variables.values());
        this.addAction(abox);
    }

    private void addAction(NormalizationActionBox abox) {
        this.actionBoxes.add(abox);
        this.actionContainer.add((Widget)abox);
        this.resetBoxDeletes();
    }

    public void removeAction(NormalizationActionBox abox) {
        this.actionBoxes.remove((Object)abox);
        this.actionContainer.remove((Widget)abox);
        if (this.actionBoxes.size() > 0) {
            this.actionBoxes.get(this.actionBoxes.size() - 1).setAddVisiblilty(true);
        }
        this.resetBoxDeletes();
    }

    private void resetBoxDeletes() {
        if (this.actionBoxes.size() > 0) {
            this.actionBoxes.get(0).setDeleteVisiblilty(this.actionBoxes.size() > 1);
        }
    }

    public boolean validate() {
        boolean result = super.validate();
        for (NormalizationActionBox abox : this.actionBoxes) {
            if (abox.validate()) continue;
            result = false;
        }
        return result;
    }

    private ButtonWidget deleteButton() {
        ButtonWidget button = new ButtonWidget(this.myConstants.delete(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                NormalizationRule.this.parentPanel.removeRuleFromContainer(NormalizationRule.this);
            }
        });
        button.addStyleDependentName("dataloss-button");
        return button;
    }

    public boolean canChangePredicateRow(PredicateRow row) {
        if (this.getRoot().predicateRowsWithTreeObject(row.getXmlTreeObject()) > 1) {
            return true;
        }
        for (NormalizationActionBox abox : this.actionBoxes) {
            if (abox.canRemovePredicateRow(row)) continue;
            String s = this.myConstants.ruleValidationRemoveActionBeforeChange();
            this.addWarningMessage(s);
            return false;
        }
        return true;
    }

    public void notifyChange(TreeItem item, XmlTreeObject oldObject) {
        this.variables.put((XmlTreeObject)item.getUserObject(), item);
        for (NormalizationActionBox abox : this.actionBoxes) {
            abox.addMatchedItem(item);
        }
        this.notifyRemoval(oldObject);
    }

    public void notifyRemoval(XmlTreeObject treeObject) {
        if (treeObject != null && !this.getRoot().contains(treeObject)) {
            this.variables.remove(treeObject);
            for (NormalizationActionBox abox : this.actionBoxes) {
                abox.removeMatchedItem(treeObject);
            }
        }
    }

    public void setCurrentIndex(int index) {
        this.index = index;
        this.indexWidget.setText(String.valueOf(index + 1));
    }

    public int getIndex() {
        return this.index;
    }
}

