/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.rules.ui.client.normalization;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.CellPanel;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.rules.ui.client.RulesComponent;
import com.tandbergtv.cms.rules.ui.client.UiActionService;
import com.tandbergtv.cms.rules.ui.client.UiActionServiceAsync;
import com.tandbergtv.cms.rules.ui.client.common.EventSelectPanel;
import com.tandbergtv.cms.rules.ui.client.common.MessageContainer;
import com.tandbergtv.cms.rules.ui.client.common.Permissions;
import com.tandbergtv.cms.rules.ui.client.common.RuleButtonPanel;
import com.tandbergtv.cms.rules.ui.client.common.RuleNamePanel;
import com.tandbergtv.cms.rules.ui.client.common.RulePanel;
import com.tandbergtv.cms.rules.ui.client.common.TitleFilterPanel;
import com.tandbergtv.cms.rules.ui.client.common.WizardPane;
import com.tandbergtv.cms.rules.ui.client.common.WizardPanel;
import com.tandbergtv.cms.rules.ui.client.common.rulelisting.RulesListingPanel;
import com.tandbergtv.cms.rules.ui.client.data.Packages;
import com.tandbergtv.cms.rules.ui.client.data.UIAction;
import com.tandbergtv.cms.rules.ui.client.data.UIRuleSet;
import com.tandbergtv.cms.rules.ui.client.normalization.NormalizationActionBox;
import com.tandbergtv.cms.rules.ui.client.normalization.NormalizationRulePanel;
import com.tandbergtv.cms.rules.ui.client.ruleServiceErrorHandling.ErrorMessageBuilder;
import com.tandbergtv.cms.rules.ui.client.ruleServiceErrorHandling.RuleServiceException;
import com.tandbergtv.cms.rules.ui.client.validation.RulePanelHelper;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import java.util.List;

public class NormalizationRuleSetPanel
extends RulePanel {
    private TitleFilterPanel panelTitleFilter;
    private NormalizationRulePanel normPanel;
    private ButtonWidget runButton;
    private RuleNamePanel ruleNamePanel;
    private EventSelectPanel panelEventSelect;
    private WizardPanel panelWizard = new WizardPanel();
    private BusyIndicator busyIndicator = new BusyIndicator();
    private MessageContainer messageContainer = new MessageContainer();

    public NormalizationRuleSetPanel() {
        super(Packages.NORMALIZATION);
    }

    protected void onUnload() {
        super.onUnload();
        this.busyIndicator.hide();
    }

    @Override
    protected void createPanel() {
        this.busyIndicator.center();
        if (!NormalizationActionBox.cacheLoaded()) {
            this.loadNormalizationActionsAsync();
        } else {
            this.populateUi();
        }
    }

    private void populateUi() {
        this.setStyleName("rule-panel");
        this.messageContainer.clear();
        this.add((Widget)this.messageContainer);
        this.setHeaderLabel();
        this.ruleNamePanel = new RuleNamePanel(this.ruleSet.getName(), this.ruleSet.isEnabled());
        RuleButtonPanel panelButton = new RuleButtonPanel(this.ruleSet.isNew());
        panelButton.setSaveClickHandler(this.getSaveHandler());
        panelButton.setCancelClickHandler(this.getDefaultCancelHandler());
        NeptuneSecurity security = RulesComponent.getInstance().getSecurity();
        if (security.isUserInRole(Permissions.MODIFY) || this.ruleSet.isNew() && security.isUserInRole(Permissions.CREATE)) {
            panelButton.addButton(this.createRunButton());
        }
        this.panelEventSelect = new EventSelectPanel(this.ruleSet);
        this.panelTitleFilter = new TitleFilterPanel(this.ruleSet);
        this.normPanel = new NormalizationRulePanel(this.ruleSet.getRules());
        WizardPane collapseRuleName = new WizardPane((CellPanel)this.ruleNamePanel, this.myConstants.wizardRuleName());
        WizardPane collapseEventSelect = new WizardPane((CellPanel)this.panelEventSelect, this.myConstants.wizardEventSelection());
        WizardPane collapseTitleFilter = new WizardPane((CellPanel)this.panelTitleFilter, this.myConstants.wizardTitleFilter());
        WizardPane collapseNormRules = new WizardPane((CellPanel)this.normPanel, this.myConstants.wizardNormalization());
        WizardPane collapseButton = new WizardPane((CellPanel)panelButton);
        this.panelWizard.clear();
        this.panelWizard.addStepPanel(this.myConstants.validationStep1(), collapseEventSelect);
        this.panelWizard.addStepPanel(this.myConstants.validationStep2(), collapseTitleFilter);
        this.panelWizard.addStepPanel(this.myConstants.normalizationStep3(), collapseNormRules);
        this.panelWizard.addStepPanel(this.myConstants.validationStep0(), collapseRuleName);
        this.panelWizard.addStepPanel(this.myConstants.validationStep4(), collapseButton);
        this.add((Widget)this.panelWizard);
        this.panelWizard.show(this.ruleSet.isNew());
        this.busyIndicator.hide();
    }

    private void loadNormalizationActionsAsync() {
        UiActionServiceAsync actionService = (UiActionServiceAsync)GWT.create(UiActionService.class);
        actionService.getActions(Packages.NORMALIZATION, (AsyncCallback<List<UIAction>>)new NeptuneAsyncCallback<List<UIAction>>(){

            public void onNeptuneFailure(Throwable caught) {
                NormalizationRuleSetPanel.this.busyIndicator.hide();
                Window.alert((String)(caught == null ? "" : caught.getMessage()));
            }

            public void onNeptuneSuccess(List<UIAction> result) {
                NormalizationActionBox.setActionsListCache(result);
                NormalizationRuleSetPanel.this.populateUi();
            }
        });
    }

    protected ButtonWidget createRunButton() {
        this.runButton = new ButtonWidget(this.myConstants.normalizationManualExecution());
        this.runButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                NormalizationRuleSetPanel.this.runButton.setEnabled(false);
                if (!NormalizationRuleSetPanel.this.panelWizard.validateAllItems()) {
                    NormalizationRuleSetPanel.this.runButton.setEnabled(true);
                    return;
                }
                if (Window.confirm((String)NormalizationRuleSetPanel.this.myConstants.normalizationManualExecutionAreYouSure())) {
                    UIRuleSet ruleset = NormalizationRuleSetPanel.this.buildRuleSet();
                    NormalizationRuleSetPanel.this.rulesService.saveAndRunRuleSet(ruleset, (AsyncCallback<?>)new NeptuneAsyncCallback<Integer>(){

                        public void onNeptuneFailure(Throwable caught) {
                            NormalizationRuleSetPanel.this.runButton.setEnabled(true);
                            if (caught instanceof RuleServiceException) {
                                List<String> messages = ErrorMessageBuilder.getErrorMessages((RuleServiceException)((Object)caught));
                                NormalizationRuleSetPanel.this.messageContainer.addErrorMessages(messages, true);
                            } else {
                                Window.alert((String)(caught == null ? "" : caught.getMessage()));
                            }
                        }

                        public void onNeptuneSuccess(Integer result) {
                            NormalizationRuleSetPanel.this.runButton.setEnabled(true);
                            RulesListingPanel listing = new RulesListingPanel(NormalizationRuleSetPanel.this.getPackageType());
                            RulesComponent.getInstance().setContents(NormalizationRuleSetPanel.this.getPackageType(), (Panel)listing);
                        }
                    });
                } else {
                    NormalizationRuleSetPanel.this.runButton.setEnabled(true);
                }
            }
        });
        this.runButton.addStyleDependentName("action-button");
        this.ruleNamePanel.getRuleEnabled().addClickHandler(this.createRuleEnabledClickHander());
        this.enableDisableRunButton();
        return this.runButton;
    }

    private ClickHandler createRuleEnabledClickHander() {
        return new ClickHandler(){

            public void onClick(ClickEvent event) {
                NormalizationRuleSetPanel.this.runButton.setEnabled(NormalizationRuleSetPanel.this.ruleNamePanel.isEnabled());
            }
        };
    }

    private void enableDisableRunButton() {
        this.runButton.setEnabled(this.ruleNamePanel.isEnabled());
    }

    private ClickHandler getSaveHandler() {
        return new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (!NormalizationRuleSetPanel.this.panelWizard.validateAllItems()) {
                    return;
                }
                final ButtonWidget button = (ButtonWidget)event.getSource();
                button.setEnabled(false);
                UIRuleSet ruleset = NormalizationRuleSetPanel.this.buildRuleSet();
                NormalizationRuleSetPanel.this.rulesService.saveRuleSet(ruleset, (AsyncCallback<Integer>)new NeptuneAsyncCallback<Integer>(){

                    public void onNeptuneFailure(Throwable caught) {
                        button.setEnabled(true);
                        if (caught instanceof RuleServiceException) {
                            List<String> messages = ErrorMessageBuilder.getErrorMessages((RuleServiceException)((Object)caught));
                            NormalizationRuleSetPanel.this.messageContainer.addErrorMessages(messages, true);
                        } else {
                            Window.alert((String)(caught == null ? "" : caught.getMessage()));
                        }
                    }

                    public void onNeptuneSuccess(Integer result) {
                        NormalizationRuleSetPanel.this.messageContainer.clear();
                        button.setEnabled(true);
                        RulesListingPanel listing = new RulesListingPanel(NormalizationRuleSetPanel.this.getPackageType());
                        RulesComponent.getInstance().setContents(NormalizationRuleSetPanel.this.getPackageType(), (Panel)listing);
                    }
                });
            }
        };
    }

    private UIRuleSet buildRuleSet() {
        UIRuleSet ruleset = new UIRuleSet();
        ruleset.setId(this.ruleSet.getId());
        ruleset.setEnabled(this.ruleNamePanel.isEnabled());
        ruleset.setName(this.ruleNamePanel.getRuleName());
        ruleset.setPackageId(Packages.NORMALIZATION);
        ruleset.setEvents(this.panelEventSelect.getEvents());
        ruleset.setRules(this.normPanel.getRules());
        ruleset.setTitleFilter(RulePanelHelper.getTitleFilterPanel(this.panelTitleFilter));
        return ruleset;
    }

    private void setHeaderLabel() {
        String newRule = this.myConstants.newNormalizationRule();
        String oldRule = String.valueOf(this.myConstants.normalizationRuleDetails()) + " " + this.ruleSet.getName();
        String header = this.ruleSet.getName().equals("") ? newRule : oldRule;
        this.setHeaderLabel(header);
    }
}

