/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.rules.ui.client.validation;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.CellPanel;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.rules.ui.client.RulesComponent;
import com.tandbergtv.cms.rules.ui.client.RulesConstants;
import com.tandbergtv.cms.rules.ui.client.UiActionService;
import com.tandbergtv.cms.rules.ui.client.UiActionServiceAsync;
import com.tandbergtv.cms.rules.ui.client.common.MessageContainer;
import com.tandbergtv.cms.rules.ui.client.common.RuleButtonPanel;
import com.tandbergtv.cms.rules.ui.client.common.RuleNamePanel;
import com.tandbergtv.cms.rules.ui.client.common.RulePanel;
import com.tandbergtv.cms.rules.ui.client.common.TitleFilterPanel;
import com.tandbergtv.cms.rules.ui.client.common.WizardPane;
import com.tandbergtv.cms.rules.ui.client.common.WizardPanel;
import com.tandbergtv.cms.rules.ui.client.common.rulelisting.RulesListingPanel;
import com.tandbergtv.cms.rules.ui.client.data.Packages;
import com.tandbergtv.cms.rules.ui.client.data.UIAction;
import com.tandbergtv.cms.rules.ui.client.data.UIRuleSet;
import com.tandbergtv.cms.rules.ui.client.ruleServiceErrorHandling.ErrorMessageBuilder;
import com.tandbergtv.cms.rules.ui.client.ruleServiceErrorHandling.RuleServiceException;
import com.tandbergtv.cms.rules.ui.client.validation.RulePanelHelper;
import com.tandbergtv.cms.rules.ui.client.validation.ValidationCriteriaListingPanel;
import com.tandbergtv.cms.rules.ui.client.validation.ValidationCriteriaPanel;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import java.util.List;

public class ValidationRulePanel
extends RulePanel {
    private WizardPanel panelWizard = new WizardPanel();
    private RuleNamePanel ruleNamePanel;
    private TitleFilterPanel panelTitleFilter;
    private ValidationCriteriaPanel panelValidation;
    private RulesConstants myConstants = (RulesConstants)GWT.create(RulesConstants.class);
    private BusyIndicator busyIndicator = new BusyIndicator();
    private MessageContainer messageContainer = new MessageContainer();

    public ValidationRulePanel() {
        super(Packages.VALIDATION);
    }

    protected void onUnload() {
        super.onUnload();
        this.busyIndicator.hide();
    }

    @Override
    public void createPanel() {
        this.busyIndicator.center();
        if (!ValidationCriteriaListingPanel.cacheLoaded()) {
            this.getActionLookupAsync();
        } else {
            this.populateUi();
        }
    }

    private void populateUi() {
        this.setStyleName("rule-panel");
        this.messageContainer.clear();
        this.add((Widget)this.messageContainer);
        this.setHeaderLabel();
        this.ruleNamePanel = new RuleNamePanel(this.ruleSet.getName(), this.ruleSet.isEnabled());
        this.panelTitleFilter = new TitleFilterPanel(this.ruleSet);
        this.panelValidation = new ValidationCriteriaPanel(this.ruleSet);
        RuleButtonPanel panelButton = new RuleButtonPanel(this.ruleSet.isNew());
        panelButton.setSaveClickHandler(this.getSaveHandler());
        panelButton.setCancelClickHandler(this.getDefaultCancelHandler());
        WizardPane collapseRuleName = new WizardPane((CellPanel)this.ruleNamePanel, this.myConstants.wizardRuleName());
        WizardPane collapseTitleFilter = new WizardPane((CellPanel)this.panelTitleFilter, this.myConstants.wizardTitleFilter());
        WizardPane collapseValidation = new WizardPane((CellPanel)this.panelValidation, this.myConstants.wizardValidationCriteria());
        WizardPane collapseButton = new WizardPane((CellPanel)panelButton);
        this.panelWizard.clear();
        this.panelWizard.addStepPanel(this.myConstants.validationStep2(), collapseTitleFilter, this.myConstants.titleFilterInstructions());
        this.panelWizard.addStepPanel(this.myConstants.validationStep3(), collapseValidation, this.myConstants.validationCriteriaInstructions());
        this.panelWizard.addStepPanel(this.myConstants.validationStep0(), collapseRuleName, this.myConstants.ruleNameInstructions());
        this.panelWizard.addStepPanel(this.myConstants.validationStep4(), collapseButton, this.myConstants.reviewAndSaveInstructions());
        this.add((Widget)this.panelWizard);
        this.panelWizard.show(this.ruleSet.isNew());
        this.busyIndicator.hide();
    }

    private void getActionLookupAsync() {
        UiActionServiceAsync actionService = (UiActionServiceAsync)GWT.create(UiActionService.class);
        actionService.getActions(Packages.VALIDATION, (AsyncCallback<List<UIAction>>)new NeptuneAsyncCallback<List<UIAction>>(){

            public void onNeptuneFailure(Throwable caught) {
                Window.alert((String)(caught == null ? "" : caught.getMessage()));
            }

            public void onNeptuneSuccess(List<UIAction> result) {
                ValidationCriteriaListingPanel.setCachedActions(result);
                ValidationRulePanel.this.populateUi();
            }
        });
    }

    private ClickHandler getSaveHandler() {
        return new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (!ValidationRulePanel.this.panelWizard.validateAllItems()) {
                    return;
                }
                final ButtonWidget button = (ButtonWidget)event.getSource();
                UIRuleSet ruleset = new UIRuleSet();
                ruleset.setId(ValidationRulePanel.this.ruleSet.getId());
                ruleset.setEnabled(ValidationRulePanel.this.ruleNamePanel.isEnabled());
                ruleset.setName(ValidationRulePanel.this.ruleNamePanel.getRuleName());
                ruleset.setPackageId(Packages.VALIDATION);
                ruleset.setTitleFilter(RulePanelHelper.getTitleFilterPanel(ValidationRulePanel.this.panelTitleFilter));
                ruleset.setRules(ValidationRulePanel.this.panelValidation.getRules());
                button.setEnabled(false);
                ValidationRulePanel.this.rulesService.saveRuleSet(ruleset, (AsyncCallback<Integer>)new NeptuneAsyncCallback<Integer>(){

                    public void onNeptuneFailure(Throwable caught) {
                        button.setEnabled(true);
                        if (caught instanceof RuleServiceException) {
                            List<String> messages = ErrorMessageBuilder.getErrorMessages((RuleServiceException)((Object)caught));
                            ValidationRulePanel.this.messageContainer.addErrorMessages(messages, true);
                        } else {
                            Window.alert((String)(caught == null ? "" : caught.getMessage()));
                        }
                    }

                    public void onNeptuneSuccess(Integer result) {
                        ValidationRulePanel.this.messageContainer.clear();
                        button.setEnabled(true);
                        RulesListingPanel listing = new RulesListingPanel(ValidationRulePanel.this.getPackageType());
                        RulesComponent.getInstance().setContents(ValidationRulePanel.this.getPackageType(), (Panel)listing);
                    }
                });
            }
        };
    }

    private void setHeaderLabel() {
        String newRule = this.myConstants.newValidationRule();
        String ruleName = String.valueOf(this.myConstants.validationRuleDetails()) + " " + this.ruleSet.getName();
        String headerString = this.ruleSet.getName().isEmpty() ? newRule : ruleName;
        this.setHeaderLabel(headerString);
    }
}

