/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.ui.title.client.criteria;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.HasMouseOutHandlers;
import com.google.gwt.event.dom.client.HasMouseOverHandlers;
import com.google.gwt.event.dom.client.MouseOutEvent;
import com.google.gwt.event.dom.client.MouseOutHandler;
import com.google.gwt.event.dom.client.MouseOverEvent;
import com.google.gwt.event.dom.client.MouseOverHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.ui.TreeItem;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.ui.title.client.TitleConstants;
import com.tandbergtv.cms.portal.ui.title.client.criteria.CriteriaListingPanel;
import com.tandbergtv.cms.portal.ui.title.client.criteria.PredicateList;
import com.tandbergtv.cms.portal.ui.title.client.criteria.PredicateRowBase;
import com.tandbergtv.cms.portal.ui.title.client.criteria.TreeCreator;
import com.tandbergtv.cms.portal.ui.title.client.criteria.ValueList;
import com.tandbergtv.cms.portal.ui.title.client.criteria.XmlSelection;
import com.tandbergtv.cms.portal.ui.title.client.criteria.XmlSelectionHandler;
import com.tandbergtv.cms.portal.ui.title.client.criteria.XmlTreeObject;
import com.tandbergtv.cms.portal.ui.title.client.model.datatype.UIFieldDataType;
import com.tandbergtv.cms.portal.ui.title.client.model.search.ParamType;
import com.tandbergtv.cms.portal.ui.title.client.model.search.RulesOperator;
import com.tandbergtv.cms.portal.ui.title.client.model.search.SearchOperator;
import com.tandbergtv.cms.portal.ui.title.client.model.search.TitleOperator;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UITitleFilterValueNode;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.CheckBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ListBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TextBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import java.util.Collection;
import java.util.List;

public class PredicateRow
extends PredicateRowBase
implements MouseOverHandler,
MouseOutHandler,
HasMouseOverHandlers,
HasMouseOutHandlers {
    private SearchOperator searchOperator;
    private ButtonWidget btnParen;
    private ButtonWidget btnAdd;
    private ButtonWidget btnDelete;
    private ListBoxWidget<SearchOperator> operatorList;
    private TextBoxWidget txtXmlField;
    private ValueList dataValue;
    private CriteriaListingPanel root;
    private XmlTreeObject xmlTreeObject;
    private CheckBoxWidget checkBox;
    private boolean isDeleted;
    private VerticalContainer siblingContainer = new VerticalContainer();
    private int maxLevels = 2;
    private TreeItem evalChild;
    private static final TitleConstants myConstants = (TitleConstants)GWT.create(TitleConstants.class);

    public PredicateRow(CriteriaListingPanel parentContainer) {
        this.root = parentContainer;
        this.isDeleted = false;
        this.setSearchOperator(this.root.getSearchOperator());
        this.putUiTogther();
    }

    public PredicateRow(CriteriaListingPanel parentContainer, TreeItem treeItem) {
        this(parentContainer);
        this.evalChild = TreeCreator.cloneRootAssetType(treeItem);
        this.setSearchOperator(new TitleOperator());
    }

    private void filterOperatorList(XmlTreeObject obj) {
        SearchOperator selectedItem = (SearchOperator)this.operatorList.getSelectedItem();
        boolean newListContainsSI = false;
        this.operatorList.clear();
        String xpath = obj.getXpath();
        UIFieldDataType dataType = obj.getDataType();
        SearchOperator sop = this.getSearchOperator();
        List<SearchOperator> operators = sop.getOperators(xpath, dataType);
        for (SearchOperator operator : operators) {
            String strItem = operator.toString();
            this.operatorList.addItem(myConstants.getString(strItem), (Object)operator);
            if (selectedItem == null || !operator.equals(selectedItem)) continue;
            newListContainsSI = true;
        }
        if (newListContainsSI) {
            this.operatorList.setSelectedItem((Object)selectedItem);
        }
        SearchOperator selectedOperator = (SearchOperator)this.operatorList.getSelectedItem();
        this.getDataValue().resetField(selectedOperator, dataType);
    }

    public void putUiTogther() {
        this.txtXmlField = new TextBoxWidget();
        this.dataValue = new ValueList();
        this.operatorList = PredicateRow.createOperatorList();
        this.operatorList.addChangeHandler(this.getOperatorListChangeHandler());
        this.checkBox = new CheckBoxWidget();
        this.checkBox.setText(myConstants.caseInsensitive());
        this.checkBox.setVisible(false);
        this.btnParen = this.createParenButton();
        this.btnAdd = this.createAddButton();
        this.btnDelete = this.createRemoveButton();
        this.txtXmlField.setReadOnly(true);
        this.txtXmlField.addStyleName("black-txt");
        this.txtXmlField.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (PredicateRow.this.canChangePredicateRow()) {
                    int x = PredicateRow.this.txtXmlField.getAbsoluteLeft();
                    int y = PredicateRow.this.txtXmlField.getAbsoluteTop();
                    PredicateRow.this.getXmlSelection().show(x, y, PredicateRow.this.xmlTreeObject, PredicateRow.this.getSelectHandler(), PredicateRow.this.evalChild);
                }
            }
        });
        HorizontalContainer horPanel = new HorizontalContainer();
        horPanel.add((Widget)this.txtXmlField);
        horPanel.add(this.operatorList);
        horPanel.add((Widget)this.dataValue);
        horPanel.add((Widget)this.btnParen);
        horPanel.add((Widget)this.btnAdd);
        horPanel.add((Widget)this.btnDelete);
        horPanel.add((Widget)this.checkBox);
        this.dataValue.setVisible(true);
        this.xmlTreeObject = null;
        this.add((Widget)horPanel);
        this.add((Widget)this.siblingContainer);
        this.addMouseOverHandler(this);
        this.addMouseOutHandler(this);
        this.setRowEnabled(false);
        this.add((Widget)this.createContainer());
    }

    private ChangeHandler getOperatorListChangeHandler() {
        return new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                if (PredicateRow.this.operatorList.getSelectedItem() == RulesOperator.EVALCHILDFIELDS) {
                    String asset = PredicateRow.this.xmlTreeObject.getAssetType();
                    String xpath = PredicateRow.this.xmlTreeObject.getXpath();
                    TreeItem item = PredicateRow.this.getXmlSelection().findItem(asset, xpath);
                    PredicateRow pred = new PredicateRow(PredicateRow.this.root, item);
                    PredicateRow.this.addChildRow(pred);
                } else {
                    for (PredicateRowBase row : PredicateRow.this.children) {
                        PredicateRow.this.childrenPanel.remove((Widget)row);
                    }
                    PredicateRow.this.children.clear();
                    SearchOperator op = (SearchOperator)PredicateRow.this.operatorList.getSelectedItem();
                    UIFieldDataType dataType = PredicateRow.this.xmlTreeObject.getDataType();
                    PredicateRow.this.dataValue.resetField(op, dataType);
                    PredicateRow.this.setCheckBoxVisibility(PredicateRow.this.isSensitiveVisible(dataType, op));
                }
            }
        };
    }

    public XmlSelectionHandler getSelectHandler() {
        return new XmlSelectionHandler(){

            @Override
            public void onXmlSelection(TreeItem item) {
                PredicateRow.this.updateField(item);
            }

            @Override
            public boolean isSelectable(TreeItem item) {
                XmlTreeObject tree = (XmlTreeObject)item.getUserObject();
                String aType = tree.getAssetType();
                String xpath = tree.getXpath();
                if (xpath == null || aType.equals(xpath)) {
                    return PredicateRow.this.getSearchOperator().allowsAssets();
                }
                return true;
            }
        };
    }

    private void setRowEnabled(boolean enabled) {
        this.btnDelete.setVisible(enabled);
        this.btnAdd.setVisible(enabled && this.isFirstRow());
        this.btnParen.setVisible(enabled && this.getLevel() < this.maxLevels);
    }

    public void setPredicate(UITitleFilterValueNode predicate) {
        String sectionType = predicate.getSectionType();
        String xpath = predicate.getName();
        SearchOperator searchOp = predicate.getSearchOperator();
        boolean isIgnoreCase = predicate.isIgnoreCase();
        XmlTreeObject obj = this.getXmlSelection().findObject(sectionType, xpath);
        this.setXmlField(obj.getFullDisplayName());
        this.filterOperatorList(obj);
        this.setOperatorList(predicate.getSearchOperator());
        this.setCheckBoxVisibility(this.isSensitiveVisible(obj.getDataType(), searchOp));
        UIFieldDataType type = obj.getDataType();
        List<String> values = predicate.getValues();
        this.dataValue.resetField(searchOp, type, values);
        this.checkBox.setValue(Boolean.valueOf(isIgnoreCase));
        this.xmlTreeObject = obj;
        if (!this.isEvalChild()) {
            TreeItem item = this.getXmlSelection().findItem(sectionType, xpath);
            this.root.notifyChange(item, null);
        }
    }

    private boolean isSensitiveVisible(UIFieldDataType type, SearchOperator op) {
        return this.isItemString(type) && !op.equals(SearchOperator.ISEMPTY) && !op.equals(SearchOperator.ISNOTEMPTY);
    }

    private boolean isItemString(UIFieldDataType dataType) {
        return dataType != null && dataType.getName().equals("string");
    }

    private static ListBoxWidget<SearchOperator> createOperatorList() {
        ListBoxWidget list = new ListBoxWidget();
        Collection<SearchOperator> operators = SearchOperator.values();
        for (SearchOperator oper : operators) {
            String strItem = oper.toString();
            list.addItem(myConstants.getString(strItem), (Object)oper);
        }
        return list;
    }

    public void addSibling(PredicateList sibling) {
        this.siblingContainer.add((Widget)sibling);
        sibling.setParentList(this.getParentList());
        this.getParentList().getChildRowNodes().add(sibling);
    }

    public CriteriaListingPanel getRoot() {
        return this.root;
    }

    public boolean isEvalChild() {
        return this.evalChild != null;
    }

    public void setEvalChild(TreeItem evalChild) {
        this.evalChild = evalChild;
    }

    private void setOperatorList(SearchOperator operator) {
        this.operatorList.setSelectedItem((Object)operator);
    }

    private ButtonWidget createParenButton() {
        ButtonWidget button = new ButtonWidget("( )", new ClickHandler(){

            public void onClick(ClickEvent event) {
                PredicateRow row1 = new PredicateRow(PredicateRow.this.root);
                PredicateRow row2 = new PredicateRow(PredicateRow.this.root);
                PredicateList list = new PredicateList();
                list.addChildRow(row1);
                list.addChildRow(row2);
                row1.setMaxLevels(PredicateRow.this.getMaxLevels());
                row2.setMaxLevels(PredicateRow.this.getMaxLevels());
                PredicateRow.this.addSibling(list);
            }
        });
        button.setTitle(myConstants.addChildCriteria());
        button.addStyleDependentName("action-button");
        return button;
    }

    private ButtonWidget createAddButton() {
        ButtonWidget button = new ButtonWidget("+", new ClickHandler(){

            public void onClick(ClickEvent event) {
                ButtonWidget button = (ButtonWidget)event.getSource();
                PredicateRow.this.addNewRow(button);
            }
        });
        button.addStyleDependentName("action-button");
        button.setTitle(myConstants.addSiblingCriteria());
        return button;
    }

    private void addNewRow(ButtonWidget button) {
        PredicateRow newRow;
        PredicateRow parent = (PredicateRow)button.getParent().getParent();
        PredicateRowBase list = parent.getParentList();
        if (parent.isEvalChild()) {
            PredicateRow row = (PredicateRow)list;
            XmlTreeObject obj = row.getXmlTreeObject();
            TreeItem item = row.getXmlSelection().findItem(obj.getAssetType(), obj.getXpath());
            newRow = new PredicateRow(this.root, item);
        } else {
            newRow = new PredicateRow(this.root);
        }
        newRow.setMaxLevels(this.getMaxLevels());
        list.addChildRow(newRow);
    }

    private ButtonWidget createRemoveButton() {
        ButtonWidget button = new ButtonWidget("-", new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (PredicateRow.this.canChangePredicateRow()) {
                    PredicateRow.this.setDeleted();
                    for (PredicateRowBase row : PredicateRow.this.children) {
                        PredicateRow.this.childrenPanel.remove((Widget)row);
                    }
                    PredicateRow.this.children.clear();
                    if (PredicateRow.this.parentList instanceof PredicateList) {
                        PredicateList parent = (PredicateList)PredicateRow.this.parentList;
                        parent.cleanUpOperatorListVisible();
                        if (parent.treeIsEmpty()) {
                            PredicateRow.this.root.setAddButtonVisible(true);
                        }
                    }
                    PredicateRow.this.root.notifyRemoval(PredicateRow.this.xmlTreeObject);
                }
            }
        });
        button.setTitle(myConstants.removeCriteria());
        button.addStyleDependentName("action-button");
        return button;
    }

    public XmlSelection getXmlSelection() {
        return CriteriaListingPanel.getXmlSelection();
    }

    private void setSearchOperator(SearchOperator searchOperator) {
        this.searchOperator = searchOperator;
    }

    private SearchOperator getSearchOperator() {
        return this.searchOperator;
    }

    public boolean canChangePredicateRow() {
        this.root.clearWarningMessages();
        if (this.parentList instanceof PredicateRow) {
            return true;
        }
        boolean result = true;
        if (!this.root.canChangePredicateRow(this)) {
            result = false;
        }
        return result;
    }

    public void onMouseOver(MouseOverEvent event) {
        this.setRowEnabled(true);
    }

    public void onMouseOut(MouseOutEvent event) {
        this.setRowEnabled(false);
    }

    public HandlerRegistration addMouseOutHandler(MouseOutHandler handler) {
        return this.addDomHandler((EventHandler)handler, MouseOutEvent.getType());
    }

    public HandlerRegistration addMouseOverHandler(MouseOverHandler handler) {
        return this.addDomHandler((EventHandler)handler, MouseOverEvent.getType());
    }

    @Override
    public boolean validate() {
        boolean result = true;
        for (PredicateRowBase pr : this.children) {
            if (pr.validate()) continue;
            result = false;
        }
        if (!this.isDeleted() && this.txtXmlField.getValue().equals("")) {
            this.txtXmlField.addStyleName("pinkbox");
            result = false;
        }
        if (!this.isDeleted() && !this.dataValue.validate()) {
            result = false;
        }
        return result;
    }

    public ParamType getParamType() {
        SearchOperator operator = (SearchOperator)this.operatorList.getSelectedItem();
        return operator.multiValued() ? ParamType.LIST : ParamType.VALUE;
    }

    public int getLevel() {
        int i = 0;
        PredicateRowBase node = this;
        while (node != null) {
            ++i;
            node = node.getParentList();
        }
        return i - 1;
    }

    public boolean isFirstRow() {
        PredicateRow firstUndeleted = null;
        for (PredicateRowBase base : this.getParentList().getChildRowNodes()) {
            if (!(base instanceof PredicateRow)) continue;
            PredicateRow row = (PredicateRow)base;
            if (((PredicateRow)base).isDeleted) continue;
            firstUndeleted = row;
            break;
        }
        return this == firstUndeleted;
    }

    public void updateField(TreeItem item) {
        XmlTreeObject oldObj = this.xmlTreeObject;
        XmlTreeObject itemObj = (XmlTreeObject)item.getUserObject();
        this.txtXmlField.addStyleName("whitebox");
        this.setXmlField(itemObj.getFullDisplayName());
        this.setXmlTreeObject(itemObj);
        this.filterOperatorList(itemObj);
        this.setCheckBoxVisibility(this.isSensitiveVisible(itemObj.getDataType(), (SearchOperator)this.operatorList.getSelectedItem()));
        Object userObj = item.getUserObject();
        if (!(this.isEvalChild() || oldObj != null && oldObj.equals(userObj))) {
            this.root.notifyChange(item, oldObj);
        }
    }

    public boolean hasContents() {
        return !this.txtXmlField.getValue().equals("");
    }

    public ValueList getDataValue() {
        return this.dataValue;
    }

    public ListBoxWidget<SearchOperator> getOperatorList() {
        return this.operatorList;
    }

    public List<String> getValue() {
        return this.dataValue.getValues();
    }

    public boolean valueIsEmpty() {
        return this.dataValue.isEmpty();
    }

    public void setXmlField(String s) {
        this.txtXmlField.setText(s);
        this.txtXmlField.setTitle(s);
    }

    public String getXmlField() {
        return this.txtXmlField.getText();
    }

    public TextBoxWidget getTxtXmlField() {
        return this.txtXmlField;
    }

    public XmlTreeObject getXmlTreeObject() {
        return this.xmlTreeObject;
    }

    public void setXmlTreeObject(XmlTreeObject xmlTreeObject) {
        this.xmlTreeObject = xmlTreeObject;
    }

    public void setDeleted() {
        this.clear();
        this.add((Widget)this.siblingContainer);
        this.isDeleted = true;
    }

    public boolean isDeleted() {
        return this.isDeleted;
    }

    public void setMaxLevels(int maxLevels) {
        this.maxLevels = maxLevels;
    }

    public int getMaxLevels() {
        return this.maxLevels;
    }

    public boolean isIgnoreCase() {
        return ((SearchOperator)this.getOperatorList().getSelectedItem()).hasRightSide() && this.checkBox.getValue() != false;
    }

    public void setCheckBoxVisibility(boolean visible) {
        this.checkBox.setVisible(visible);
    }
}

