/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.ui.title.client.model.datatype;

import com.tandbergtv.cms.portal.ui.title.client.model.datatype.IUIFieldDataTypeVisitor;
import com.tandbergtv.cms.portal.ui.title.client.model.datatype.UIFieldDataType;

public class IntegerDataType
extends UIFieldDataType {
    private static final String maxLongString = "9223372036854775807";
    private static final String minLongString = "-9223372036854775808".substring(1);
    public static final String NAME = "integer";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getDisplayName() {
        return NAMES != null ? NAMES.integerName() : this.getName();
    }

    @Override
    public void accept(IUIFieldDataTypeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public boolean isValid(String str) {
        String digits;
        boolean isNegative;
        block9: {
            block8: {
                block7: {
                    try {
                        if (!str.isEmpty()) break block7;
                        return true;
                    }
                    catch (NumberFormatException ex) {
                        return false;
                    }
                }
                isNegative = str.startsWith("-");
                digits = isNegative ? str.substring(1) : str;
                if (digits.length() <= maxLongString.length()) break block8;
                return false;
            }
            if (this.allDigit(digits)) break block9;
            return false;
        }
        if (digits.length() == maxLongString.length()) {
            if (isNegative) {
                return digits.compareTo(minLongString) <= 0;
            }
            return digits.compareTo(maxLongString) <= 0;
        }
        return true;
    }

    private boolean allDigit(String str) {
        char[] chars;
        char[] cArray = chars = str.toCharArray();
        int n = chars.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c < '0' || c > '9') {
                return false;
            }
            ++n2;
        }
        return true;
    }
}

