/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.ui.title.client.view.datatype;

import com.google.gwt.event.dom.client.HasBlurHandlers;
import com.google.gwt.event.dom.client.HasFocusHandlers;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Focusable;
import com.google.gwt.user.client.ui.HasValue;

public abstract class DataTypeWidget<DataType>
extends Composite
implements HasValue<DataType>,
Focusable,
HasBlurHandlers,
HasFocusHandlers {
    protected String toolTip;
    protected String errorToolTip;
    protected boolean validationError = false;
    protected String validationToolTip;
    protected static final String ERROR_STYLE = "dataTypeError";

    protected DataTypeWidget() {
    }

    public abstract boolean isValidValue();

    public abstract String getTextValue();

    public abstract void setTextValue(String var1);

    public void showValidationError(String toolTip) {
        this.validationToolTip = toolTip;
        this.validationError = true;
        this.updateWidgetState();
    }

    public void clearValidationError() {
        this.validationToolTip = null;
        this.validationError = false;
        this.updateWidgetState();
    }

    public boolean hasValidationError() {
        return this.validationError;
    }

    public abstract boolean isReadOnly();

    public abstract void setReadOnly(boolean var1);

    public abstract boolean isEnabled();

    public abstract void setEnabled(boolean var1);

    public String getToolTip() {
        return this.toolTip;
    }

    public void setToolTip(String toolTip) {
        this.toolTip = toolTip;
        this.updateToolTip();
    }

    public String getErrorToolTip() {
        return this.errorToolTip;
    }

    public void setErrorToolTip(String errorToolTip) {
        this.errorToolTip = errorToolTip;
        this.updateToolTip();
    }

    protected boolean isInErrorState() {
        return !this.isValidValue() || this.validationError;
    }

    protected void updateWidgetState() {
        this.updateStyle();
        this.updateToolTip();
    }

    protected abstract void updateStyle();

    protected void updateToolTip() {
        String currentToolTip = null;
        if (this.validationError) {
            currentToolTip = this.validationToolTip;
        }
        if (!this.isValidValue() && this.isBlank(currentToolTip)) {
            currentToolTip = this.errorToolTip;
        }
        if (this.isBlank(currentToolTip)) {
            currentToolTip = this.toolTip;
        }
        this.setCurrentToolTip(currentToolTip);
    }

    private boolean isBlank(String value) {
        return value == null || value.trim().length() == 0;
    }

    protected abstract void setCurrentToolTip(String var1);

    public abstract String getCurrentToolTip();
}

