/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.ui.title.client.view.datatype.factory;

import com.google.gwt.core.client.GWT;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.option.UIBooleanOption;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.option.UIFloatOption;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.option.UIIntegerOption;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.option.UIStringOption;
import com.tandbergtv.cms.portal.ui.title.client.view.datatype.DataTypeWidget;
import com.tandbergtv.cms.portal.ui.title.client.view.datatype.TypedComboBoxWidget;
import com.tandbergtv.cms.portal.ui.title.client.view.datatype.TypedDateBoxWidget;
import com.tandbergtv.cms.portal.ui.title.client.view.datatype.TypedListBoxWidget;
import com.tandbergtv.cms.portal.ui.title.client.view.datatype.TypedTextAreaWidget;
import com.tandbergtv.cms.portal.ui.title.client.view.datatype.TypedTextBoxWidget;
import com.tandbergtv.cms.portal.ui.title.client.view.datatype.converter.BooleanConverter;
import com.tandbergtv.cms.portal.ui.title.client.view.datatype.converter.DateConverter;
import com.tandbergtv.cms.portal.ui.title.client.view.datatype.converter.FloatConverter;
import com.tandbergtv.cms.portal.ui.title.client.view.datatype.converter.IntegerConverter;
import com.tandbergtv.cms.portal.ui.title.client.view.datatype.converter.StringConverter;
import com.tandbergtv.cms.portal.ui.title.client.view.datatype.factory.BooleanWidgetConfiguration;
import com.tandbergtv.cms.portal.ui.title.client.view.datatype.factory.DataTypeWidgetFactory;
import com.tandbergtv.cms.portal.ui.title.client.view.datatype.factory.DataTypeWidgetMessages;
import com.tandbergtv.cms.portal.ui.title.client.view.datatype.factory.DateWidgetConfiguration;
import com.tandbergtv.cms.portal.ui.title.client.view.datatype.factory.FloatWidgetConfiguration;
import com.tandbergtv.cms.portal.ui.title.client.view.datatype.factory.IntegerWidgetConfiguration;
import com.tandbergtv.cms.portal.ui.title.client.view.datatype.factory.StringWidgetConfiguration;
import com.tandbergtv.cms.portal.ui.title.client.view.datatype.factory.TimeWidgetConfiguration;

public class DefaultDataTypeWidgetFactory
extends DataTypeWidgetFactory {
    private DataTypeWidgetMessages messages = (DataTypeWidgetMessages)GWT.create(DataTypeWidgetMessages.class);

    protected DataTypeWidgetMessages getMessages() {
        return this.messages;
    }

    @Override
    public DataTypeWidget<Boolean> createBooleanWidget(BooleanWidgetConfiguration configuration) {
        BooleanConverter converter = new BooleanConverter();
        TypedListBoxWidget<Boolean> widget = new TypedListBoxWidget<Boolean>(converter);
        widget.addItem(this.messages.booleanWidgetUndefinedValue(), null);
        if (!configuration.hasOptions()) {
            widget.addItem(this.messages.booleanWidgetTrueValue(), new Boolean(true));
            widget.addItem(this.messages.booleanWidgetFalseValue(), new Boolean(false));
        } else {
            for (UIBooleanOption valueOption : configuration.getOptions()) {
                widget.addItem(valueOption.getName(), valueOption.getValue());
            }
        }
        widget.setToolTip(this.messages.booleanWidgetToolTip());
        widget.setErrorToolTip(this.messages.booleanWidgetErrorToolTip());
        return widget;
    }

    @Override
    public DataTypeWidget<Long> createIntegerWidget(IntegerWidgetConfiguration configuration) {
        IntegerConverter converter = new IntegerConverter();
        DataTypeWidget widget = null;
        if (!configuration.hasOptions()) {
            widget = new TypedTextBoxWidget<Long>(converter);
        } else if (!configuration.isAnyValueAllowed()) {
            TypedListBoxWidget<Long> listBox = new TypedListBoxWidget<Long>(new IntegerConverter());
            listBox.addItem("", null);
            for (UIIntegerOption valueOption : configuration.getOptions()) {
                listBox.addItem(valueOption.getName(), valueOption.getValue());
            }
            widget = listBox;
        } else {
            TypedComboBoxWidget<Long> combo = new TypedComboBoxWidget<Long>(new IntegerConverter());
            combo.addItem("", null);
            for (UIIntegerOption valueOption : configuration.getOptions()) {
                combo.addItem(valueOption.getName(), valueOption.getValue());
            }
            widget = combo;
        }
        widget.setToolTip(this.messages.integerWidgetToolTip());
        widget.setErrorToolTip(this.messages.integerWidgetErrorToolTip());
        return widget;
    }

    @Override
    public DataTypeWidget<String> createFloatWidget(FloatWidgetConfiguration configuration) {
        FloatConverter converter = new FloatConverter();
        DataTypeWidget widget = null;
        if (!configuration.hasOptions()) {
            widget = new TypedTextBoxWidget<String>(converter);
        } else if (!configuration.isAnyValueAllowed()) {
            TypedListBoxWidget<String> listBox = new TypedListBoxWidget<String>(converter);
            listBox.addItem("", null);
            for (UIFloatOption valueOption : configuration.getOptions()) {
                listBox.addItem(valueOption.getName(), valueOption.getValue());
            }
            widget = listBox;
        } else {
            TypedComboBoxWidget<String> combo = new TypedComboBoxWidget<String>(converter);
            combo.addItem("", null);
            for (UIFloatOption valueOption : configuration.getOptions()) {
                combo.addItem(valueOption.getName(), valueOption.getValue());
            }
            widget = combo;
        }
        widget.setToolTip(this.messages.floatWidgetToolTip());
        widget.setErrorToolTip(this.messages.floatWidgetErrorToolTip());
        return widget;
    }

    @Override
    public DataTypeWidget<String> createDateWidget(DateWidgetConfiguration configuration) {
        String inputFormat = "yyyy-MM-dd'T'HH:mm:ss";
        String dateFormat = configuration.getDateFormat();
        if (dateFormat == null || dateFormat.trim().length() == 0) {
            dateFormat = this.messages.dateWidgetFormat();
        }
        DateConverter converter = new DateConverter(inputFormat, dateFormat);
        TypedDateBoxWidget widget = new TypedDateBoxWidget(converter);
        widget.setToolTip(this.messages.dateWidgetToolTip(dateFormat));
        widget.setErrorToolTip(this.messages.dateWidgetErrorToolTip(dateFormat));
        return widget;
    }

    @Override
    public DataTypeWidget<String> createTimeWidget(TimeWidgetConfiguration configuration) {
        String inputFormat = "HH:mm:ss";
        String timeFormat = configuration.getTimeFormat();
        if (timeFormat == null || timeFormat.trim().length() == 0) {
            timeFormat = this.messages.timeWidgetFormat();
        }
        DateConverter converter = new DateConverter(inputFormat, timeFormat);
        TypedTextBoxWidget<String> widget = new TypedTextBoxWidget<String>(converter);
        widget.setToolTip(this.messages.timeWidgetToolTip(timeFormat));
        widget.setErrorToolTip(this.messages.timeWidgetErrorToolTip(timeFormat));
        return widget;
    }

    @Override
    public DataTypeWidget<String> createStringWidget(StringWidgetConfiguration configuration) {
        StringConverter converter = new StringConverter();
        DataTypeWidget widget = null;
        if (configuration.isLongForm()) {
            TypedTextAreaWidget<String> textArea = new TypedTextAreaWidget<String>(converter);
            textArea.setVisibleLines(5);
            widget = textArea;
        } else if (configuration.hasOptions() && !configuration.isAnyValueAllowed()) {
            TypedListBoxWidget<String> listBox = new TypedListBoxWidget<String>(converter);
            listBox.addItem("", null);
            for (UIStringOption option : configuration.getOptions()) {
                listBox.addItem(option.getName(), option.getValue());
            }
            widget = listBox;
        } else if (configuration.hasOptions()) {
            TypedComboBoxWidget<String> comboBox = new TypedComboBoxWidget<String>(converter);
            comboBox.addItem("", null);
            for (UIStringOption option : configuration.getOptions()) {
                comboBox.addItem(option.getName(), option.getValue());
            }
            widget = comboBox;
        } else {
            widget = new TypedTextBoxWidget<String>(converter);
        }
        widget.setToolTip(this.messages.stringWidgetToolTip());
        widget.setErrorToolTip(this.messages.stringWidgetErrorToolTip());
        return widget;
    }
}

