/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.ui.workflow.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.ui.workflow.client.IListResourceGroupQueues;
import com.tandbergtv.cms.ui.workflow.client.IListResourceGroupQueuesAsync;
import com.tandbergtv.cms.ui.workflow.client.PortletConstants;
import com.tandbergtv.cms.ui.workflow.client.Queue;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.HyperlinkWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.Portlet;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class ResourceGroupQueueListPortlet
extends Portlet {
    private VerticalContainer mainContainer;
    private IListResourceGroupQueuesAsync service;
    private PortletConstants constants;
    private NeptuneSecurity security;

    public ResourceGroupQueueListPortlet(NeptuneSecurity security, int refreshTimeMillis) {
        this.security = security;
        this.service = (IListResourceGroupQueuesAsync)GWT.create(IListResourceGroupQueues.class);
        this.constants = (PortletConstants)GWT.create(PortletConstants.class);
        this.setTitle(this.constants.queueTitle());
        this.mainContainer = new VerticalContainer();
        this.add((Widget)this.mainContainer);
        new Timer(){

            public void run() {
                ResourceGroupQueueListPortlet.this.reload();
            }
        }.scheduleRepeating(refreshTimeMillis);
    }

    public void reload() {
        this.service.getResourceGroupQueues((AsyncCallback<List<Queue>>)new NeptuneAsyncCallback<List<Queue>>(){

            public void onNeptuneFailure(Throwable caught) {
            }

            public void onNeptuneSuccess(List<Queue> queues) {
                ResourceGroupQueueListPortlet.this.mainContainer.clear();
                Collections.sort(queues, new Comparator<Queue>(){

                    @Override
                    public int compare(Queue o1, Queue o2) {
                        return o1.getName().compareTo(o2.getName());
                    }
                });
                for (Queue q : queues) {
                    LabelWidget name;
                    HorizontalContainer lineContainer = new HorizontalContainer();
                    if (ResourceGroupQueueListPortlet.this.security.isUserInRole("ResourceManagement_View")) {
                        name = new HyperlinkWidget(q.getName(), "Workflow.Resources.View.Queue?id=" + q.getId());
                        name.setStyleName("portlet-resGrpQList-link");
                        lineContainer.add((Widget)name);
                    } else {
                        name = new LabelWidget(q.getName());
                        name.setStyleName("portlet-resGrpQList-text");
                        lineContainer.add((Widget)name);
                    }
                    LabelWidget count = new LabelWidget(": " + q.getNumItemsInQueue());
                    count.setStyleName("portlet-resGrpQList-text");
                    lineContainer.add((Widget)count);
                    ResourceGroupQueueListPortlet.this.mainContainer.add((Widget)lineContainer);
                }
            }
        });
    }
}

