/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.ui.workflow.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.ui.workflow.client.IListResources;
import com.tandbergtv.cms.ui.workflow.client.IListResourcesAsync;
import com.tandbergtv.cms.ui.workflow.client.PortletConstants;
import com.tandbergtv.cms.ui.workflow.client.Resource;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ImageWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.FlexTableContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.Portlet;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class ResourceListPortlet
extends Portlet {
    private FlexTableContainer table;
    private IListResourcesAsync service = (IListResourcesAsync)GWT.create(IListResources.class);
    private PortletConstants constants = (PortletConstants)GWT.create(PortletConstants.class);

    public ResourceListPortlet(NeptuneSecurity security, int refreshTimeMillis) {
        this.setTitle(this.constants.resTitle());
        this.table = new FlexTableContainer();
        this.table.setStyleName("portlet-resourceList-table");
        this.add((Widget)this.table);
        new Timer(){

            public void run() {
                ResourceListPortlet.this.reload();
            }
        }.scheduleRepeating(refreshTimeMillis);
    }

    public void reload() {
        this.service.getResources((AsyncCallback<List<Resource>>)new NeptuneAsyncCallback<List<Resource>>(){

            public void onNeptuneFailure(Throwable caught) {
            }

            public void onNeptuneSuccess(List<Resource> resources) {
                ResourceListPortlet.this.table.clear();
                int rowCount = 0;
                Collections.sort(resources, new Comparator<Resource>(){

                    @Override
                    public int compare(Resource r1, Resource r2) {
                        return r1.getName().compareTo(r2.getName());
                    }
                });
                for (Resource resource : resources) {
                    ResourceListPortlet.this.table.setWidget(rowCount, 0, (Widget)ResourceListPortlet.this.getImage(resource.getState()));
                    ResourceListPortlet.this.table.getCellFormatter().setStyleName(rowCount, 0, "portlet-resourceList-statusImgCol");
                    ResourceListPortlet.this.table.setWidget(rowCount, 1, (Widget)new LabelWidget(resource.getName()));
                    ResourceListPortlet.this.table.getCellFormatter().setStyleName(rowCount, 1, "portlet-resourceList-nameCol");
                    if (resource.isCurrentlyUsed()) {
                        ImageWidget image = new ImageWidget("images/icon_res_currUsed.png");
                        image.setTitle(ResourceListPortlet.this.constants.resCurrentlyUsed());
                        ResourceListPortlet.this.table.setWidget(rowCount, 2, (Widget)image);
                        ResourceListPortlet.this.table.getCellFormatter().setStyleName(rowCount, 2, "portlet-resourceList-currUsedImgCol");
                    }
                    ++rowCount;
                }
            }
        });
    }

    private ImageWidget getImage(Resource.State state) {
        ImageWidget image = new ImageWidget("images/icon_circ_" + state.name() + ".png");
        image.setTitle(this.constants.getString("res" + state.name()));
        return image;
    }
}

