/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.ui.workflow.client;

import com.google.gwt.user.client.Random;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.ITitleProgressService;
import com.tandbergtv.cms.ui.workflow.client.ResourceGroupQueueListPortlet;
import com.tandbergtv.cms.ui.workflow.client.ResourceListPortlet;
import com.tandbergtv.cms.ui.workflow.client.UserTaskListPortlet;
import com.tandbergtv.cms.ui.workflow.client.WOStatusPortlet;
import com.tandbergtv.neptune.widgettoolkit.client.application.PortletFactory;
import com.tandbergtv.neptune.widgettoolkit.client.application.Service;
import com.tandbergtv.neptune.widgettoolkit.client.component.ComponentBase;
import com.tandbergtv.neptune.widgettoolkit.client.menu.GroupMenuItem;
import com.tandbergtv.neptune.widgettoolkit.client.menu.MenuItemBase;
import com.tandbergtv.neptune.widgettoolkit.client.menu.WidgetMenuItem;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.FrameWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.Portlet;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;
import java.util.ArrayList;
import java.util.List;

public class WorkflowComponent
extends ComponentBase {
    private static final String THIS_COMPONENT_NAME = "WatchPoint";

    public List<PortletFactory> listPortlets(final NeptuneSecurity security) {
        if (!security.isUserInRole("Home_Dashboard")) {
            return null;
        }
        ArrayList<PortletFactory> portletFactories = new ArrayList<PortletFactory>();
        int confRefreshTimeMillis = -1;
        try {
            confRefreshTimeMillis = Integer.parseInt((String)this.info.get("workflow.portlets.refreshTime"));
        }
        catch (Exception e) {
            // empty catch block
        }
        final int refreshTimeMillis = confRefreshTimeMillis != -1 ? confRefreshTimeMillis : 10000;
        portletFactories.add(new PortletFactory(){
            UserTaskListPortlet portlet;
            {
                this.portlet = new UserTaskListPortlet(security, refreshTimeMillis);
            }

            public Portlet getInstance() {
                this.portlet.reload();
                return this.portlet;
            }

            public void release(Portlet portlet) {
            }
        });
        portletFactories.add(new PortletFactory(){
            WOStatusPortlet portlet;
            {
                this.portlet = new WOStatusPortlet(security, refreshTimeMillis);
            }

            public Portlet getInstance() {
                this.portlet.reload();
                return this.portlet;
            }

            public void release(Portlet portlet) {
            }
        });
        portletFactories.add(new PortletFactory(){
            ResourceListPortlet portlet;
            {
                this.portlet = new ResourceListPortlet(security, refreshTimeMillis);
            }

            public Portlet getInstance() {
                this.portlet.reload();
                return this.portlet;
            }

            public void release(Portlet portlet) {
            }
        });
        portletFactories.add(new PortletFactory(){
            ResourceGroupQueueListPortlet portlet;
            {
                this.portlet = new ResourceGroupQueueListPortlet(security, refreshTimeMillis);
            }

            public Portlet getInstance() {
                this.portlet.reload();
                return this.portlet;
            }

            public void release(Portlet portlet) {
            }
        });
        return portletFactories;
    }

    public <E extends Service> List<E> listServices(Class<E> clazz, NeptuneSecurity security) {
        if (clazz.getName().equalsIgnoreCase(ITitleProgressService.class.getName())) {
            ArrayList<5> tpServices = new ArrayList<5>();
            tpServices.add(new ITitleProgressService(){

                public ITitleProgressService.Hyperlink getLink(String componentName, String entityName, String sourceId, String titleRevision) {
                    if (componentName != null && componentName.equals(WorkflowComponent.THIS_COMPONENT_NAME)) {
                        String processId = sourceId.substring(0, sourceId.indexOf(124));
                        String targetHistoryToken = "Workflow.Work Orders.Search.Id=" + processId;
                        return new ITitleProgressService.Hyperlink(componentName + " - " + entityName, targetHistoryToken);
                    }
                    return null;
                }
            });
            return tpServices;
        }
        return null;
    }

    public List<MenuItemBase> listTabs(NeptuneSecurity security) {
        Object anchorChangeListener;
        SimpleContainer panel;
        String url;
        String url2;
        String menuName;
        ArrayList<MenuItemBase> tabs = new ArrayList<MenuItemBase>();
        ArrayList<MenuItemBase> workflowGroup = new ArrayList<MenuItemBase>();
        if (security.isUserInRole("Home_Dashboard")) {
            menuName = "Dashboard";
            url2 = "/workflow/dashboardview.do?method=getDashBoard";
            this.addPanelToGroup(workflowGroup, "/workflow/dashboardview.do?method=getDashBoard", menuName);
        }
        if (security.isUserInRole("WorkOrderManagement_Create") || security.isUserInRole("WorkOrderManagement_View")) {
            ArrayList<MenuItemBase> workordersGroup = new ArrayList<MenuItemBase>();
            if (security.isUserInRole("WorkOrderManagement_Create")) {
                menuName = "Create";
                url = "/workflow/wfsprocess.do?method=createWorkOrderSetup";
                this.addPanelToGroup(workordersGroup, "/workflow/wfsprocess.do?method=createWorkOrderSetup", menuName);
            }
            if (security.isUserInRole("WorkOrderManagement_View")) {
                panel = new SimpleContainer();
                panel.setSize("100%", "100%");
                anchorChangeListener = new WidgetMenuItem.AnchorChangeListener(){

                    public void anchorChanged(String anchor) {
                        if (anchor.startsWith("WorkOrderNos")) {
                            String url = "/workflow/workOrderDetailsAction.do?method=getWorkOrdersBySearch&sourcePage=activity&pid=" + anchor.substring("WorkOrderNos".length() + 1);
                            WorkflowComponent.this.showFrame((Panel)panel, url);
                        } else if (anchor.startsWith("Id")) {
                            String url = "/workflow/workOrderTask.do?method=getWorkOrderTask&workOrderNo=" + anchor.substring("Id".length() + 1);
                            WorkflowComponent.this.showFrame((Panel)panel, url);
                        } else if (anchor.startsWith("Status")) {
                            String url = "/workflow/workOrderDetailsAction.do?method=getWorkOrdersBySearch&sourcePage=dashBoard&status=" + anchor.substring("Status".length() + 1);
                            WorkflowComponent.this.showFrame((Panel)panel, url);
                        } else {
                            String url = "/workflow/workOrderSearch.do?method=getWorkOrderSearchPage";
                            WorkflowComponent.this.showFrame((Panel)panel, url);
                        }
                    }
                };
                WidgetMenuItem woSearchViewPanel = new WidgetMenuItem("Search", (Widget)panel, anchorChangeListener);
                workordersGroup.add((MenuItemBase)woSearchViewPanel);
                menuName = "View Templates";
                String viewTemplatesUrl = "/workflow/viewtemplate.do?method=selectTemplateDetails";
                this.addPanelToGroup(workordersGroup, "/workflow/viewtemplate.do?method=selectTemplateDetails", menuName);
                menuName = "Selector Keys";
                String selectorKeysUrl = "/workflow/viewselectorkeys.do?method=getSelectorKeyDetails";
                this.addPanelToGroup(workordersGroup, "/workflow/viewselectorkeys.do?method=getSelectorKeyDetails", menuName);
            }
            if (security.isUserInRole("WorkOrderManagement_Modify")) {
                menuName = "Pause All/Resume All";
                url = "/workflow/pauseResumeAction.do?method=goToLogin";
                this.addPanelToGroup(workordersGroup, "/workflow/pauseResumeAction.do?method=goToLogin", menuName);
            }
            workflowGroup.add((MenuItemBase)new GroupMenuItem("Work Orders", workordersGroup));
        }
        if (security.isUserInRole("ResourceManagement_Create") || security.isUserInRole("ResourceManagement_View")) {
            ArrayList<MenuItemBase> resourcesGroup = new ArrayList<MenuItemBase>();
            if (security.isUserInRole("ResourceManagement_View")) {
                panel = new SimpleContainer();
                panel.setSize("100%", "100%");
                anchorChangeListener = new WidgetMenuItem.AnchorChangeListener(){

                    public void anchorChanged(String anchor) {
                        if (anchor.startsWith("Modify")) {
                            String url = "/workflow/resourceManagement.do?method=getResourceDetails&" + anchor.substring(7);
                            WorkflowComponent.this.showFrame((Panel)panel, url);
                        } else if (anchor.startsWith("Queue")) {
                            String url = "/workflow/resourceGroupQueueManagement.do?method=getResourceGroupQueue&" + anchor.substring(6);
                            WorkflowComponent.this.showFrame((Panel)panel, url);
                        } else {
                            String url = "/workflow/resourcesListManagement.do?method=getResourcesList";
                            WorkflowComponent.this.showFrame((Panel)panel, url);
                        }
                    }
                };
                WidgetMenuItem resourcesViewPanel = new WidgetMenuItem("View", (Widget)panel, anchorChangeListener);
                resourcesGroup.add((MenuItemBase)resourcesViewPanel);
            }
            if (security.isUserInRole("ResourceManagement_Create")) {
                menuName = "Create";
                url = "/workflow/resourceManagement.do?method=getResourceTypeDetails";
                this.addPanelToGroup(resourcesGroup, "/workflow/resourceManagement.do?method=getResourceTypeDetails", menuName);
            }
            workflowGroup.add((MenuItemBase)new GroupMenuItem("Resources", resourcesGroup));
        }
        if (security.isUserInRole("Monitoring_Create") || security.isUserInRole("Monitoring_View")) {
            ArrayList<MenuItemBase> monitoringGroup = new ArrayList<MenuItemBase>();
            if (security.isUserInRole("Monitoring_View")) {
                menuName = "View Alerts";
                url = "/workflow/toModule.do?prefix=/sysmonui&page=/checkAlertServerStatus.do?method=toListAlerts";
                this.addPanelToGroup(monitoringGroup, "/workflow/toModule.do?prefix=/sysmonui&page=/checkAlertServerStatus.do?method=toListAlerts", menuName);
            }
            if (security.isUserInRole("Monitoring_Create")) {
                menuName = "Create Alert";
                url = "/workflow/toModule.do?prefix=/sysmonui&page=/checkAlertServerStatus.do?method=toCreateAlert";
                this.addPanelToGroup(monitoringGroup, "/workflow/toModule.do?prefix=/sysmonui&page=/checkAlertServerStatus.do?method=toCreateAlert", menuName);
            }
            if (security.isUserInRole("Monitoring_View")) {
                menuName = "View Alert Patterns";
                url = "/workflow/toModule.do?prefix=/sysmonui&page=/checkAlertServerStatus.do?method=toListAlertPatterns";
                this.addPanelToGroup(monitoringGroup, "/workflow/toModule.do?prefix=/sysmonui&page=/checkAlertServerStatus.do?method=toListAlertPatterns", menuName);
            }
            if (security.isUserInRole("Monitoring_Create")) {
                menuName = "Create Alert Pattern";
                url = "/workflow/toModule.do?prefix=/sysmonui&page=/checkAlertServerStatus.do?method=toCreateAlertPattern";
                this.addPanelToGroup(monitoringGroup, "/workflow/toModule.do?prefix=/sysmonui&page=/checkAlertServerStatus.do?method=toCreateAlertPattern", menuName);
            }
            if (security.isUserInRole("Monitoring_View")) {
                menuName = "View Alert History";
                url = "/workflow/toModule.do?prefix=/sysmonui&page=/checkAlertServerStatus.do?method=toListAlertHistory";
                this.addPanelToGroup(monitoringGroup, "/workflow/toModule.do?prefix=/sysmonui&page=/checkAlertServerStatus.do?method=toListAlertHistory", menuName);
                menuName = "Repository Browser";
                String reposBrowsUrl = "/workflow/repositoryBrowsing.do?method=getRepository";
                this.addPanelToGroup(monitoringGroup, "/workflow/repositoryBrowsing.do?method=getRepository", menuName);
            }
            workflowGroup.add((MenuItemBase)new GroupMenuItem("Monitoring", monitoringGroup));
        }
        if (security.isUserInRole("UserTasks_PerformTask") || security.isUserInRole("UserTasks_PerformOthersTasks")) {
            final SimpleContainer panel2 = new SimpleContainer();
            panel2.setSize("100%", "100%");
            WidgetMenuItem.AnchorChangeListener anchorChangeListener2 = new WidgetMenuItem.AnchorChangeListener(){

                public void anchorChanged(String anchor) {
                    if (anchor.startsWith("Perform")) {
                        String url = "/workflow/wfstask.do?method=selectTaskInstance&task=" + anchor.substring("Perform?id=".length());
                        WorkflowComponent.this.showFrame((Panel)panel2, url);
                    } else {
                        String url = "/workflow/userTasksAction.do?method=getUserTasks";
                        WorkflowComponent.this.showFrame((Panel)panel2, url);
                    }
                }
            };
            workflowGroup.add((MenuItemBase)new WidgetMenuItem("User Tasks", (Widget)panel2, anchorChangeListener2));
        }
        if (security.isUserInRole("Reporting_View")) {
            menuName = "Reporting";
            url2 = "/workflow/reports.do?method=getReportsList";
            this.addPanelToGroup(workflowGroup, "/workflow/reports.do?method=getReportsList", menuName);
        }
        if (security.isUserInRole("Plugins_View")) {
            ArrayList<MenuItemBase> pluginsGroup = new ArrayList<MenuItemBase>();
            menuName = "View Resource Type Plugins";
            url = "/workflow/plugins.do?method=getResourceTypePlugins";
            this.addPanelToGroup(pluginsGroup, "/workflow/plugins.do?method=getResourceTypePlugins", menuName);
            menuName = "View Resource Group Plugins";
            String resGroupPluginUrl = "/workflow/plugins.do?method=getResourceGroupPlugins";
            this.addPanelToGroup(pluginsGroup, "/workflow/plugins.do?method=getResourceGroupPlugins", menuName);
            workflowGroup.add((MenuItemBase)new GroupMenuItem("Plugins", pluginsGroup));
        }
        if (workflowGroup.size() > 0) {
            tabs.add((MenuItemBase)new GroupMenuItem("Workflow", workflowGroup));
        }
        return tabs;
    }

    private void addPanelToGroup(List<MenuItemBase> group, final String url, String menuName) {
        final SimpleContainer panel = new SimpleContainer();
        panel.setSize("100%", "100%");
        WidgetMenuItem.AnchorChangeListener anchorChangeListener = new WidgetMenuItem.AnchorChangeListener(){

            public void anchorChanged(String anchor) {
                WorkflowComponent.this.showFrame((Panel)panel, url);
            }
        };
        WidgetMenuItem menuItem = new WidgetMenuItem(menuName, (Widget)panel, anchorChangeListener);
        group.add((MenuItemBase)menuItem);
    }

    private void showFrame(Panel frameHolder, String frameURL) {
        frameHolder.clear();
        FrameWidget frame = new FrameWidget();
        frame.getElement().setAttribute("frameBorder", "0");
        String randomizer = "&random=" + this.getRandom();
        frameURL = frameURL.contains("?") ? frameURL + randomizer : frameURL + "?" + randomizer;
        frame.setUrl(frameURL);
        frameHolder.add((Widget)frame);
    }

    private String getRandom() {
        return String.valueOf(Random.nextDouble());
    }
}

