/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.ui.workflow.server;

import com.tandbergtv.cms.ui.workflow.client.IListUserTasks;
import com.tandbergtv.cms.ui.workflow.client.UserTask;
import com.tandbergtv.cms.ui.workflow.client.UserTaskList;
import com.tandbergtv.cms.ui.workflow.server.UIPropertyProvider;
import com.tandbergtv.neptune.authorization.service.IAuthorizationService;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;
import com.tandbergtv.neptune.widgettoolkit.client.security.InsufficientRolesException;
import com.tandbergtv.neptune.widgettoolkit.server.remote.NeptuneRemoteService;
import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.driver.service.IPersistenceService;
import com.tandbergtv.workflow.resourcemanager.FinderException;
import com.tandbergtv.workflow.resourcemanager.ResourceManagement;
import com.tandbergtv.workflow.resourcemanager.entities.Resource;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceUser;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import org.apache.log4j.Logger;
import org.jbpm.taskmgmt.exe.TaskInstance;

public class ListUserTasksImpl
implements IListUserTasks,
NeptuneRemoteService {
    private static final Logger logger = Logger.getLogger(ListUserTasksImpl.class);
    private static final String PROP_UPPER_LIMIT = "workflow.userTasks.upperLimit";
    private IAuthorizationService authService = (IAuthorizationService)InjectionUtil.injectInstance((String)"cms/AuthorizationService/local", IAuthorizationService.class);

    public String getRelativePath() {
        return "service/watchpoint/IListUserTasks";
    }

    public Class<?> getServiceImplementation() {
        return this.getClass();
    }

    private void verifyAuthority() throws InsufficientRolesException {
        if (!this.authService.isAuthorized("Home", "Dashboard")) {
            throw new InsufficientRolesException();
        }
    }

    @Override
    public UserTaskList getUserTasks() throws NeptuneException {
        Set resourceUsers;
        this.verifyAuthority();
        UserTaskList userTaskList = new UserTaskList();
        Integer numUserTasks = null;
        try {
            UIPropertyProvider propProvider = new UIPropertyProvider();
            String numUserTasksStr = propProvider.getInfo().get(PROP_UPPER_LIMIT);
            if (numUserTasksStr != null && numUserTasksStr.trim().length() != 0) {
                numUserTasks = Integer.parseInt(numUserTasksStr);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Unable to get upper limit for number of user tasks [workflow.userTasks.upperLimit] for User Tasks List Portlet. Ignoring limit.", (Throwable)e);
        }
        IPersistenceService service = (IPersistenceService)ServiceRegistry.getDefault().lookup(IPersistenceService.class);
        ResourceManagement resourceManager = (ResourceManagement)ServiceRegistry.getDefault().lookup(ResourceManagement.class);
        String userName = this.authService.getUserName();
        Resource resource = resourceManager.getResourceByUser(userName);
        if (resource != null && (resourceUsers = resource.getUsers()) != null) {
            userTaskList.setTotalNumUserTasks(resourceUsers.size());
            ArrayList sortedResourceUsers = new ArrayList(resourceUsers);
            Collections.sort(sortedResourceUsers, new Comparator<ResourceUser>(){

                @Override
                public int compare(ResourceUser o1, ResourceUser o2) {
                    return o2.getUsageStartDate().compareTo(o1.getUsageStartDate());
                }
            });
            int count = 0;
            for (ResourceUser resourceUser : sortedResourceUsers) {
                if (numUserTasks != null && count++ == numUserTasks) break;
                UserTask userTask = new UserTask();
                long tokenID = resourceUser.getId();
                CustomToken token = service.getToken((Serializable)Long.valueOf(tokenID));
                WorkflowProcess process = (WorkflowProcess)token.getProcessInstance();
                userTask.setTemplateName(process.getProcessDefinition().getFullName());
                userTask.setTemplateId(process.getProcessDefinition().getId());
                userTask.setName(token.getNode().getName());
                userTask.setNodeId(token.getNode().getId());
                long rgId = resourceUser.getResourceGroupId();
                String rgName = null;
                try {
                    rgName = resourceManager.getResourceGroup(rgId).getName();
                }
                catch (FinderException e) {
                    logger.error((Object)("Human resource [" + userName + "] is associated with a resource group of id [" + rgId + "] that does not exist"), (Throwable)e);
                }
                userTask.setResourceGroupName(rgName);
                userTask.setProcessId(process.getId());
                Collection taskInstances = process.getTaskMgmtInstance().getTaskInstances();
                if (taskInstances != null) {
                    for (TaskInstance t : taskInstances) {
                        if (t.hasEnded() || t.getTask().getTaskNode().getId() != token.getNode().getId()) continue;
                        userTask.setTaskInstanceId(t.getId());
                        break;
                    }
                }
                userTaskList.addUserTask(userTask);
            }
        }
        return userTaskList;
    }
}

