/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.ui.workflow.server;

import com.tandbergtv.cms.ui.workflow.client.IWOStatus;
import com.tandbergtv.cms.ui.workflow.client.WOState;
import com.tandbergtv.cms.ui.workflow.server.UIPropertyProvider;
import com.tandbergtv.neptune.authorization.service.IAuthorizationService;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;
import com.tandbergtv.neptune.widgettoolkit.client.security.InsufficientRolesException;
import com.tandbergtv.neptune.widgettoolkit.server.remote.NeptuneRemoteService;
import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.driver.service.IProcessSearchService;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class WOStatusImpl
implements IWOStatus,
NeptuneRemoteService {
    private static final Logger logger = Logger.getLogger(WOStatusImpl.class);
    private static final String PROP_CUTOFF_DURATION = "workflow.woStatus.cutOffDuration";
    private IAuthorizationService authService = (IAuthorizationService)InjectionUtil.injectInstance((String)"cms/AuthorizationService/local", IAuthorizationService.class);

    public String getRelativePath() {
        return "service/watchpoint/IWOStatus";
    }

    public Class<?> getServiceImplementation() {
        return this.getClass();
    }

    private void verifyAuthority() throws InsufficientRolesException {
        if (!this.authService.isAuthorized("Home", "Dashboard")) {
            throw new InsufficientRolesException();
        }
    }

    private Date getCutOffDate() {
        Integer cutOffDuration = null;
        UIPropertyProvider propProvider = new UIPropertyProvider();
        try {
            String cutOffDurationStr = propProvider.getInfo().get(PROP_CUTOFF_DURATION);
            if (cutOffDurationStr != null && (cutOffDurationStr = cutOffDurationStr.trim()).length() > 0) {
                cutOffDuration = Integer.parseInt(cutOffDurationStr);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Unable to get cutoff duration [workflow.woStatus.cutOffDuration] value for Work Orders Status Portlet. Ignoring cutoff date.", (Throwable)e);
            return null;
        }
        if (cutOffDuration == null) {
            return null;
        }
        try {
            GregorianCalendar gregCal = new GregorianCalendar();
            gregCal.setTime(new Date());
            gregCal.add(5, -1 * cutOffDuration);
            return gregCal.getTime();
        }
        catch (Exception e) {
            logger.error((Object)("Could not evaluate cutoff date from duration [" + cutOffDuration + "]. Ignoring cutoff date."), (Throwable)e);
            return null;
        }
    }

    @Override
    public Map<WOState, Integer> getStatus() throws NeptuneException {
        this.verifyAuthority();
        HashMap<WOState, Integer> woStatusMap = new HashMap<WOState, Integer>();
        IProcessSearchService service = (IProcessSearchService)ServiceRegistry.getDefault().lookup(IProcessSearchService.class);
        Date cutOffDate = this.getCutOffDate();
        if (cutOffDate != null) {
            woStatusMap.put(WOState.ACTIVE, service.count(ProcessStatus.ACTIVE, cutOffDate));
            woStatusMap.put(WOState.COMPLETED, service.count(ProcessStatus.COMPLETED, cutOffDate));
            woStatusMap.put(WOState.ERROR, service.count(ProcessStatus.ERROR, cutOffDate));
            woStatusMap.put(WOState.CANCELLED, service.count(ProcessStatus.CANCELLED, cutOffDate));
            woStatusMap.put(WOState.PAUSED, service.count(ProcessStatus.PAUSED, cutOffDate));
            woStatusMap.put(WOState.QUEUED, service.count(ProcessStatus.QUEUED, cutOffDate));
            woStatusMap.put(WOState.BRANCHED, service.count(ProcessStatus.BRANCHED, cutOffDate));
        } else {
            woStatusMap.put(WOState.ACTIVE, service.count(ProcessStatus.ACTIVE));
            woStatusMap.put(WOState.COMPLETED, service.count(ProcessStatus.COMPLETED));
            woStatusMap.put(WOState.ERROR, service.count(ProcessStatus.ERROR));
            woStatusMap.put(WOState.CANCELLED, service.count(ProcessStatus.CANCELLED));
            woStatusMap.put(WOState.PAUSED, service.count(ProcessStatus.PAUSED));
            woStatusMap.put(WOState.QUEUED, service.count(ProcessStatus.QUEUED));
            woStatusMap.put(WOState.BRANCHED, service.count(ProcessStatus.BRANCHED));
        }
        return woStatusMap;
    }
}

