/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.comm.routing.impl;

import com.tandbergtv.workflow.adaptor.AdaptorRequestImpl;
import com.tandbergtv.workflow.adaptor.IAdaptor;
import com.tandbergtv.workflow.adaptor.IAdaptorRequest;
import com.tandbergtv.workflow.adaptor.IAdaptorResponse;
import com.tandbergtv.workflow.adaptor.registry.IAdaptorRegistry;
import com.tandbergtv.workflow.comm.IDestination;
import com.tandbergtv.workflow.comm.routing.CommunicationException;
import com.tandbergtv.workflow.comm.routing.IRoutingService;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.message.IMessage;
import com.tandbergtv.workflow.message.IMessageUID;
import com.tandbergtv.workflow.message.IPayload;
import com.tandbergtv.workflow.message.MessageImpl;
import com.tandbergtv.workflow.message.StringPayload;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.command.ICommandExecutor;
import com.tandbergtv.workflow.message.registry.IMessageRegistry;
import com.tandbergtv.workflow.message.util.Marshaller;
import com.tandbergtv.workflow.message.util.Unmarshaller;
import com.tandbergtv.workflow.util.XMLDocumentUtility;
import java.util.List;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;

public class Router
implements IRoutingService {
    private static Logger logger = Logger.getLogger(Router.class);

    public IMessage send(IMessage message) throws CommunicationException {
        logger.debug((Object)("Request " + message));
        MessageImpl ret = null;
        ICommandExecutor executor = (ICommandExecutor)ServiceRegistry.getDefault().lookup(ICommandExecutor.class);
        try {
            WorkflowMessage request = Router.toWorkflowMessage(message);
            WorkflowMessage response = executor.execute(request);
            logger.debug((Object)("Response " + response));
            ret = Router.toGenericMessage(response);
        }
        catch (Exception e) {
            throw new CommunicationException(e.getMessage(), (Throwable)e);
        }
        return ret;
    }

    public WorkflowMessage send(WorkflowMessage message, List<IDestination> destinations) throws CommunicationException {
        if (destinations == null || destinations.isEmpty()) {
            throw new CommunicationException("At least one destination must be specified");
        }
        logger.debug((Object)("Request " + message));
        WorkflowMessage ret = null;
        try {
            MessageImpl request = Router.toGenericMessage(message);
            AdaptorRequestImpl adaptorRequest = new AdaptorRequestImpl((IMessage)request, message.getSource(), destinations);
            IAdaptorRegistry registry = (IAdaptorRegistry)ServiceRegistry.getDefault().lookup(IAdaptorRegistry.class);
            IAdaptor adaptor = registry.getAdaptor((IAdaptorRequest)adaptorRequest);
            IAdaptorResponse response = adaptor.transmit((IAdaptorRequest)adaptorRequest);
            ret = Router.toWorkflowMessage(response.getMessage());
            logger.debug((Object)("Response: " + ret));
        }
        catch (Exception ex) {
            throw new CommunicationException("Sending to Adaptor failed", (Throwable)ex);
        }
        return ret;
    }

    private static WorkflowMessage toWorkflowMessage(IMessage msg) throws Exception {
        Document document = XMLDocumentUtility.loadXml(msg.getPayload().getContent());
        WorkflowMessage message = Unmarshaller.unmarshal((Document)document);
        String uidValue = message.getMessageUID().getUID();
        IMessageUID uid = ((IMessageRegistry)ServiceRegistry.getDefault().lookup(IMessageRegistry.class)).getMessageUID(uidValue);
        if (uid == null) {
            throw new Exception("UID " + message.getMessageUID().getUID() + " not found in the message registry.");
        }
        message.addAttachment(msg.getAttachment());
        return message;
    }

    private static MessageImpl toGenericMessage(WorkflowMessage message) throws Exception {
        Document document = Marshaller.newMarshaller().marshal(message);
        StringPayload payload = new StringPayload(XMLDocumentUtility.convertToString(document));
        return new MessageImpl((IPayload)payload, message.getAttachment());
    }
}

