/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.resourcemanager;

import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.pluginmanager.PluginManagement;
import com.tandbergtv.workflow.pluginmanager.entities.ResourceGroupDescriptor;
import com.tandbergtv.workflow.resourcemanager.ResourceManager;
import com.tandbergtv.workflow.resourcemanager.WorkerThread;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceGroup;
import com.tandbergtv.workflow.resourcemanager.mgmt.allocation.ResourceAllocationStrategy;
import com.tandbergtv.workflow.resourcemanager.util.StrategyClassLoadException;
import com.tandbergtv.workflow.resourcemanager.util.StrategyClassLoader;
import org.apache.log4j.Logger;

class ResourceGroupContainer {
    private ResourceGroup containedResourceGroup;
    private WorkerThread workerThread;
    private ResourceAllocationStrategy allocationStrategy;
    private boolean notified = false;
    private static final Logger logger = Logger.getLogger(ResourceGroupContainer.class);

    ResourceGroupContainer(ResourceGroup resourceGroup, ResourceManager manager) {
        this.containedResourceGroup = resourceGroup;
        this.initialize(manager);
    }

    private void initialize(ResourceManager manager) {
        boolean allocationStrategyClassLoaded = false;
        String reason = "";
        String resourceGroupName = this.containedResourceGroup.getName();
        ResourceGroupDescriptor rgDesc = ((PluginManagement)ServiceRegistry.getDefault().lookup(PluginManagement.class)).getResourceGroupDescriptor(resourceGroupName);
        if (rgDesc == null) {
            reason = "No descriptor defined.";
        } else if (rgDesc.getAllocationStrategyClass() == null) {
            reason = "AllocationStrategyClass is not defined.";
        } else if (rgDesc.getClassLoader() == null) {
            reason = "Plugin ClassLoader is null.";
        } else {
            try {
                this.allocationStrategy = StrategyClassLoader.loadAllocationStrategy(rgDesc.getAllocationStrategyClass(), rgDesc.getClassLoader());
                allocationStrategyClassLoaded = true;
            }
            catch (StrategyClassLoadException scle) {
                reason = "Failed to load the Resource Allocation Strategy class";
                logger.error((Object)reason, (Throwable)scle);
            }
        }
        if (!allocationStrategyClassLoaded) {
            logger.debug((Object)("Using the Default Resource Allocation Strategy for: " + resourceGroupName + " | " + reason));
            this.allocationStrategy = StrategyClassLoader.createDefaultResourceAllocationStrategy();
        }
        this.workerThread = new WorkerThread(this, manager);
    }

    void start() {
        if (this.containedResourceGroup.isInternallyAcquired()) {
            this.workerThread.setKeepWorking(true);
            this.workerThread.start();
        }
    }

    void stop() {
        logger.debug((Object)("Setting flag to shutdown Queue Processing Thread for Resource Group #" + this.containedResourceGroup.getId()));
        this.workerThread.setKeepWorking(false);
    }

    synchronized void notifyQueue() {
        if (this.workerThread.isAlive()) {
            logger.debug((Object)("Signaling the Queue Processing Thread for ResourceGroup #" + this.containedResourceGroup.getId() + " to attempt to process the Queue."));
        }
        this.notifyAll();
        this.notified = true;
    }

    synchronized void waitForQueueNotification() {
        if (!this.notified) {
            try {
                this.wait();
            }
            catch (InterruptedException ex) {
                logger.error((Object)("Resource Group Queue Processing Thread for ResourceGroup #" + this.getResourceGroup().getId() + " was interrupted " + "while waiting for event notification from the ResourceManager."));
            }
        }
        this.notified = false;
        logger.debug((Object)("Received notification to process the Queue for ResourceGroup #" + this.getResourceGroup().getId()));
    }

    ResourceGroup getResourceGroup() {
        return this.containedResourceGroup;
    }

    void setResourceGroup(ResourceGroup resourceGroup) {
        this.containedResourceGroup = resourceGroup;
    }

    ResourceAllocationStrategy getAllocationStrategy() {
        return this.allocationStrategy;
    }

    WorkerThread getWorkerThread() {
        return this.workerThread;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ResourceGroupContainer) {
            ResourceGroupContainer resObj = (ResourceGroupContainer)obj;
            return this.getResourceGroup().equals(resObj.getResourceGroup());
        }
        return false;
    }

    public int hashCode() {
        return this.getResourceGroup().hashCode();
    }
}

