/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.resourcemanager;

import com.tandbergtv.neptune.realm.persist.Permission;
import com.tandbergtv.neptune.realm.persist.Role;
import com.tandbergtv.neptune.realm.persist.User;
import com.tandbergtv.neptune.rolemgmt.service.IRoleValidityService;
import com.tandbergtv.neptune.rolemgmt.service.RoleValidationException;
import com.tandbergtv.neptune.usermgmt.service.IUserManager;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.resourcemanager.ResourceManagement;
import com.tandbergtv.workflow.resourcemanager.entities.Resource;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class RoleValidityService
implements IRoleValidityService {
    private static final String HUMAN_RESOURCE_SYSTEM_ID = "04";

    public void validate(Role role) throws RoleValidationException {
        Long roleId = role.getId();
        ResourceManagement resourceManagement = (ResourceManagement)ServiceRegistry.getDefault().lookup(ResourceManagement.class);
        IUserManager userManager = (IUserManager)InjectionUtil.injectInstance((String)"cms/UserManager/local", IUserManager.class);
        List<Resource> humanResources = resourceManagement.getResourcesBySystemId(HUMAN_RESOURCE_SYSTEM_ID);
        for (Resource resource : humanResources) {
            String resourceUsername = resource.getUserName();
            User user = userManager.getUser(resourceUsername);
            Set userRoles = user.getRoles();
            HashSet<Long> roleIds = new HashSet<Long>();
            for (Role userRole : userRoles) {
                roleIds.add(userRole.getId());
            }
            if (!roleIds.contains(roleId)) continue;
            this.validateRole(role);
        }
    }

    private void validateRole(Role role) throws RoleValidationException {
        Set permissions = role.getPermissions();
        ArrayList<String> permissionNames = new ArrayList<String>();
        String moduleName = "UserTasks";
        String permissionName = "PerformTask";
        for (Permission perm : permissions) {
            if (!perm.getModule().getName().equals(moduleName)) continue;
            permissionNames.add(perm.getName());
        }
        if (!permissionNames.contains(permissionName)) {
            throw new RoleValidationException("This role must contain '" + moduleName + "'-'" + permissionName + "' permission.");
        }
    }
}

