/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;

public class DefaultNamespaceContext
implements NamespaceContext {
    Map<String, String> namespaceMap = new HashMap<String, String>();

    public DefaultNamespaceContext() {
        this.namespaceMap.put("xml", "http://www.w3.org/XML/1998/namespace");
        this.namespaceMap.put("xmlns", "http://www.w3.org/2000/xmlns/");
        this.namespaceMap.put("", "");
    }

    public void setNamespace(String prefix, String namespaceURI) {
        if (prefix == null) {
            throw new IllegalArgumentException("The namespace prefix cannot be null.");
        }
        if (namespaceURI == null) {
            throw new IllegalArgumentException("The namespace URI cannot be null.");
        }
        if (prefix.equals("xml") || prefix.equals("xmlns")) {
            String msg = "The namespace prefix: " + prefix + " is reserved and cannot be used.";
            throw new IllegalArgumentException(msg);
        }
        if (namespaceURI.equals("http://www.w3.org/XML/1998/namespace") || namespaceURI.equals("http://www.w3.org/2000/xmlns/")) {
            String msg = "The namespace URI: " + namespaceURI + " is reserved and cannot be used.";
            throw new IllegalArgumentException(msg);
        }
        this.namespaceMap.put(prefix, namespaceURI);
    }

    public void removePrefix(String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException("The namespace prefix cannot be null.");
        }
        if (prefix.equals("xml") || prefix.equals("xmlns")) {
            String msg = "The namespace prefix: " + prefix + " is reserved and cannot be removed.";
            throw new IllegalArgumentException(msg);
        }
        if (prefix.equals("")) {
            this.namespaceMap.put("", "");
        } else {
            this.namespaceMap.remove(prefix);
        }
    }

    @Override
    public String getNamespaceURI(String prefix) {
        if (prefix == null) {
            String msg = "The namespace prefix cannot be null.";
            throw new IllegalArgumentException(msg);
        }
        String nsURI = this.namespaceMap.get(prefix);
        if (nsURI == null) {
            nsURI = "";
        }
        return nsURI;
    }

    @Override
    public String getPrefix(String namespaceURI) {
        if (namespaceURI == null) {
            throw new IllegalArgumentException("The namespace URI cannot be null.");
        }
        String prefix = null;
        for (String nsPrefix : this.namespaceMap.keySet()) {
            String nsURI = this.namespaceMap.get(nsPrefix);
            if (!namespaceURI.equals(nsURI)) continue;
            prefix = nsPrefix;
            break;
        }
        return prefix;
    }

    public Iterator getPrefixes(String namespaceURI) {
        if (namespaceURI == null) {
            throw new IllegalArgumentException("The namespace URI cannot be null.");
        }
        ArrayList<String> prefixList = new ArrayList<String>();
        for (String nsPrefix : this.namespaceMap.keySet()) {
            String nsURI = this.namespaceMap.get(nsPrefix);
            if (!namespaceURI.equals(nsURI)) continue;
            prefixList.add(nsPrefix);
        }
        return prefixList.iterator();
    }
}

