/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.job.callback;

import com.tandbergtv.cms.rules.service.category.IRuleExecutionHandler;
import com.tandbergtv.watchpoint.pmm.entities.JobParameter;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.job.callback.AbstractJobCallback;
import com.tandbergtv.watchpoint.pmm.job.callback.IJobCallback;
import com.tandbergtv.watchpoint.pmm.job.util.JobScheduleInfoConstants;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.naming.InitialContext;
import org.apache.log4j.Logger;

public class RuleSetInvoker
extends AbstractJobCallback {
    private static final String SERVICE_NAME = "cms/EventHandler/local";
    private static final Logger logger = Logger.getLogger(RuleSetInvoker.class);

    public RuleSetInvoker(IJobCallback next) {
        super(next);
    }

    @Override
    public void executeJob(Map<String, Object> data, Date date) {
        List<Integer> rulesets = this.getRuleSets(data);
        if (!rulesets.isEmpty()) {
            Collection<Title> titles = this.getTitles(data);
            try {
                IRuleExecutionHandler re = this.getRuleExecutionHandler();
                if (re != null) {
                    logger.debug((Object)"Calling rule engine");
                    re.takeMeToYourRuler(titles, rulesets);
                } else {
                    logger.warn((Object)"Rule event handler is not available");
                }
            }
            catch (Exception e) {
                logger.warn((Object)("Problem during job " + data.get(JobScheduleInfoConstants.JOB_NAME) + " execution"), (Throwable)e);
            }
        }
        super.executeJob(data, date);
    }

    private IRuleExecutionHandler getRuleExecutionHandler() throws Exception {
        return (IRuleExecutionHandler)new InitialContext().lookup(SERVICE_NAME);
    }

    private List<Integer> getRuleSets(Map<String, Object> data) {
        ArrayList<Integer> ids = new ArrayList<Integer>();
        Collection parameters = (Collection)data.get(JobScheduleInfoConstants.JOB_PARAMETERS);
        for (JobParameter parameter : parameters) {
            if (!parameter.getName().equals("ruleset")) continue;
            logger.debug((Object)("Found ruleset " + parameter.getValue()));
            ids.add(Integer.parseInt(parameter.getValue()));
        }
        return ids;
    }

    private Collection<Title> getTitles(Map<String, Object> data) {
        if (data.containsKey("titles")) {
            return (Collection)data.get("titles");
        }
        return new ArrayList<Title>();
    }
}

