/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.job.conf;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class RuleTypeInfoLoader {
    private static RuleTypeInfoLoader instance;
    private Map<String, String> ruleTimers = Collections.synchronizedMap(new HashMap());
    private static String RULEINFOFILE;
    private static String RULE_ELEMENT;
    private static String RULENAME_ATTR;
    private static String TIME_ELEMENT;
    private static String TIMERCLASS_ATTR;
    private static final Logger logger;

    private RuleTypeInfoLoader() {
        this.readConfig();
        logger.debug((Object)("Timer map count = " + this.ruleTimers.size()));
    }

    public static synchronized RuleTypeInfoLoader getInstance() {
        if (instance == null) {
            instance = new RuleTypeInfoLoader();
        }
        return instance;
    }

    public Map<String, String> getRuleTimers() {
        return this.ruleTimers;
    }

    public void setRuleTimers(Map<String, String> ruleTimers) {
        this.ruleTimers = ruleTimers;
    }

    private void readConfig() {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = factory.newDocumentBuilder();
            Document doc = docBuilder.parse(this.getClass().getResourceAsStream(RULEINFOFILE));
            NodeList rules = doc.getElementsByTagName(RULE_ELEMENT);
            for (int i = 0; i < rules.getLength(); ++i) {
                Node currRule = rules.item(i);
                String ruleName = ((Element)currRule).getAttribute(RULENAME_ATTR);
                NodeList children = currRule.getChildNodes();
                for (int j = 0; j < children.getLength(); ++j) {
                    Node currChild = children.item(j);
                    if (!currChild.getNodeName().equals(TIME_ELEMENT)) continue;
                    String timerClass = ((Element)currChild).getAttribute(TIMERCLASS_ATTR);
                    this.addTimerClass(ruleName, timerClass);
                }
            }
            logger.debug((Object)("Done parsing " + RULEINFOFILE));
        }
        catch (ParserConfigurationException e) {
            String errorMsg = "Error while parsing ruleType info file: ".concat(RULEINFOFILE).concat(e.toString());
            logger.error((Object)errorMsg);
        }
        catch (SAXException e) {
            String errorMsg = "Exception while trying to parse ruleType info file: ".concat(RULEINFOFILE).concat(e.toString());
            logger.error((Object)errorMsg);
        }
        catch (IOException e) {
            String errorMsg = "IO exception while trying to parse ruleType info file: ".concat(RULEINFOFILE).concat(e.toString());
            logger.error((Object)errorMsg);
        }
    }

    private synchronized void addTimerClass(String ruleName, String timerClass) {
        if (this.ruleTimers.containsKey(ruleName)) {
            logger.debug((Object)("Timer class map already has an entry for: " + ruleName));
            return;
        }
        this.ruleTimers.put(ruleName, timerClass);
    }

    public String getTimerClass(String ruleName) {
        if (this.ruleTimers.containsKey(ruleName)) {
            return this.ruleTimers.get(ruleName);
        }
        return new String();
    }

    static {
        RULEINFOFILE = "jobRules.xml";
        RULE_ELEMENT = "rule";
        RULENAME_ATTR = "name";
        TIME_ELEMENT = "time";
        TIMERCLASS_ATTR = "class";
        logger = Logger.getLogger(RuleTypeInfoLoader.class);
    }
}

