/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.job.handler;

import com.tandbergtv.cms.portal.util.transaction.TransactionEnforcer;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.watchpoint.pmm.entities.IContainer;
import com.tandbergtv.watchpoint.pmm.entities.RuleParameter;
import com.tandbergtv.watchpoint.pmm.entities.RuleParameterDataType;
import com.tandbergtv.watchpoint.pmm.entities.RuleType;
import com.tandbergtv.watchpoint.pmm.entities.RuleTypeParameter;
import com.tandbergtv.watchpoint.pmm.job.IJobManager;
import com.tandbergtv.watchpoint.pmm.job.JobManager;
import com.tandbergtv.watchpoint.pmm.job.callback.AbstractJobCallback;
import com.tandbergtv.watchpoint.pmm.job.callback.CallbackHelper;
import com.tandbergtv.watchpoint.pmm.job.callback.IJobCallback;
import com.tandbergtv.watchpoint.pmm.job.referenceEvaluator.ParameterReferencePath;
import com.tandbergtv.watchpoint.pmm.job.referenceEvaluator.ReferenceEvaluatorChain;
import com.tandbergtv.watchpoint.pmm.job.util.JobScheduleInfoConstants;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import org.apache.log4j.Logger;
import org.aspectj.runtime.internal.AroundClosure;

public abstract class AbstractTitleAssociatedHandler
extends AbstractJobCallback {
    private Logger logger = Logger.getLogger(this.getClass());
    private static String NDAYS_FROM_METADATA = "NDaysFromMetadata";
    private static String BEFORE = "before";
    private static String AFTER = "after";
    private static int INVALID_INDEX = -1;
    private static int NUMBER_DAYS_INDEX = 0;
    private static int TIMEFRAME_INDEX = 1;

    public AbstractTitleAssociatedHandler(IJobCallback next) {
        super(next);
    }

    @Override
    @Transactional
    public void executeJob(Map<String, Object> callbackInfo, Date jobExecutionDate) {
        Map<String, Object> map = callbackInfo;
        Date date = jobExecutionDate;
        AbstractTitleAssociatedHandler.executeJob_aroundBody1$advice(this, map, date, TransactionEnforcer.aspectOf(), AbstractTitleAssociatedHandler.class.getDeclaredMethod("executeJob", Map.class, Date.class).getAnnotation(Transactional.class), null);
    }

    protected abstract Collection<?> search(ParameterReferencePath var1, Map<String, Object> var2, Date var3);

    protected abstract void processItems(Collection<?> var1, Map<String, Object> var2);

    protected Date getSearchDate(String ruleTypeName, List<RuleParameter> ruleParameters, Date jobExecutionDate) {
        if (ruleTypeName.equalsIgnoreCase(NDAYS_FROM_METADATA)) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(jobExecutionDate);
            int numberOfDays = Integer.parseInt(ruleParameters.get(NUMBER_DAYS_INDEX).getValue());
            String timeframe = ruleParameters.get(TIMEFRAME_INDEX).getValue();
            if (timeframe.equalsIgnoreCase(AFTER)) {
                calendar.add(5, -numberOfDays);
            } else if (timeframe.equalsIgnoreCase(BEFORE)) {
                calendar.add(5, numberOfDays);
            }
            return calendar.getTime();
        }
        return null;
    }

    private int getParameterReferenceFieldIndex(String ruleName) {
        IJobManager jobMgr = JobManager.getInstance();
        RuleType ruleType = jobMgr.getRuleType(ruleName);
        List ruleTypeParams = ruleType.getParams();
        for (RuleTypeParameter ruleTypeParam : ruleTypeParams) {
            if (ruleTypeParam.getType() != RuleParameterDataType.PARAMETERREF) continue;
            int order = ruleTypeParam.getOrder();
            return order > 0 ? order - 1 : order;
        }
        return INVALID_INDEX;
    }

    private static final /* synthetic */ void executeJob_aroundBody0(AbstractTitleAssociatedHandler this_, Map callbackInfo, Date jobExecutionDate) {
        String ruleName = (String)callbackInfo.get(JobScheduleInfoConstants.JOB_RULE_NAME);
        List ruleParameters = (List)callbackInfo.get(JobScheduleInfoConstants.JOB_RULE_PARAMETERS);
        int index = this_.getParameterReferenceFieldIndex(ruleName);
        if (index != INVALID_INDEX) {
            RuleParameter parameterReference = (RuleParameter)ruleParameters.get(index);
            ReferenceEvaluatorChain evaluatorChain = ReferenceEvaluatorChain.getInstance();
            String spec = (String)callbackInfo.get(JobScheduleInfoConstants.JOB_PARAMETER_SPECIFICATION);
            ParameterReferencePath path = evaluatorChain.getPath(parameterReference.getValue(), spec);
            if (path != null) {
                Collection<?> items = this_.search(path, callbackInfo, jobExecutionDate);
                if (items != null) {
                    this_.processItems(items, callbackInfo);
                }
            } else {
                IContainer container = CallbackHelper.getContainer(callbackInfo);
                this_.logger.warn((Object)("Property: " + parameterReference.getValue() + " in job: " + callbackInfo.get(JobScheduleInfoConstants.JOB_NAME) + " for " + container.getContainerType() + " : " + container.getContainerName() + " could not be resolved by any evaluator."));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final /* synthetic */ Object executeJob_aroundBody1$advice(AbstractTitleAssociatedHandler this_, Map transactional, Date ajc_aroundClosure, TransactionEnforcer transactionEnforcer, Transactional transactional2, AroundClosure aroundClosure) {
        void isTransactionOwner;
        void e;
        TransactionManager transactionManager = null;
        boolean bl = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            bl = transactionManager.getTransaction() == null;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        if (!bl) {
            void var10_11 = e;
            void var11_12 = isTransactionOwner;
            AbstractTitleAssociatedHandler.executeJob_aroundBody0(this_, transactional, ajc_aroundClosure);
            return null;
        }
        try {
            transactionManager.begin();
            void var12_13 = e;
            void var13_14 = isTransactionOwner;
            AbstractTitleAssociatedHandler.executeJob_aroundBody0(this_, transactional, ajc_aroundClosure);
            Object var8_9 = null;
            transactionManager.commit();
            return var8_9;
        }
        catch (Exception exception) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)exception);
            try {
                transactionManager.rollback();
            }
            catch (Exception exception2) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)exception2);
            }
            throw new RuntimeException(exception);
        }
    }
}

