/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.job.handler;

import com.tandbergtv.metadatamanager.search.AssetSearchKey;
import com.tandbergtv.watchpoint.pmm.job.callback.IJobCallback;
import com.tandbergtv.watchpoint.pmm.job.handler.AbstractTitleAssociatedHandler;
import com.tandbergtv.watchpoint.pmm.job.referenceEvaluator.ParameterReferencePath;
import com.tandbergtv.watchpoint.pmm.job.util.JobScheduleInfoConstants;
import com.tandbergtv.watchpoint.pmm.title.search.ITitleSearchService;
import com.tandbergtv.watchpoint.pmm.title.search.ParamType;
import com.tandbergtv.watchpoint.pmm.title.search.SearchField;
import com.tandbergtv.watchpoint.pmm.title.search.TitleSearchCriteriaBuilder;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.driver.search.SearchOperator;
import com.tandbergtv.workflow.driver.search.SearchType;
import com.tandbergtv.workflow.util.SearchCriteria;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class TitleAssociatedHandler
extends AbstractTitleAssociatedHandler {
    private static String DATE_FORMAT = "yyyy-MM-dd";
    private Logger logger = Logger.getLogger(TitleAssociatedHandler.class);

    public TitleAssociatedHandler(IJobCallback next) {
        super(next);
    }

    private SearchCriteria buildSearchCriteria(ParameterReferencePath path, Map<String, Object> searchInfo, Date jobExecutionDate) {
        String ruleName = (String)searchInfo.get(JobScheduleInfoConstants.JOB_RULE_NAME);
        List ruleParameters = (List)searchInfo.get(JobScheduleInfoConstants.JOB_RULE_PARAMETERS);
        Date date = this.getSearchDate(ruleName, ruleParameters, jobExecutionDate);
        Collection<SearchField> fields = this.getSearchFields(path, date);
        String property = AssetSearchKey.ALL_DESCENDANT_FIELDS.toString();
        SearchCriteria criteria = TitleSearchCriteriaBuilder.getCriteria((boolean)true, null, (String)property, fields, (int)0, (int)Integer.MAX_VALUE, null, null, null);
        return criteria;
    }

    private Collection<SearchField> getSearchFields(ParameterReferencePath path, final Date date) {
        ArrayList<SearchField> fields = new ArrayList<SearchField>();
        SearchField field = new SearchField();
        field.setName(path.getPropertyField());
        field.setParamType(ParamType.VALUE);
        field.setSearchOperator(SearchOperator.EQUAL);
        field.setSearchType(SearchType.STRING);
        field.setSectionName(path.getName());
        field.setValues((List)new ArrayList<String>(){
            {
                this.add(TitleAssociatedHandler.this.formatSearchDate(date));
            }
        });
        fields.add(field);
        return fields;
    }

    @Override
    protected Collection<?> search(ParameterReferencePath path, Map<String, Object> searchInfo, Date date) {
        SearchCriteria criteria = this.buildSearchCriteria(path, searchInfo, date);
        ITitleSearchService searchService = (ITitleSearchService)ServiceRegistry.getDefault().lookup(ITitleSearchService.class);
        Collection titles = searchService.search(criteria);
        this.logger.debug((Object)("Search resulted in " + titles.size() + " titles."));
        return titles;
    }

    @Override
    protected void processItems(Collection<?> items, Map<String, Object> callbackInfo) {
        callbackInfo.put("titles", items);
        this.next.executeJob(callbackInfo, null);
    }

    private String formatSearchDate(Date searchDate) {
        SimpleDateFormat df = new SimpleDateFormat(DATE_FORMAT);
        df.setLenient(false);
        return df.format(searchDate);
    }
}

