/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.job.referenceEvaluator;

import com.tandbergtv.watchpoint.pmm.entities.JobParameter;
import com.tandbergtv.watchpoint.pmm.job.referenceEvaluator.JobData;
import com.tandbergtv.watchpoint.pmm.job.referenceEvaluator.ParameterReferencePath;
import com.tandbergtv.watchpoint.pmm.job.referenceEvaluator.ReferenceEvaluator;
import com.tandbergtv.watchpoint.pmm.job.util.JobScheduleInfoConstants;
import com.tandbergtv.watchpoint.pmm.job.util.ParameterReferenceHelper;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class GeneralReferenceEvaluator
extends ReferenceEvaluator {
    private Logger logger = Logger.getLogger(GeneralReferenceEvaluator.class);
    private String GENERAL_PARAMETER_REFERENCE_GROUP = "General";
    private String JOB_EXECUTION_DATE_FORMAT = "yyyy-MM-dd";
    private static String JOBEXECUTION_DATE = "Job Execution Date";

    @Override
    public void evaluate(Object entity, Map<String, Object> info) {
        if (entity.getClass() == JobData.class) {
            JobData data = (JobData)entity;
            List jobParameters = (List)info.get(JobScheduleInfoConstants.JOB_PARAMETERS);
            this.substituteValues(jobParameters, data);
        }
        if (this.successor != null) {
            this.successor.evaluate(entity, info);
        }
    }

    @Override
    public ParameterReferencePath getPath(String property, String spec) {
        if (this.successor != null) {
            return this.successor.getPath(property, spec);
        }
        return null;
    }

    private void substituteValues(List<JobParameter> jobParameters, JobData data) {
        for (JobParameter parameter : jobParameters) {
            try {
                String property;
                String groupName;
                String parameterReference = parameter.getValue();
                if (!ParameterReferenceHelper.isParameterReference(parameterReference) || !(groupName = ParameterReferenceHelper.getGroupName(parameterReference)).equalsIgnoreCase(this.GENERAL_PARAMETER_REFERENCE_GROUP) || !(property = ParameterReferenceHelper.getPropertyName(parameterReference)).equalsIgnoreCase(JOBEXECUTION_DATE)) continue;
                String date = this.formatDate(data.getJobExecutionDate(), this.JOB_EXECUTION_DATE_FORMAT);
                parameter.setValue(date);
            }
            catch (RuntimeException e) {
                this.logger.warn((Object)("Error while subsituting value for: " + parameter.getValue()), (Throwable)e);
            }
        }
    }

    private String formatDate(Date dateToFormat, String toFormat) {
        if (dateToFormat == null) {
            throw new RuntimeException("Date is null.");
        }
        SimpleDateFormat from = new SimpleDateFormat();
        Calendar c = Calendar.getInstance();
        c.setTime(dateToFormat);
        from.setCalendar(c);
        SimpleDateFormat to = new SimpleDateFormat(toFormat);
        return to.format(dateToFormat);
    }
}

