/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.service;

import com.tandbergtv.cms.portal.util.transaction.TransactionEnforcer;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.watchpoint.pmm.dao.hibernate.HibernateContext;
import com.tandbergtv.watchpoint.pmm.entities.ContainerType;
import com.tandbergtv.watchpoint.pmm.entities.Context;
import com.tandbergtv.watchpoint.pmm.entities.DistributionSchedule;
import com.tandbergtv.watchpoint.pmm.entities.IContainer;
import com.tandbergtv.watchpoint.pmm.entities.Partner;
import com.tandbergtv.watchpoint.pmm.entities.Service;
import com.tandbergtv.watchpoint.pmm.entities.ServiceContext;
import com.tandbergtv.watchpoint.pmm.job.IJobManager;
import com.tandbergtv.watchpoint.pmm.job.JobManager;
import com.tandbergtv.watchpoint.pmm.partner.PartnerManager;
import com.tandbergtv.watchpoint.pmm.schedule.search.IScheduleSearchService;
import com.tandbergtv.watchpoint.pmm.schedule.search.ScheduleSearchKey;
import com.tandbergtv.watchpoint.pmm.service.IServiceManagement;
import com.tandbergtv.watchpoint.pmm.service.dao.ServiceHDAO;
import com.tandbergtv.watchpoint.pmm.util.DataOperationException;
import com.tandbergtv.watchpoint.search.Entity;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.service.cache.ICacheService;
import com.tandbergtv.workflow.driver.search.SearchParameterBase;
import com.tandbergtv.workflow.driver.search.SearchType;
import com.tandbergtv.workflow.driver.search.ValueParameter;
import com.tandbergtv.workflow.util.SearchCriteria;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import org.apache.log4j.Logger;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.internal.Conversions;
import org.hibernate.Session;

public class ServiceManager
implements IServiceManagement {
    private static ServiceManager uniqueInstance = new ServiceManager();
    private static final Logger logger = Logger.getLogger(ServiceManager.class);
    private static String CONTAINER_CACHE_SERVICE_NAME = "Container Cache";

    public static IServiceManagement getInstance() {
        return uniqueInstance;
    }

    @Override
    @Transactional
    public synchronized List<Service> getServicesBySearchCriteria(SearchCriteria searchCriteria) {
        SearchCriteria searchCriteria2 = searchCriteria;
        return (List)ServiceManager.getServicesBySearchCriteria_aroundBody1$advice(this, searchCriteria2, TransactionEnforcer.aspectOf(), ServiceManager.class.getDeclaredMethod("getServicesBySearchCriteria", SearchCriteria.class).getAnnotation(Transactional.class), null);
    }

    @Override
    @Transactional
    public synchronized List<Service> getAllActiveServices() {
        return (List)ServiceManager.getAllActiveServices_aroundBody3$advice(this, TransactionEnforcer.aspectOf(), ServiceManager.class.getDeclaredMethod("getAllActiveServices", new Class[0]).getAnnotation(Transactional.class), null);
    }

    @Override
    @Transactional
    public Service createService(Service service) {
        Service service2 = service;
        return (Service)ServiceManager.createService_aroundBody5$advice(this, service2, TransactionEnforcer.aspectOf(), ServiceManager.class.getDeclaredMethod("createService", Service.class).getAnnotation(Transactional.class), null);
    }

    @Override
    @Transactional
    public synchronized Service getService(long serviceId) {
        long l = serviceId;
        return (Service)ServiceManager.getService_aroundBody7$advice(this, l, TransactionEnforcer.aspectOf(), ServiceManager.class.getDeclaredMethod("getService", Long.TYPE).getAnnotation(Transactional.class), null);
    }

    @Override
    @Transactional
    public synchronized boolean deleteService(long serviceId) throws DataOperationException {
        long l = serviceId;
        return Conversions.booleanValue((Object)ServiceManager.deleteService_aroundBody9$advice(this, l, TransactionEnforcer.aspectOf(), ServiceManager.class.getDeclaredMethod("deleteService", Long.TYPE).getAnnotation(Transactional.class), null));
    }

    private int countPitchSchedules(Long contextId) {
        int result = 0;
        SearchCriteria criteria = new SearchCriteria();
        Entity e = new Entity("pitch", DistributionSchedule.class, "d");
        e.addParameter((SearchParameterBase)new ValueParameter(ScheduleSearchKey.ACTIVE.toString(), SearchType.NUMERIC, (Object)1));
        e.addParameter((SearchParameterBase)new ValueParameter(ScheduleSearchKey.CONTEXT.toString(), SearchType.NUMERIC, (Object)contextId));
        criteria.addParameter((SearchParameterBase)e);
        IScheduleSearchService searchService = (IScheduleSearchService)ServiceRegistry.getDefault().lookup(IScheduleSearchService.class);
        result = searchService.count(criteria);
        return result;
    }

    @Override
    @Transactional
    public Service updateService(Service service) {
        Service service2 = service;
        return (Service)ServiceManager.updateService_aroundBody11$advice(this, service2, TransactionEnforcer.aspectOf(), ServiceManager.class.getDeclaredMethod("updateService", Service.class).getAnnotation(Transactional.class), null);
    }

    @Override
    public Set<Service> getAllServicesAssociatedWithPartner(long contextId) {
        Set<Object> services = new HashSet<Service>();
        ICacheService containerCache = (ICacheService)ServiceRegistry.getDefault().lookup(CONTAINER_CACHE_SERVICE_NAME);
        IContainer container = (IContainer)containerCache.get((Serializable)Long.valueOf(contextId));
        if (container.getContainerType() == ContainerType.PARTNER) {
            Partner partner = (Partner)container;
            services = PartnerManager.getInstance().getPartner(partner.getId()).getServices();
        }
        return services;
    }

    @Override
    public int getTotalActiveServiceCount() {
        return this.getAllActiveServices().size();
    }

    private static final /* synthetic */ List getServicesBySearchCriteria_aroundBody0(ServiceManager this_, SearchCriteria searchCriteria) {
        List<Service> serviceList = null;
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            ServiceHDAO serviceDAO = new ServiceHDAO(session);
            serviceList = serviceDAO.findActiveBySearchCriteria(searchCriteria);
        }
        catch (Exception e) {
            logger.error((Object)("Error while retrieving services: " + e.getMessage()), (Throwable)e);
        }
        return serviceList;
    }

    /*
     * WARNING - void declaration
     */
    private static final /* synthetic */ Object getServicesBySearchCriteria_aroundBody1$advice(ServiceManager this_, SearchCriteria transactional, TransactionEnforcer ajc_aroundClosure, Transactional transactional2, AroundClosure aroundClosure) {
        void e;
        void transactionManager;
        void isTransactionOwner;
        TransactionManager transactionManager2 = null;
        boolean bl = false;
        try {
            transactionManager2 = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            bl = transactionManager2.getTransaction() == null;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        if (!bl) {
            void var9_10 = isTransactionOwner;
            void var10_11 = transactionManager;
            return ServiceManager.getServicesBySearchCriteria_aroundBody0(this_, transactional);
        }
        try {
            void object;
            e.begin();
            void var11_12 = isTransactionOwner;
            void var12_13 = transactionManager;
            List list = ServiceManager.getServicesBySearchCriteria_aroundBody0(this_, transactional);
            object.commit();
            return list;
        }
        catch (Exception exception) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)exception);
            try {
                e.rollback();
            }
            catch (Exception exception2) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)exception2);
            }
            throw new RuntimeException(exception);
        }
    }

    private static final /* synthetic */ List getAllActiveServices_aroundBody2(ServiceManager this_) {
        List<Service> serviceList = null;
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            ServiceHDAO serviceDAO = new ServiceHDAO(session);
            serviceList = serviceDAO.findByActive(true);
        }
        catch (Exception e) {
            logger.error((Object)("Error while retrieving services: " + e.getMessage()), (Throwable)e);
        }
        return serviceList;
    }

    /*
     * WARNING - void declaration
     */
    private static final /* synthetic */ Object getAllActiveServices_aroundBody3$advice(ServiceManager this_, TransactionEnforcer transactional, Transactional ajc_aroundClosure, AroundClosure aroundClosure) {
        void transactionManager;
        void e;
        TransactionManager isTransactionOwner;
        Object var4_4 = null;
        boolean bl = false;
        try {
            isTransactionOwner = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            bl = isTransactionOwner.getTransaction() == null;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        if (e == false) {
            void var8_9 = transactionManager;
            Transactional transactional2 = ajc_aroundClosure;
            return ServiceManager.getAllActiveServices_aroundBody2(this_);
        }
        try {
            isTransactionOwner.begin();
            void var10_11 = transactionManager;
            Transactional transactional3 = ajc_aroundClosure;
            List list = ServiceManager.getAllActiveServices_aroundBody2(this_);
            isTransactionOwner.commit();
            return list;
        }
        catch (Exception exception) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)exception);
            try {
                isTransactionOwner.rollback();
            }
            catch (Exception exception2) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)exception2);
            }
            throw new RuntimeException(exception);
        }
    }

    private static final /* synthetic */ Service createService_aroundBody4(ServiceManager this_, Service service) {
        ServiceContext context = new ServiceContext();
        context.setServiceContainer(service);
        service.setContext((Context)context);
        service.setIsActive(Boolean.valueOf(true));
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            ServiceHDAO serviceDAO = new ServiceHDAO(session);
            serviceDAO.create(service);
        }
        catch (Exception e) {
            logger.error((Object)("Error while creating a service: " + e.getMessage()), (Throwable)e);
            return null;
        }
        ICacheService containerCache = (ICacheService)ServiceRegistry.getDefault().lookup(CONTAINER_CACHE_SERVICE_NAME);
        containerCache.add((Serializable)Long.valueOf(service.getContainerContextId()), (Object)service);
        return service;
    }

    /*
     * WARNING - void declaration
     */
    private static final /* synthetic */ Object createService_aroundBody5$advice(ServiceManager this_, Service transactional, TransactionEnforcer ajc_aroundClosure, Transactional transactional2, AroundClosure aroundClosure) {
        void e;
        void transactionManager;
        void isTransactionOwner;
        TransactionManager transactionManager2 = null;
        boolean bl = false;
        try {
            transactionManager2 = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            bl = transactionManager2.getTransaction() == null;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        if (!bl) {
            void var9_10 = isTransactionOwner;
            void var10_11 = transactionManager;
            return ServiceManager.createService_aroundBody4(this_, transactional);
        }
        try {
            void object;
            e.begin();
            void var11_12 = isTransactionOwner;
            void var12_13 = transactionManager;
            Service service = ServiceManager.createService_aroundBody4(this_, transactional);
            object.commit();
            return service;
        }
        catch (Exception exception) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)exception);
            try {
                e.rollback();
            }
            catch (Exception exception2) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)exception2);
            }
            throw new RuntimeException(exception);
        }
    }

    private static final /* synthetic */ Service getService_aroundBody6(ServiceManager this_, long serviceId) {
        Service result = null;
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            ServiceHDAO serviceDAO = new ServiceHDAO(session);
            result = (Service)serviceDAO.findByKey(serviceId);
        }
        catch (Exception e) {
            logger.error((Object)("Error while getting a service: " + e.getMessage()), (Throwable)e);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private static final /* synthetic */ Object getService_aroundBody7$advice(ServiceManager this_, long transactional, TransactionEnforcer transactionEnforcer, Transactional transactional2, AroundClosure aroundClosure) {
        void isTransactionOwner;
        void e;
        TransactionManager transactionManager = null;
        boolean bl = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            bl = transactionManager.getTransaction() == null;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        if (!bl) {
            void var10_10 = e;
            void var11_11 = isTransactionOwner;
            return ServiceManager.getService_aroundBody6(this_, transactional);
        }
        try {
            transactionManager.begin();
            void var12_12 = e;
            void var13_13 = isTransactionOwner;
            Service service = ServiceManager.getService_aroundBody6(this_, transactional);
            transactionManager.commit();
            return service;
        }
        catch (Exception exception) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)exception);
            try {
                transactionManager.rollback();
            }
            catch (Exception exception2) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)exception2);
            }
            throw new RuntimeException(exception);
        }
    }

    private static final /* synthetic */ boolean deleteService_aroundBody8(ServiceManager this_, long serviceId) {
        Service service = this_.getService(serviceId);
        long contextId = service.getContainerContextId();
        IJobManager jobManager = JobManager.getInstance();
        List<Object> lsJobs = new ArrayList();
        try {
            lsJobs = jobManager.getAllJobs(contextId);
        }
        catch (Exception e) {
            logger.error((Object)"Error while getting all jobs: ", (Throwable)e);
            return false;
        }
        if (lsJobs != null && lsJobs.size() > 0) {
            logger.error((Object)("Cannot delete the service with serviceId=" + serviceId + " since there are " + lsJobs.size() + " jobs associated with the service"));
            throw new DataOperationException("Service [" + serviceId + "] cannot be deleted since there are jobs associated with it.");
        }
        int schedulesCount = this_.countPitchSchedules(new Long(contextId));
        if (schedulesCount > 0) {
            logger.error((Object)("Cannot delete the service with serviceId=" + serviceId + " since there are " + schedulesCount + " schedules associated with the service"));
            throw new DataOperationException("Service [" + serviceId + "] cannot be deleted since there are schedules associated with it.");
        }
        if (service.getPartnerCount() > 0) {
            logger.error((Object)("Cannot delete the service with serviceId=" + serviceId + " since there are " + service.getPartnerCount() + " partners associated with the service"));
            throw new DataOperationException("Service [" + serviceId + "] cannot be deleted since there are partners associated with it.");
        }
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            ServiceHDAO serviceDAO = new ServiceHDAO(session);
            service.setIsActive(Boolean.valueOf(false));
            serviceDAO.update(service);
        }
        catch (Exception e) {
            logger.error((Object)("Error while deleting service (id: " + serviceId + "): "), (Throwable)e);
            return false;
        }
        ICacheService containerCache = (ICacheService)ServiceRegistry.getDefault().lookup(CONTAINER_CACHE_SERVICE_NAME);
        containerCache.remove((Serializable)Long.valueOf(contextId));
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private static final /* synthetic */ Object deleteService_aroundBody9$advice(ServiceManager this_, long transactional, TransactionEnforcer transactionEnforcer, Transactional transactional2, AroundClosure aroundClosure) {
        void isTransactionOwner;
        void e;
        TransactionManager transactionManager = null;
        boolean bl = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            bl = transactionManager.getTransaction() == null;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        if (!bl) {
            void var10_10 = e;
            void var11_11 = isTransactionOwner;
            return Conversions.booleanObject((boolean)ServiceManager.deleteService_aroundBody8(this_, transactional));
        }
        try {
            transactionManager.begin();
            void var12_12 = e;
            void var13_13 = isTransactionOwner;
            Object object = Conversions.booleanObject((boolean)ServiceManager.deleteService_aroundBody8(this_, transactional));
            transactionManager.commit();
            return object;
        }
        catch (Exception exception) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)exception);
            try {
                transactionManager.rollback();
            }
            catch (Exception exception2) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)exception2);
            }
            throw new RuntimeException(exception);
        }
    }

    private static final /* synthetic */ Service updateService_aroundBody10(ServiceManager this_, Service service) {
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            ServiceHDAO serviceDAO = new ServiceHDAO(session);
            serviceDAO.update(service);
        }
        catch (Exception e) {
            logger.error((Object)("Error while updating a service: " + e.getMessage()), (Throwable)e);
            return null;
        }
        ICacheService containerCache = (ICacheService)ServiceRegistry.getDefault().lookup(CONTAINER_CACHE_SERVICE_NAME);
        containerCache.add((Serializable)Long.valueOf(service.getContainerContextId()), (Object)service);
        return service;
    }

    /*
     * WARNING - void declaration
     */
    private static final /* synthetic */ Object updateService_aroundBody11$advice(ServiceManager this_, Service transactional, TransactionEnforcer ajc_aroundClosure, Transactional transactional2, AroundClosure aroundClosure) {
        void e;
        void transactionManager;
        void isTransactionOwner;
        TransactionManager transactionManager2 = null;
        boolean bl = false;
        try {
            transactionManager2 = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            bl = transactionManager2.getTransaction() == null;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        if (!bl) {
            void var9_10 = isTransactionOwner;
            void var10_11 = transactionManager;
            return ServiceManager.updateService_aroundBody10(this_, transactional);
        }
        try {
            void object;
            e.begin();
            void var11_12 = isTransactionOwner;
            void var12_13 = transactionManager;
            Service service = ServiceManager.updateService_aroundBody10(this_, transactional);
            object.commit();
            return service;
        }
        catch (Exception exception) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)exception);
            try {
                e.rollback();
            }
            catch (Exception exception2) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)exception2);
            }
            throw new RuntimeException(exception);
        }
    }
}

