/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title.template;

import com.tandbergtv.cms.portal.util.locale.ResourceBundleLocaleModifier;
import com.tandbergtv.watchpoint.pmm.title.template.ITitleTemplateProvider;
import com.tandbergtv.workflow.core.TaskVariable;
import com.tandbergtv.workflow.core.WorkflowTemplate;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.driver.service.ITemplateLoaderService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.ResourceBundle;
import org.apache.log4j.Logger;
import org.aspectj.runtime.internal.AroundClosure;

public class TitleTemplateProvider
implements ITitleTemplateProvider {
    private Collection<String> variablenames;
    private static final Logger logger = Logger.getLogger(TitleTemplateProvider.class);

    @Override
    public Collection<WorkflowTemplate> getTemplates() {
        ArrayList<WorkflowTemplate> templates = new ArrayList<WorkflowTemplate>();
        ITemplateLoaderService service = (ITemplateLoaderService)ServiceRegistry.getDefault().lookup(ITemplateLoaderService.class);
        if (service == null) {
            throw new RuntimeException("Don't know how to get templates");
        }
        for (WorkflowTemplate template : service.getLatestTemplates()) {
            for (TaskVariable variable : template.getStartTaskVariables()) {
                String name = variable.getVariableName();
                if (!this.variablenames.contains(name)) continue;
                templates.add(template);
            }
        }
        return templates;
    }

    public String getServiceName() {
        return "Title Template Provider";
    }

    public void start() {
        String string = this.getClass().getPackage().getName() + ".variable";
        ResourceBundle bundle = TitleTemplateProvider.getBundle_aroundBody1$advice(this, string, ResourceBundleLocaleModifier.aspectOf(), string, null);
        this.variablenames = Arrays.asList(bundle.getString("name").split(","));
        logger.info((Object)(this.getServiceName() + " started"));
    }

    public void stop() {
    }

    private static final /* synthetic */ ResourceBundle getBundle_aroundBody0(TitleTemplateProvider titleTemplateProvider, String string) {
        return ResourceBundle.getBundle(string);
    }

    private static final /* synthetic */ ResourceBundle getBundle_aroundBody1$advice(TitleTemplateProvider this_, String baseName, ResourceBundleLocaleModifier ajc_aroundClosure, String string, AroundClosure aroundClosure) {
        return ResourceBundle.getBundle(string, ResourceBundleLocaleModifier.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_locale_ResourceBundleLocaleModifier$com_tandbergtv_cms_portal_util_locale_ResourceBundleLocaleModifier$locale((ResourceBundleLocaleModifier)ajc_aroundClosure));
    }
}

