/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.entities;

import com.tandbergtv.watchpoint.pmm.entities.IAssetList;
import com.tandbergtv.watchpoint.pmm.entities.ProgressItem;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.entities.event.AssetListEvent;
import com.tandbergtv.watchpoint.pmm.entities.event.AssetListEventType;
import com.tandbergtv.workflow.core.event.DefaultMediator;
import com.tandbergtv.workflow.core.event.WorkflowEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;

public abstract class AssetList
implements IAssetList {
    protected Long id;
    protected String name;
    protected String description;
    protected Collection<Title> titles = new ArrayList<Title>();
    protected Collection<ProgressItem> progressItems = new ArrayList<ProgressItem>();
    protected Boolean isActive = true;

    protected AssetList() {
    }

    @Override
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public Boolean getIsActive() {
        return this.isActive;
    }

    public void setIsActive(Boolean isActive) {
        this.isActive = isActive;
    }

    protected void addTitleInternal(Title title) {
        if (!this.titles.contains(title)) {
            this.titles.add(title);
        }
    }

    public void addTitle(Title title) {
        this.addTitleInternal(title);
        this.fireEvent(new AssetListEvent(this, this, AssetListEventType.TITLES_ADDED));
    }

    public void addTitles(Title ... titles) {
        for (Title title : titles) {
            this.addTitleInternal(title);
        }
        this.fireEvent(new AssetListEvent(this, this, AssetListEventType.TITLES_ADDED));
    }

    public void addTitles(Collection<Title> titles) {
        for (Title title : titles) {
            this.addTitleInternal(title);
        }
        this.fireEvent(new AssetListEvent(this, this, AssetListEventType.TITLES_ADDED));
    }

    protected void removeTitleInternal(Title title) {
        this.titles.remove(title);
    }

    public void removeTitle(Title title) {
        this.removeTitleInternal(title);
        this.fireEvent(new AssetListEvent(this, this, AssetListEventType.TITLES_REMOVED));
    }

    public void removeTitles() {
        while (!this.titles.isEmpty()) {
            this.removeTitleInternal(this.titles.iterator().next());
        }
        this.fireEvent(new AssetListEvent(this, this, AssetListEventType.TITLES_REMOVED));
    }

    public Title getTitle(Long titleId) {
        for (Title t : this.titles) {
            if (!t.getId().equals(titleId)) continue;
            return t;
        }
        return null;
    }

    @Override
    public Collection<Title> getTitles() {
        return this.titles;
    }

    public void setTitles(Collection<Title> titles) {
        this.removeTitles();
        this.addTitles(titles);
    }

    public Collection<Title> getDelta(AssetList list) {
        HashSet<Title> delta = new HashSet<Title>();
        for (Title title : this.titles) {
            if (list.getTitles().contains(title)) continue;
            delta.add(title);
        }
        return delta;
    }

    protected void fireEvent(AssetListEvent event) {
        DefaultMediator.getInstance().sendAsync((WorkflowEvent)event);
    }

    public String toString() {
        String s = "[" + this.id + "]";
        if (this.titles != null) {
            s = s + " " + this.titles.size() + " titles";
        }
        return s;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssetList)) {
            return false;
        }
        AssetList other = (AssetList)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }
}

