/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.entities;

import com.tandbergtv.watchpoint.pmm.entities.Context;
import com.tandbergtv.watchpoint.pmm.entities.JobParameter;
import com.tandbergtv.watchpoint.pmm.entities.JobRuleTypeConstants;
import com.tandbergtv.watchpoint.pmm.entities.Rule;
import com.tandbergtv.watchpoint.pmm.entities.RuleParameter;
import com.tandbergtv.workflow.core.ProcessPriority;
import java.util.List;
import org.apache.log4j.Logger;

public class Job {
    public static final int DEFAULT_ID = 0;
    private static final int HASHCODE_MULTIPLICATION_FACTOR = 5;
    private static final int HASHCODE_ADDITION_FACTOR = 101;
    private Logger logger = Logger.getLogger(Job.class);
    private long id;
    private String name;
    private Context context;
    private ProcessPriority priority;
    private String templateName;
    private List<JobParameter> jobParams;
    private Rule rule;
    private String spec;

    public void setId(long id) {
        this.id = id;
    }

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Context getContext() {
        return this.context;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public ProcessPriority getPriority() {
        return this.priority;
    }

    public void setPriority(ProcessPriority priority) {
        this.priority = priority;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public List<JobParameter> getJobParams() {
        return this.jobParams;
    }

    public void setJobParams(List<JobParameter> jobParams) {
        this.jobParams = jobParams;
    }

    public Rule getRule() {
        return this.rule;
    }

    public void setRule(Rule rule) {
        this.rule = rule;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Job) {
            Job jobObj = (Job)obj;
            if (jobObj.getId() != 0L && this.getId() != 0L) {
                return jobObj.getId() == this.getId();
            }
            return super.equals(obj);
        }
        return false;
    }

    public int hashCode() {
        long hash = this.id * 5L + 101L;
        int hashCode = new Long(hash).hashCode();
        if (this.id == 0L) {
            hashCode = super.hashCode();
        }
        return hashCode;
    }

    public boolean isTitleAssociated() {
        return this.getRule().getType().getTitlesAssociated();
    }

    public String getScheduleRuleString() {
        Rule rule = this.getRule();
        String selectedRuletypeName = rule.getType().getName();
        try {
            if (selectedRuletypeName.equals(JobRuleTypeConstants.METADATA_BASED_RULE)) {
                List<RuleParameter> ruleParams = rule.getParams();
                StringBuilder sb = new StringBuilder();
                sb.append(ruleParams.get(JobRuleTypeConstants.NUMBER_OF_DAYS_INDEX).getValue());
                sb.append(" day(s) ");
                sb.append(ruleParams.get(JobRuleTypeConstants.TIMEFRAME_INDEX).getValue());
                sb.append(" ");
                String description = ruleParams.get(JobRuleTypeConstants.METADATA_INDEX).getDescription();
                if (description != null && description.length() > 0) {
                    sb.append(description);
                } else {
                    sb.append(ruleParams.get(JobRuleTypeConstants.METADATA_INDEX).getValue());
                }
                sb.append(" at ");
                sb.append(ruleParams.get(JobRuleTypeConstants.TIME_INDEX).getValue());
                return sb.toString();
            }
            if (selectedRuletypeName.equals(JobRuleTypeConstants.EVERY_N_DAYS_RULE)) {
                List<RuleParameter> ruleParams = rule.getParams();
                StringBuilder sb = new StringBuilder();
                sb.append("Every ");
                sb.append(ruleParams.get(JobRuleTypeConstants.DAYS_INDEX).getValue());
                sb.append(" day(s) at ");
                sb.append(ruleParams.get(JobRuleTypeConstants.ONDAYS_TIME_INDEX).getValue());
                return sb.toString();
            }
            if (selectedRuletypeName.equals(JobRuleTypeConstants.ONDATE_RULE)) {
                List<RuleParameter> ruleParams = rule.getParams();
                StringBuilder sb = new StringBuilder();
                sb.append("On ");
                sb.append(ruleParams.get(JobRuleTypeConstants.DATE_INDEX).getValue());
                sb.append(" at ");
                sb.append(ruleParams.get(JobRuleTypeConstants.ONDATE_TIME_INDEX).getValue());
                return sb.toString();
            }
            if (selectedRuletypeName.equals(JobRuleTypeConstants.ON_DAY_EVERY_N_WEEKS_RULE)) {
                List<RuleParameter> ruleParams = rule.getParams();
                StringBuilder sb = new StringBuilder();
                sb.append("On ");
                sb.append(ruleParams.get(JobRuleTypeConstants.DAY_INDEX).getValue());
                sb.append(" every ");
                sb.append(ruleParams.get(JobRuleTypeConstants.WEEK_INDEX).getValue());
                sb.append(" week(s) at ");
                sb.append(ruleParams.get(JobRuleTypeConstants.ONDAY_TIME_INDEX).getValue());
                return sb.toString();
            }
        }
        catch (RuntimeException e) {
            this.logger.error((Object)("Error while preparing rule param string: " + e.toString()));
        }
        return "";
    }

    public String getSpec() {
        return this.spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }
}

