/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service.deployers;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextHandler;
import javax.xml.namespace.QName;
import org.apache.catalina.Container;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Pipeline;
import org.apache.catalina.Realm;
import org.apache.catalina.Server;
import org.apache.catalina.Service;
import org.apache.catalina.Valve;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.startup.Catalina;
import org.apache.catalina.startup.CatalinaProperties;
import org.apache.tomcat.util.IntrospectionUtils;
import org.apache.tomcat.util.modeler.Registry;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.security.plugins.JaasSecurityManagerServiceMBean;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.system.server.ServerImplMBean;
import org.jboss.util.StringPropertyReplacer;
import org.jboss.util.xml.JBossEntityResolver;
import org.jboss.web.tomcat.metadata.AnyXmlMetaData;
import org.jboss.web.tomcat.metadata.ConnectorMetaData;
import org.jboss.web.tomcat.metadata.EngineMetaData;
import org.jboss.web.tomcat.metadata.HostMetaData;
import org.jboss.web.tomcat.metadata.ListenerMetaData;
import org.jboss.web.tomcat.metadata.ServerMetaData;
import org.jboss.web.tomcat.metadata.ServiceMetaData;
import org.jboss.web.tomcat.metadata.ValveMetaData;
import org.jboss.web.tomcat.security.HttpServletRequestPolicyContextHandler;
import org.jboss.web.tomcat.service.deployers.JBossWebMicrocontainerBeanLocator;
import org.jboss.web.tomcat.service.deployers.SecurityActions;
import org.jboss.web.tomcat.service.deployers.TomcatDeployer;
import org.jboss.web.tomcat.service.deployers.TomcatServiceMBean;
import org.jboss.xb.binding.Unmarshaller;
import org.jboss.xb.binding.UnmarshallerFactory;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBinding;
import org.jboss.xb.builder.JBossXBBuilder;
import org.xml.sax.EntityResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TomcatService
extends ServiceMBeanSupport
implements NotificationListener,
TomcatServiceMBean {
    private TomcatDeployer tomcatDeployer;
    private boolean connectorsRunning = false;
    public static boolean OLD_CODE = false;

    public TomcatDeployer getTomcatDeployer() {
        return this.tomcatDeployer;
    }

    @Override
    public void setTomcatDeployer(TomcatDeployer tomcatDeployer) {
        this.tomcatDeployer = tomcatDeployer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startService() throws Exception {
        if (this.tomcatDeployer == null) {
            throw new IllegalStateException("Must set TomcatDeployer before starting");
        }
        this.tomcatDeployer.setServiceClassLoader(this.getClass().getClassLoader());
        CatalinaProperties.getProperty((String)"");
        this.log.debug((Object)"Starting tomcat deployer");
        MBeanServer server = super.getServer();
        SecurityActions.setSystemProperty("catalina.ext.dirs", SecurityActions.getSystemProperty("jboss.server.home.dir", null) + File.separator + "lib");
        String objectNameS = this.tomcatDeployer.getDomain() + ":type=server";
        ObjectName objectName = new ObjectName(objectNameS);
        if (OLD_CODE) {
            Registry.getRegistry().setMBeanServer(server);
            Registry.getRegistry().registerComponent(Class.forName("org.apache.catalina.startup.Catalina").newInstance(), objectName, "org.apache.catalina.startup.Catalina");
            server.setAttribute(objectName, new Attribute("catalinaHome", System.getProperty("jboss.server.home.dir")));
            server.setAttribute(objectName, new Attribute("configFile", this.tomcatDeployer.getConfigFile()));
            server.setAttribute(objectName, new Attribute("useNaming", new Boolean(false)));
            server.setAttribute(objectName, new Attribute("useShutdownHook", new Boolean(false)));
            server.setAttribute(objectName, new Attribute("await", new Boolean(false)));
            server.setAttribute(objectName, new Attribute("redirectStreams", new Boolean(false)));
        } else {
            SchemaBinding schema = JBossXBBuilder.build(ServerMetaData.class);
            Unmarshaller u = UnmarshallerFactory.newInstance().newUnmarshaller();
            u.setSchemaValidation(false);
            u.setValidation(false);
            u.setEntityResolver((EntityResolver)new JBossEntityResolver());
            InputStream is = null;
            ServerMetaData serverMetaData = null;
            try {
                File configFile = new File(this.tomcatDeployer.getConfigFile());
                is = configFile.exists() ? new FileInputStream(configFile) : this.getClass().getClassLoader().getResourceAsStream(this.tomcatDeployer.getConfigFile());
                if (is == null) {
                    this.log.error((Object)("Could not read configured server.xml (will try default): " + this.tomcatDeployer.getConfigFile()));
                    is = this.getClass().getClassLoader().getResourceAsStream("server.xml");
                }
                serverMetaData = (ServerMetaData)ServerMetaData.class.cast(u.unmarshal(is, schema));
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {}
                }
            }
            Catalina catalina = new Catalina();
            catalina.setCatalinaHome(System.getProperty("jboss.server.home.dir"));
            catalina.setUseNaming(false);
            catalina.setUseShutdownHook(false);
            catalina.setAwait(false);
            catalina.setRedirectStreams(false);
            Registry.getRegistry(null, null).setMBeanServer(server);
            Registry.getRegistry(null, null).registerComponent((Object)catalina, objectName, "org.apache.catalina.startup.Catalina");
            Server catalinaServer = (Server)TomcatService.getInstance(serverMetaData, "org.apache.catalina.core.StandardServer");
            TomcatService.addLifecycleListeners(catalinaServer, serverMetaData.getListeners());
            if (serverMetaData.getServices() == null) {
                throw new IllegalArgumentException("No services");
            }
            for (ServiceMetaData serviceMetaData : serverMetaData.getServices()) {
                Service service = (Service)TomcatService.getInstance(serviceMetaData, "org.apache.catalina.core.StandardService");
                TomcatService.addLifecycleListeners(service, serviceMetaData.getListeners());
                service.setName(serviceMetaData.getName());
                service.setServer(catalinaServer);
                catalinaServer.addService(service);
                if (serviceMetaData.getConnectors() != null) {
                    for (ConnectorMetaData connectorMetaData : serviceMetaData.getConnectors()) {
                        Connector connector = new Connector(connectorMetaData.getProtocol());
                        if (connectorMetaData.getAttributes() != null) {
                            for (QName name : connectorMetaData.getAttributes().keySet()) {
                                String value = (String)connectorMetaData.getAttributes().get(name);
                                value = StringPropertyReplacer.replaceProperties((String)value);
                                IntrospectionUtils.setProperty((Object)connector, (String)name.getLocalPart(), (String)value);
                            }
                        }
                        service.addConnector(connector);
                    }
                }
                EngineMetaData engineMetaData = serviceMetaData.getEngine();
                Engine engine = (Engine)TomcatService.getInstance(engineMetaData, "org.apache.catalina.core.StandardEngine");
                TomcatService.addLifecycleListeners(engine, engineMetaData.getListeners());
                engine.setName(engineMetaData.getName());
                if (engineMetaData.getJvmRoute() != null) {
                    engine.setJvmRoute(StringPropertyReplacer.replaceProperties((String)engineMetaData.getJvmRoute()));
                }
                engine.setDefaultHost(engineMetaData.getDefaultHost());
                service.setContainer((Container)engine);
                if (engineMetaData.getRealm() != null) {
                    engine.setRealm((Realm)TomcatService.getInstance(engineMetaData.getRealm(), null));
                }
                TomcatService.addValves(engine, engineMetaData.getValves());
                if (engineMetaData.getHosts() == null) continue;
                for (HostMetaData hostMetaData : engineMetaData.getHosts()) {
                    Host host = (Host)TomcatService.getInstance(hostMetaData, "org.apache.catalina.core.StandardHost");
                    TomcatService.addLifecycleListeners(host, hostMetaData.getListeners());
                    host.setName(hostMetaData.getName());
                    host.setConfigClass("org.jboss.web.tomcat.service.deployers.JBossContextConfig");
                    engine.addChild((Container)host);
                    if (hostMetaData.getRealm() != null) {
                        host.setRealm((Realm)TomcatService.getInstance(hostMetaData.getRealm(), null));
                    }
                    TomcatService.addValves(host, hostMetaData.getValves());
                    if (hostMetaData.getAliases() == null) continue;
                    Iterator<String> aliases = hostMetaData.getAliases().iterator();
                    while (aliases.hasNext()) {
                        host.addAlias(aliases.next());
                    }
                }
            }
            catalina.setServer(catalinaServer);
        }
        server.invoke(objectName, "create", new Object[0], new String[0]);
        server.invoke(objectName, "start", new Object[0], new String[0]);
        InitialContext ic = new InitialContext();
        try {
            ic.bind("TomcatAuthenticators", (Object)this.tomcatDeployer.getAuthenticators());
        }
        catch (NamingException ne) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)"Binding Authenticators to JNDI failed", (Throwable)ne);
            }
        }
        finally {
            try {
                ic.close();
            }
            catch (NamingException nee) {}
        }
        HttpServletRequestPolicyContextHandler handler = new HttpServletRequestPolicyContextHandler();
        PolicyContext.registerHandler((String)"javax.servlet.http.HttpServletRequest", (PolicyContextHandler)handler, (boolean)true);
        Boolean started = (Boolean)server.getAttribute(ServerImplMBean.OBJECT_NAME, "Started");
        if (started.booleanValue()) {
            this.log.debug((Object)("Server '" + ServerImplMBean.OBJECT_NAME + "' already started, starting connectors now"));
            this.startConnectors();
        } else {
            this.log.debug((Object)("Server '" + ServerImplMBean.OBJECT_NAME + "' not started, registering for start-up notification"));
            server.addNotificationListener(ServerImplMBean.OBJECT_NAME, this, null, null);
        }
    }

    protected static Object getInstance(AnyXmlMetaData metaData, String defaultClassName) throws Exception {
        String className = metaData.getClassName();
        if (className == null) {
            className = defaultClassName;
        }
        if (className == null) {
            throw new IllegalArgumentException("No className specified for element");
        }
        Object instance = TomcatService.class.getClassLoader().loadClass(className).newInstance();
        if (metaData.getAttributes() != null) {
            for (QName name : metaData.getAttributes().keySet()) {
                String value = (String)metaData.getAttributes().get(name);
                value = StringPropertyReplacer.replaceProperties((String)value);
                IntrospectionUtils.setProperty(instance, (String)name.getLocalPart(), (String)value);
            }
        }
        return instance;
    }

    protected static void addLifecycleListeners(Object instance, List<ListenerMetaData> list) throws Exception {
        if (list == null) {
            return;
        }
        Lifecycle lifecycle = null;
        if (!(instance instanceof Lifecycle)) {
            return;
        }
        lifecycle = (Lifecycle)instance;
        for (ListenerMetaData listenerMetaData : list) {
            lifecycle.addLifecycleListener((LifecycleListener)TomcatService.getInstance(listenerMetaData, null));
        }
    }

    protected static void addValves(Object instance, List<ValveMetaData> list) throws Exception {
        if (list == null) {
            return;
        }
        Pipeline pipeline = null;
        if (!(instance instanceof Pipeline)) {
            return;
        }
        pipeline = (Pipeline)instance;
        for (ValveMetaData valveMetaData : list) {
            pipeline.addValve((Valve)TomcatService.getInstance(valveMetaData, null));
        }
    }

    protected void stopService() throws Exception {
        if (this.tomcatDeployer == null) {
            throw new IllegalStateException("Must set TomcatDeployer before stopping");
        }
        Boolean inShutdown = (Boolean)this.server.getAttribute(ServerImplMBean.OBJECT_NAME, "InShutdown");
        if (!inShutdown.booleanValue()) {
            this.log.debug((Object)("Server '" + ServerImplMBean.OBJECT_NAME + "' already started, stopping connectors now"));
            this.stopConnectors();
        }
        MBeanServer server = super.getServer();
        String objectNameS = this.tomcatDeployer.getDomain() + ":type=server";
        ObjectName objectName = new ObjectName(objectNameS);
        server.invoke(objectName, "stop", new Object[0], new String[0]);
        server.invoke(objectName, "destroy", new Object[0], new String[0]);
        server.unregisterMBean(objectName);
        MBeanServer server2 = server;
        ObjectName queryObjectName = new ObjectName(this.tomcatDeployer.getDomain() + ":*");
        for (ObjectInstance oi : server2.queryMBeans(queryObjectName, null)) {
            ObjectName toRemove = oi.getObjectName();
            if ("WebServer".equals(toRemove.getKeyProperty("service")) || !server2.isRegistered(toRemove)) continue;
            server2.unregisterMBean(toRemove);
        }
        queryObjectName = new ObjectName("Catalina:*");
        for (ObjectInstance oi : server2.queryMBeans(queryObjectName, null)) {
            ObjectName name = oi.getObjectName();
            server2.unregisterMBean(name);
        }
    }

    public String getConfigFile() {
        return this.tomcatDeployer == null ? null : this.tomcatDeployer.getConfigFile();
    }

    public String getContextMBeanCode() {
        return this.tomcatDeployer == null ? null : this.tomcatDeployer.getContextMBeanCode();
    }

    public boolean getUseJBossWebLoader() {
        return this.tomcatDeployer == null ? false : this.tomcatDeployer.getUseJBossWebLoader();
    }

    public String getDomain() {
        return this.tomcatDeployer == null ? null : this.tomcatDeployer.getDomain();
    }

    public String[] getFilteredPackages() {
        return this.tomcatDeployer == null ? null : this.tomcatDeployer.getFilteredPackages();
    }

    public String getManagerClass() {
        return this.tomcatDeployer == null ? null : this.tomcatDeployer.getManagerClass();
    }

    public String getSessionIdAlphabet() {
        return this.tomcatDeployer == null ? null : this.tomcatDeployer.getSessionIdAlphabet();
    }

    public String getSubjectAttributeName() {
        return this.tomcatDeployer == null ? null : this.tomcatDeployer.getSubjectAttributeName();
    }

    public boolean getDeleteWorkDirOnContextDestroy() {
        return this.tomcatDeployer == null ? false : this.tomcatDeployer.getDeleteWorkDirOnContextDestroy();
    }

    public boolean isAllowSelfPrivilegedWebApps() {
        return this.tomcatDeployer == null ? false : this.tomcatDeployer.isAllowSelfPrivilegedWebApps();
    }

    public void setAllowSelfPrivilegedWebApps(boolean flag) {
        if (this.tomcatDeployer != null) {
            this.tomcatDeployer.setAllowSelfPrivilegedWebApps(flag);
        }
    }

    public void setConfigFile(String configFile) {
        if (this.tomcatDeployer != null) {
            this.tomcatDeployer.setConfigFile(configFile);
        }
    }

    public void setContextMBeanCode(String className) {
        if (this.tomcatDeployer != null) {
            this.tomcatDeployer.setContextMBeanCode(className);
        }
    }

    public void setDeleteWorkDirOnContextDestroy(boolean flag) {
        if (this.tomcatDeployer != null) {
            this.tomcatDeployer.setDeleteWorkDirOnContextDestroy(flag);
        }
    }

    public void setDomain(String domainName) {
        if (this.tomcatDeployer != null) {
            this.tomcatDeployer.setDomain(domainName);
        }
    }

    public void setFilteredPackages(String[] pkgs) {
        if (this.tomcatDeployer != null) {
            this.tomcatDeployer.setFilteredPackages(pkgs);
        }
    }

    public void setManagerClass(String managerClass) {
        if (this.tomcatDeployer != null) {
            this.tomcatDeployer.setManagerClass(managerClass);
        }
    }

    public void setSecurityManagerService(JaasSecurityManagerServiceMBean mgr) {
        if (this.tomcatDeployer != null) {
            this.tomcatDeployer.setSecurityManagerService(mgr);
        }
    }

    public void setSessionIdAlphabet(String sessionIdAlphabet) {
        if (this.tomcatDeployer != null) {
            this.tomcatDeployer.setSessionIdAlphabet(sessionIdAlphabet);
        }
    }

    public void setSubjectAttributeName(String name) {
        if (this.tomcatDeployer != null) {
            this.tomcatDeployer.setSubjectAttributeName(name);
        }
    }

    public void setUseJBossWebLoader(boolean flag) {
        if (this.tomcatDeployer != null) {
            this.tomcatDeployer.setUseJBossWebLoader(flag);
        }
    }

    public void startConnectors() throws Exception {
        if (this.tomcatDeployer == null) {
            throw new IllegalStateException("Must set TomcatDeployer before starting connectors");
        }
        if (this.connectorsRunning) {
            return;
        }
        MBeanServer server = super.getServer();
        ObjectName service = new ObjectName(this.tomcatDeployer.getDomain() + ":type=Service,serviceName=jboss.web");
        Object[] args = new Object[]{};
        String[] sig = new String[]{};
        Connector[] connectors = (Connector[])server.invoke(service, "findConnectors", args, sig);
        for (int n = 0; n < connectors.length; ++n) {
            Connector lc = connectors[n];
            lc.start();
        }
        this.connectorsRunning = true;
    }

    public void stopConnectors() throws Exception {
        if (this.tomcatDeployer == null) {
            throw new IllegalStateException("Must set TomcatDeployer before stopping connectors");
        }
        if (!this.connectorsRunning) {
            return;
        }
        MBeanServer server = super.getServer();
        ObjectName service = new ObjectName(this.tomcatDeployer.getDomain() + ":type=Service,serviceName=jboss.web");
        Object[] args = new Object[]{};
        String[] sig = new String[]{};
        Connector[] connectors = (Connector[])server.invoke(service, "findConnectors", args, sig);
        for (int n = 0; n < connectors.length; ++n) {
            connectors[n].pause();
            connectors[n].stop();
        }
        this.connectorsRunning = false;
    }

    @Override
    public void handleNotification(Notification msg, Object handback) {
        String type = msg.getType();
        if (type.equals("org.jboss.system.server.started")) {
            this.log.debug((Object)("Saw " + type + " notification, starting connectors"));
            try {
                this.startConnectors();
            }
            catch (Exception e) {
                this.log.warn((Object)"Failed to startConnectors", (Throwable)e);
            }
        }
        if (type.equals("org.jboss.system.server.stopped")) {
            this.log.debug((Object)("Saw " + type + " notification, stopping connectors"));
            try {
                this.stopConnectors();
            }
            catch (Exception e) {
                this.log.warn((Object)"Failed to stopConnectors", (Throwable)e);
            }
        }
    }

    public String getDefaultSecurityDomain() {
        return this.tomcatDeployer == null ? null : this.tomcatDeployer.getDefaultSecurityDomain();
    }

    public boolean getJava2ClassLoadingCompliance() {
        return this.tomcatDeployer == null ? false : this.tomcatDeployer.getJava2ClassLoadingCompliance();
    }

    public boolean getLenientEjbLink() {
        return this.tomcatDeployer == null ? false : this.tomcatDeployer.getLenientEjbLink();
    }

    public boolean getUnpackWars() {
        return this.tomcatDeployer == null ? false : this.tomcatDeployer.getUnpackWars();
    }

    public void setDefaultSecurityDomain(String defaultSecurityDomain) {
        if (this.tomcatDeployer != null) {
            this.tomcatDeployer.setDefaultSecurityDomain(defaultSecurityDomain);
        }
    }

    public void setJava2ClassLoadingCompliance(boolean flag) {
        if (this.tomcatDeployer != null) {
            this.tomcatDeployer.setJava2ClassLoadingCompliance(flag);
        }
    }

    public void setLenientEjbLink(boolean flag) {
        if (this.tomcatDeployer != null) {
            this.tomcatDeployer.setLenientEjbLink(flag);
        }
    }

    public void setUnpackWars(boolean flag) {
        if (this.tomcatDeployer != null) {
            this.tomcatDeployer.setUnpackWars(flag);
        }
    }

    public String getHttpHeaderForSSOAuth() {
        return this.tomcatDeployer == null ? null : this.tomcatDeployer.getHttpHeaderForSSOAuth();
    }

    public void setHttpHeaderForSSOAuth(String httpHeaderForSSOAuth) {
        if (this.tomcatDeployer != null) {
            this.tomcatDeployer.setHttpHeaderForSSOAuth(httpHeaderForSSOAuth);
        }
    }

    public String getSessionCookieForSSOAuth() {
        return this.tomcatDeployer == null ? null : this.tomcatDeployer.getSessionCookieForSSOAuth();
    }

    public void setSessionCookieForSSOAuth(String sessionCookieForSSOAuth) {
        if (this.tomcatDeployer != null) {
            this.tomcatDeployer.setSessionCookieForSSOAuth(sessionCookieForSSOAuth);
        }
    }

    public void setKernelControllerContext(KernelControllerContext controllerContext) throws Exception {
        super.setKernelControllerContext(controllerContext);
        KernelController kernelController = controllerContext == null ? null : controllerContext.getKernel().getController();
        JBossWebMicrocontainerBeanLocator.setKernelController(kernelController);
    }

    public void unsetKernelControllerContext(KernelControllerContext controllerContext) throws Exception {
        super.unsetKernelControllerContext(controllerContext);
        JBossWebMicrocontainerBeanLocator.setKernelController(null);
    }
}

