/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service.session;

import java.util.HashMap;
import java.util.Map;
import org.jboss.web.tomcat.service.session.ClusteredManager;
import org.jboss.web.tomcat.service.session.ClusteredSession;
import org.jboss.web.tomcat.service.session.distributedcache.spi.DistributedCacheManager;

class AttributeBasedClusteredSession
extends ClusteredSession {
    static final long serialVersionUID = -5625209785550936713L;
    protected static final String info = "AttributeBasedClusteredSession/1.0";
    private transient Map<String, Object> attrModifiedMap_ = new HashMap<String, Object>();
    private transient Map<String, Object> attrRemovedMap_ = new HashMap<String, Object>();

    public AttributeBasedClusteredSession(ClusteredManager manager) {
        super(manager);
    }

    public String getInfo() {
        return info;
    }

    public void recycle() {
        super.recycle();
        this.clearAttrChangedMaps();
    }

    protected Object getAttributeInternal(String name) {
        Object result = this.getAttributesInternal().get(name);
        if (this.isGetDirty(result) && !replicationExcludes.contains(name)) {
            this.attributeChanged(name, result, false);
        }
        return result;
    }

    protected Object removeAttributeInternal(String name, boolean localCall, boolean localOnly) {
        Object result = this.getAttributesInternal().remove(name);
        if (localCall && !replicationExcludes.contains(name)) {
            this.attributeChanged(name, result, true);
        }
        return result;
    }

    protected Object setAttributeInternal(String key, Object value) {
        Object old = this.getAttributesInternal().put(key, value);
        if (!replicationExcludes.contains(key)) {
            this.attributeChanged(key, value, false);
        }
        return old;
    }

    protected synchronized void replicateAttributes() {
        String myRealId = this.getRealId();
        if (this.isSessionAttributeMapDirty()) {
            DistributedCacheManager distributedCacheManager = this.getDistributedCacheManager();
            int modCount = this.attrModifiedMap_.size();
            if (modCount == 1) {
                for (Map.Entry<String, Object> entry : this.attrModifiedMap_.entrySet()) {
                    distributedCacheManager.putAttribute(myRealId, entry.getKey(), entry.getValue());
                }
            } else if (modCount > 0) {
                distributedCacheManager.putAttribute(myRealId, this.attrModifiedMap_);
            }
            if (this.attrRemovedMap_.size() > 0) {
                for (String key : this.attrRemovedMap_.keySet()) {
                    distributedCacheManager.removeAttribute(myRealId, key);
                }
            }
            this.clearAttrChangedMaps();
        }
    }

    private synchronized void attributeChanged(String key, Object value, boolean removal) {
        if (removal) {
            if (this.attrModifiedMap_.containsKey(key)) {
                this.attrModifiedMap_.remove(key);
            }
            this.attrRemovedMap_.put(key, value);
        } else {
            if (this.attrRemovedMap_.containsKey(key)) {
                this.attrRemovedMap_.remove(key);
            }
            this.attrModifiedMap_.put(key, value);
        }
        this.sessionAttributesDirty();
    }

    private synchronized void clearAttrChangedMaps() {
        this.attrRemovedMap_.clear();
        this.attrModifiedMap_.clear();
    }
}

