/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service.session;

import java.io.IOException;
import java.util.Map;
import javax.servlet.ServletException;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Manager;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.valves.ValveBase;
import org.jboss.servlet.http.HttpEvent;
import org.jboss.web.tomcat.service.session.ClusteredSession;
import org.jboss.web.tomcat.service.session.SessionReplicationContext;
import org.jboss.web.tomcat.service.session.SnapshotManager;
import org.jboss.web.tomcat.service.session.distributedcache.spi.BatchingManager;

public class ClusteredSessionValve
extends ValveBase
implements Lifecycle {
    private static final String info = "ClusteredSessionValve/1.0";
    private final LifecycleSupport support = new LifecycleSupport((Lifecycle)this);
    private final Manager manager;
    private final BatchingManager tm;

    public ClusteredSessionValve(Manager manager, BatchingManager tm) {
        assert (manager != null) : "manager is null";
        this.manager = manager;
        this.tm = tm;
    }

    public String getInfo() {
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void invoke(Request request, Response response) throws IOException, ServletException {
        block18: {
            SessionReplicationContext.enterWebapp(request, response, true);
            boolean startedBatch = this.startBatchTransaction();
            String requestedId = request.getRequestedSessionId();
            if (requestedId != null) {
                this.manager.findSession(requestedId);
            }
            this.getNext().invoke(request, response);
            Object var6_5 = null;
            try {
                SessionReplicationContext ctx = SessionReplicationContext.exitWebapp();
                if (ctx.getSoleSnapshotManager() != null) {
                    ctx.getSoleSnapshotManager().snapshot(ctx.getSoleSession());
                } else {
                    Map<ClusteredSession, SnapshotManager> sessions = ctx.getCrossContextSessions();
                    if (sessions != null && sessions.size() > 0) {
                        for (Map.Entry<ClusteredSession, SnapshotManager> entry : sessions.entrySet()) {
                            entry.getValue().snapshot(entry.getKey());
                        }
                    }
                }
                Object var12_15 = null;
            }
            catch (Throwable throwable) {
                Object var12_16 = null;
                SessionReplicationContext.finishCacheActivity();
                if (startedBatch) {
                    this.tm.endBatch();
                }
                throw throwable;
            }
            SessionReplicationContext.finishCacheActivity();
            if (startedBatch) {
                this.tm.endBatch();
            }
            break block18;
            catch (Throwable throwable) {
                Object var6_6 = null;
                try {
                    SessionReplicationContext ctx = SessionReplicationContext.exitWebapp();
                    if (ctx.getSoleSnapshotManager() != null) {
                        ctx.getSoleSnapshotManager().snapshot(ctx.getSoleSession());
                    } else {
                        Map<ClusteredSession, SnapshotManager> sessions = ctx.getCrossContextSessions();
                        if (sessions != null && sessions.size() > 0) {
                            for (Map.Entry<ClusteredSession, SnapshotManager> entry : sessions.entrySet()) {
                                entry.getValue().snapshot(entry.getKey());
                            }
                        }
                    }
                    Object var12_17 = null;
                }
                catch (Throwable throwable2) {
                    Object var12_18 = null;
                    SessionReplicationContext.finishCacheActivity();
                    if (startedBatch) {
                        this.tm.endBatch();
                    }
                    throw throwable2;
                }
                SessionReplicationContext.finishCacheActivity();
                if (startedBatch) {
                    this.tm.endBatch();
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void event(Request request, Response response, HttpEvent event) throws IOException, ServletException {
        block18: {
            SessionReplicationContext.enterWebapp(request, response, true);
            boolean startedBatch = this.startBatchTransaction();
            String requestedId = request.getRequestedSessionId();
            if (requestedId != null) {
                this.manager.findSession(requestedId);
            }
            this.getNext().event(request, response, event);
            Object var7_6 = null;
            try {
                SessionReplicationContext ctx = SessionReplicationContext.exitWebapp();
                if (ctx.getSoleSnapshotManager() != null) {
                    ctx.getSoleSnapshotManager().snapshot(ctx.getSoleSession());
                } else {
                    Map<ClusteredSession, SnapshotManager> sessions = ctx.getCrossContextSessions();
                    if (sessions != null && sessions.size() > 0) {
                        for (Map.Entry<ClusteredSession, SnapshotManager> entry : sessions.entrySet()) {
                            entry.getValue().snapshot(entry.getKey());
                        }
                    }
                }
                Object var13_16 = null;
            }
            catch (Throwable throwable) {
                Object var13_17 = null;
                SessionReplicationContext.finishCacheActivity();
                if (startedBatch) {
                    this.tm.endBatch();
                }
                throw throwable;
            }
            SessionReplicationContext.finishCacheActivity();
            if (startedBatch) {
                this.tm.endBatch();
            }
            break block18;
            catch (Throwable throwable) {
                Object var7_7 = null;
                try {
                    SessionReplicationContext ctx = SessionReplicationContext.exitWebapp();
                    if (ctx.getSoleSnapshotManager() != null) {
                        ctx.getSoleSnapshotManager().snapshot(ctx.getSoleSession());
                    } else {
                        Map<ClusteredSession, SnapshotManager> sessions = ctx.getCrossContextSessions();
                        if (sessions != null && sessions.size() > 0) {
                            for (Map.Entry<ClusteredSession, SnapshotManager> entry : sessions.entrySet()) {
                                entry.getValue().snapshot(entry.getKey());
                            }
                        }
                    }
                    Object var13_18 = null;
                }
                catch (Throwable throwable2) {
                    Object var13_19 = null;
                    SessionReplicationContext.finishCacheActivity();
                    if (startedBatch) {
                        this.tm.endBatch();
                    }
                    throw throwable2;
                }
                SessionReplicationContext.finishCacheActivity();
                if (startedBatch) {
                    this.tm.endBatch();
                }
                throw throwable;
            }
        }
    }

    public void addLifecycleListener(LifecycleListener listener) {
        this.support.addLifecycleListener(listener);
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        this.support.removeLifecycleListener(listener);
    }

    public LifecycleListener[] findLifecycleListeners() {
        return this.support.findLifecycleListeners();
    }

    public void start() throws LifecycleException {
        this.support.fireLifecycleEvent("start", (Object)this);
    }

    public void stop() throws LifecycleException {
        this.support.fireLifecycleEvent("stop", (Object)this);
    }

    private boolean startBatchTransaction() throws ServletException {
        boolean started = false;
        try {
            if (this.tm != null && !this.tm.isBatchInProgress()) {
                this.tm.startBatch();
                started = true;
            }
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new ServletException("Failed to initiate batch replication transaction", (Throwable)e);
        }
        return started;
    }
}

