/*
 * Decompiled with CFR 0.152.
 */
package org.java.plugin;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.java.plugin.PathResolver;
import org.java.plugin.PluginManager;
import org.java.plugin.registry.PluginRegistry;
import org.java.plugin.standard.StandardObjectFactory;
import org.java.plugin.util.ExtendedProperties;
import org.java.plugin.util.IoUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ObjectFactory {
    public static ObjectFactory newInstance() {
        return ObjectFactory.newInstance(null);
    }

    public static ObjectFactory newInstance(ExtendedProperties extendedProperties) {
        ObjectFactory objectFactory;
        Log log = LogFactory.getLog(ObjectFactory.class);
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = ObjectFactory.class.getClassLoader();
        }
        ExtendedProperties extendedProperties2 = extendedProperties != null ? extendedProperties : ObjectFactory.loadProperties(classLoader);
        String string = ObjectFactory.findProperty(classLoader, extendedProperties2);
        try {
            if (string == null) {
                string = "org.java.plugin.standard.StandardObjectFactory";
            }
            objectFactory = (ObjectFactory)ObjectFactory.loadClass(classLoader, string).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            log.fatal((Object)("failed instantiating object factory " + string), (Throwable)classNotFoundException);
            throw new Error("failed instantiating object factory " + string, classNotFoundException);
        }
        catch (IllegalAccessException illegalAccessException) {
            log.fatal((Object)("failed instantiating object factory " + string), (Throwable)illegalAccessException);
            throw new Error("failed instantiating object factory " + string, illegalAccessException);
        }
        catch (SecurityException securityException) {
            log.fatal((Object)("failed instantiating object factory " + string), (Throwable)securityException);
            throw new Error("failed instantiating object factory " + string, securityException);
        }
        catch (InstantiationException instantiationException) {
            log.fatal((Object)("failed instantiating object factory " + string), (Throwable)instantiationException);
            throw new Error("failed instantiating object factory " + string, instantiationException);
        }
        objectFactory.configure(extendedProperties2);
        log.debug((Object)("object factory instance created - " + objectFactory));
        return objectFactory;
    }

    private static Class<?> loadClass(ClassLoader classLoader, String string) throws ClassNotFoundException {
        ClassLoader classLoader2;
        if (classLoader != null) {
            try {
                return classLoader.loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if ((classLoader2 = ObjectFactory.class.getClassLoader()) != null) {
            try {
                return classLoader2.loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return ClassLoader.getSystemClassLoader().loadClass(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ExtendedProperties loadProperties(ClassLoader classLoader) {
        ExtendedProperties extendedProperties;
        Log log = LogFactory.getLog(ObjectFactory.class);
        File file = new File(System.getProperty("java.home") + File.separator + "lib" + File.separator + "jpf.properties");
        URL uRL = null;
        if (file.canRead()) {
            try {
                uRL = IoUtil.file2url(file);
            }
            catch (MalformedURLException malformedURLException) {
                log.error((Object)("failed converting file " + file + " to URL"), (Throwable)malformedURLException);
            }
        }
        if (uRL == null) {
            if (classLoader != null) {
                uRL = classLoader.getResource("jpf.properties");
                if (uRL == null) {
                    uRL = ClassLoader.getSystemResource("jpf.properties");
                }
            } else {
                uRL = ClassLoader.getSystemResource("jpf.properties");
            }
            if (uRL == null) {
                log.debug((Object)("no jpf.properties file found in ${java.home}/lib (" + file + ") nor in CLASSPATH, using standard properties"));
                uRL = StandardObjectFactory.class.getResource("jpf.properties");
            }
        }
        InputStream inputStream = IoUtil.getResourceInputStream(uRL);
        try {
            ExtendedProperties extendedProperties2 = new ExtendedProperties();
            extendedProperties2.load(inputStream);
            log.debug((Object)("loaded jpf.properties from " + uRL));
            extendedProperties = extendedProperties2;
        }
        catch (Throwable throwable) {
            try {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
            catch (Exception exception) {
                log.error((Object)"failed loading jpf.properties from CLASSPATH", (Throwable)exception);
                return null;
            }
        }
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return extendedProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String findProperty(ClassLoader classLoader, ExtendedProperties extendedProperties) {
        Log log = LogFactory.getLog(ObjectFactory.class);
        String string = ObjectFactory.class.getName();
        String string2 = System.getProperty(string);
        if (string2 != null) {
            log.debug((Object)("property " + string + " found as system property"));
            return string2;
        }
        if (extendedProperties != null && (string2 = extendedProperties.getProperty(string)) != null) {
            log.debug((Object)("property " + string + " found in properties file"));
            return string2;
        }
        String string3 = "META-INF/services/" + ObjectFactory.class.getName();
        InputStream inputStream = classLoader == null ? ClassLoader.getSystemResourceAsStream(string3) : classLoader.getResourceAsStream(string3);
        if (inputStream != null) {
            try {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
                try {
                    string2 = bufferedReader.readLine();
                }
                finally {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            catch (IOException iOException) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
            }
        }
        if (string2 != null) {
            log.debug((Object)("property " + string + " found as service"));
            return string2;
        }
        log.debug((Object)("no property " + string + " found"));
        return string2;
    }

    protected abstract void configure(ExtendedProperties var1);

    public final PluginManager createManager() {
        return this.createManager(this.createRegistry(), this.createPathResolver());
    }

    public abstract PluginManager createManager(PluginRegistry var1, PathResolver var2);

    public abstract PluginRegistry createRegistry();

    public abstract PathResolver createPathResolver();
}

