/*
 * Decompiled with CFR 0.152.
 */
package org.java.plugin.registry.xml;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.java.plugin.registry.Documentation;
import org.java.plugin.registry.ManifestProcessingException;
import org.java.plugin.registry.MatchingRule;
import org.java.plugin.registry.PluginDescriptor;
import org.java.plugin.registry.PluginFragment;
import org.java.plugin.registry.PluginPrerequisite;
import org.java.plugin.registry.Version;
import org.java.plugin.registry.xml.DocumentationImpl;
import org.java.plugin.registry.xml.ModelPrerequisite;
import org.java.plugin.registry.xml.PluginDescriptorImpl;
import org.java.plugin.registry.xml.PluginFragmentImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PluginPrerequisiteImpl
implements PluginPrerequisite {
    private static Log log = LogFactory.getLog(PluginPrerequisiteImpl.class);
    private final PluginDescriptorImpl descriptor;
    private final PluginFragmentImpl fragment;
    private final ModelPrerequisite model;
    private DocumentationImpl<PluginPrerequisite> doc;

    static boolean matches(Version version, Version version2, MatchingRule matchingRule) {
        if (version == null) {
            return true;
        }
        switch (matchingRule) {
            case EQUAL: {
                return version2.equals(version);
            }
            case EQUIVALENT: {
                return version2.isEquivalentTo(version);
            }
            case COMPATIBLE: {
                return version2.isCompatibleWith(version);
            }
            case GREATER_OR_EQUAL: {
                return version2.isGreaterOrEqualTo(version);
            }
        }
        return version2.isCompatibleWith(version);
    }

    PluginPrerequisiteImpl(PluginDescriptorImpl pluginDescriptorImpl, PluginFragmentImpl pluginFragmentImpl, ModelPrerequisite modelPrerequisite) throws ManifestProcessingException {
        this.descriptor = pluginDescriptorImpl;
        this.fragment = pluginFragmentImpl;
        this.model = modelPrerequisite;
        if (this.model.getPluginId() == null || this.model.getPluginId().trim().length() == 0) {
            throw new ManifestProcessingException("org.java.plugin.registry.xml", "prerequisitePliginIdIsBlank", pluginDescriptorImpl.getId());
        }
        if (pluginDescriptorImpl.getId().equals(this.model.getPluginId())) {
            throw new ManifestProcessingException("org.java.plugin.registry.xml", "invalidPrerequisitePluginId", pluginDescriptorImpl.getId());
        }
        if (this.model.getId() == null || this.model.getId().trim().length() == 0) {
            this.model.setId("prerequisite:" + this.model.getPluginId());
        }
        if (this.model.getDocumentation() != null) {
            this.doc = new DocumentationImpl<PluginPrerequisiteImpl>(this, this.model.getDocumentation());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("object instantiated: " + this));
        }
    }

    @Override
    public String getPluginId() {
        return this.model.getPluginId();
    }

    @Override
    public Version getPluginVersion() {
        return this.model.getPluginVersion();
    }

    @Override
    public PluginDescriptor getDeclaringPluginDescriptor() {
        return this.descriptor;
    }

    @Override
    public PluginFragment getDeclaringPluginFragment() {
        return this.fragment;
    }

    @Override
    public boolean isOptional() {
        return this.model.isOptional();
    }

    @Override
    public boolean isReverseLookup() {
        return this.model.isReverseLookup();
    }

    @Override
    public boolean matches() {
        PluginDescriptor pluginDescriptor = null;
        try {
            pluginDescriptor = this.descriptor.getRegistry().getPluginDescriptor(this.model.getPluginId());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        return PluginPrerequisiteImpl.matches(this.model.getPluginVersion(), pluginDescriptor.getVersion(), this.model.getMatchingRule());
    }

    @Override
    public MatchingRule getMatchingRule() {
        return this.model.getMatchingRule();
    }

    @Override
    public boolean isExported() {
        return this.model.isExported();
    }

    @Override
    public String getId() {
        return this.model.getId();
    }

    @Override
    public String getDocsPath() {
        return this.fragment != null ? this.fragment.getDocsPath() : this.descriptor.getDocsPath();
    }

    @Override
    public Documentation<PluginPrerequisite> getDocumentation() {
        return this.doc;
    }

    @Override
    public String getUniqueId() {
        return this.descriptor.getRegistry().makeUniqueId(this.descriptor.getId(), this.getId());
    }

    public String toString() {
        return "{Prerequisite: uid=" + this.getUniqueId() + "}";
    }
}

