/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.search;

import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.AssetState;
import com.tandbergtv.metadatamanager.search.AssetSearchKey;
import com.tandbergtv.metadatamanager.search.AssetSearchService;
import com.tandbergtv.metadatamanager.search.FieldInfo;
import com.tandbergtv.metadatamanager.search.SearchInfo;
import com.tandbergtv.metadatamanager.search.SortInfo;
import com.tandbergtv.watchpoint.search.Entity;
import com.tandbergtv.watchpoint.search.Join;
import com.tandbergtv.watchpoint.search.QueryBuilder;
import com.tandbergtv.workflow.driver.search.SearchOperator;
import com.tandbergtv.workflow.driver.search.SearchParameterBase;
import com.tandbergtv.workflow.driver.search.SearchType;
import com.tandbergtv.workflow.driver.search.SortParameter;
import com.tandbergtv.workflow.driver.search.ValueParameter;
import com.tandbergtv.workflow.util.SearchCriteria;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.HibernateTemplate;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public class AssetSearchServiceImpl
implements AssetSearchService {
    private HibernateTemplate hibernateTemplate;
    private static final Logger logger = Logger.getLogger(AssetSearchServiceImpl.class);

    @Override
    @Transactional
    public int count(final SearchCriteria criteria) {
        Integer count = (Integer)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query query = session.createQuery(AssetSearchServiceImpl.this.getCountQuery(criteria));
                return query.uniqueResult();
            }
        });
        return count;
    }

    public String getQuery(SearchCriteria criteria) {
        return QueryBuilder.newInstance().buildQuery(criteria);
    }

    public String getCountQuery(SearchCriteria criteria) {
        return QueryBuilder.newInstance().buildCountQuery(criteria);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW, readOnly=true)
    public Collection<Asset> search(SearchCriteria criteria) {
        Collection<Object> assets = new ArrayList();
        final int index = criteria.getStartingRecordNumber();
        final int count = criteria.getRecordsCount();
        final String s = this.getQuery(criteria);
        logger.debug((Object)("Executing query :" + System.getProperty("line.separator") + s));
        List result = (List)this.getHibernateTemplate().executeWithNativeSession(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                session.enableFilter("relationRevisionFilter").setParameter("revisionParam", (Object)Integer.MAX_VALUE);
                Query query = session.createQuery(s);
                query.setFirstResult(index);
                query.setMaxResults(count == 0 ? Integer.MAX_VALUE : count);
                return query.list();
            }
        });
        assets = this.getAssets(result);
        for (Asset asset : assets) {
            if (asset.getRoot() != null) {
                asset.getRoot().loadCompleteTree();
                continue;
            }
            asset.loadCompleteTree();
        }
        return assets;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW, readOnly=true)
    public Collection<Long> searchForAssetID(SearchCriteria criteria) {
        final int index = criteria.getStartingRecordNumber();
        final int count = criteria.getRecordsCount();
        final String s = this.getQuery(criteria);
        logger.debug((Object)("Executing query :" + System.getProperty("line.separator") + s));
        List result = (List)this.getHibernateTemplate().executeWithNativeSession(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                session.enableFilter("relationRevisionFilter").setParameter("revisionParam", (Object)Integer.MAX_VALUE);
                Query query = session.createQuery(s);
                query.setFirstResult(index);
                query.setMaxResults(count == 0 ? Integer.MAX_VALUE : count);
                return query.list();
            }
        });
        return result;
    }

    public HibernateTemplate getHibernateTemplate() {
        return this.hibernateTemplate;
    }

    public void setHibernateTemplate(HibernateTemplate hibernateTemplate) {
        this.hibernateTemplate = hibernateTemplate;
    }

    private Collection<Asset> getAssets(List<?> result) {
        ArrayList<Asset> assets = new ArrayList<Asset>();
        for (Object object : result) {
            Asset asset = null;
            asset = object instanceof Asset ? (Asset)Asset.class.cast(object) : (Asset)((Object[])object)[0];
            assets.add(asset);
        }
        return assets;
    }

    @Override
    public SearchCriteria getCriteria(String rootEntityAlias, SearchInfo searchInfo, SortInfo sortInfo, int revision) {
        SearchCriteria crit = new SearchCriteria();
        Entity assetEntity = new Entity(rootEntityAlias, Asset.class, "a");
        this.buildActiveAssetCriteria(assetEntity);
        if (searchInfo != null) {
            List<FieldInfo> fieldInfos = searchInfo.getFields();
            for (FieldInfo fieldInfo : fieldInfos) {
                fieldInfo.createEntity(searchInfo.getProperty(), assetEntity);
            }
        }
        if (sortInfo != null) {
            if (sortInfo.getProperty() == null || sortInfo.getProperty().equals("")) {
                SortParameter sortParam = new SortParameter(sortInfo.getSortItemName(), sortInfo.getOrder());
                assetEntity.addParameter((SearchParameterBase)sortParam);
            } else {
                Entity sortField = new Entity("field", sortInfo.getProperty(), "f");
                ArrayList<String> selectPropertyNames = new ArrayList<String>();
                selectPropertyNames.add("value");
                sortField.setSelectPropertyNames(selectPropertyNames);
                sortField.setJoin(Join.LEFT_OUTER);
                sortField.setFetch(true);
                sortField.addParameter((SearchParameterBase)new SortParameter("value", sortInfo.getOrder()));
                sortField.addParameter((SearchParameterBase)new ValueParameter("ttvXPath", SearchType.STRING, (Object)sortInfo.getSortItemName(), SearchOperator.EQUAL));
                assetEntity.addParameter((SearchParameterBase)sortField);
            }
        }
        this.buildRevsionCriteria(revision, assetEntity);
        crit.addParameter((SearchParameterBase)assetEntity);
        return crit;
    }

    @Override
    public SearchCriteria getRootAssetCriteria(String rootEntityAlias) {
        SearchCriteria crit = new SearchCriteria();
        Entity assetEntity = new Entity(rootEntityAlias, Asset.class, "a");
        assetEntity.addParameter((SearchParameterBase)new ValueParameter(AssetSearchKey.ASSET_ROOT.toString(), SearchType.NUMERIC, (Object)null));
        this.buildActiveAssetCriteria(assetEntity);
        this.buildLatestRevisionCriteria(assetEntity);
        crit.addParameter((SearchParameterBase)assetEntity);
        return crit;
    }

    private void buildActiveAssetCriteria(Entity assetEntity) {
        assetEntity.addParameter((SearchParameterBase)new ValueParameter(AssetSearchKey.ASSET_STATE.toString(), SearchType.NUMERIC, (Object)AssetState.ACTIVE.ordinal()));
    }

    private void buildLatestRevisionCriteria(Entity assetEntity) {
    }

    private void buildRevsionCriteria(int revision, Entity assetEntity) {
    }
}

