
package com.smartgwt.client.docs;

/**
 * <b>FormItem Placement in Columns and Rows</b>&#010 <P>&#010 With the default tabular layout mechanism, items are laid out in rows from left to&#010 right until the number of columns, specified by {@link com.smartgwt.client.widgets.form.DynamicForm#getNumCols numCols},&#010 is filled, then a new row is begun.  Flags on FormItems, including&#010 {@link com.smartgwt.client.widgets.form.fields.FormItem#getStartRow startRow}, {@link com.smartgwt.client.widgets.form.fields.FormItem#getEndRow endRow},&#010 {@link com.smartgwt.client.widgets.form.fields.FormItem#getColSpan colSpan} and {@link com.smartgwt.client.widgets.form.fields.FormItem#getRowSpan rowSpan}, control row and&#010 column placement and spanning.  &#010 <P>&#010 Note that the most common form items (TextItem, SelectItem, etc) take up <b>two</b>&#010 columns by default: one for the form control itself, and one for it's title.  The&#010 default setting of {@link com.smartgwt.client.widgets.form.DynamicForm#getNumCols numCols} will result in one TextItem&#010 or SelectItem per row.&#010 <P>&#010 Note also that ButtonItems have both startRow:true and endRow:true by default.  You must&#010 set startRow and/or endRow to <code>false</code> on a ButtonItem in order to place a&#010 button in the same row as any other item.&#010 <P>&#010 The log category "tablePlacement" can be enabled from the Developer Console to watch&#010 items being placed.  You can also set {@link com.smartgwt.client.widgets.form.DynamicForm#getCellBorder cellBorder} to&#010 reveal the table structure for layout troubleshooting purposes.&#010 <P>&#010 <b>Row and Column Sizing</b>&#010 <P>&#010 {@link com.smartgwt.client.widgets.form.DynamicForm#getColWidths colWidths} controls the widths of form columns.  FormItems that have&#010 "*" for {@link com.smartgwt.client.widgets.form.fields.FormItem#getWidth width} will fill the column.  FormItems with a numeric width will&#010 have that width in pixels regardless of the column's specified width, which may cause the&#010 column to overflow as described under {@link com.smartgwt.client.widgets.form.DynamicForm#getFixedColWidths fixedColWidths}.&#010 <P>&#010 For row heights, the largest pixel height specified on any item in the row is taken as a&#010 minimum size for the row.  Then, any rows that have "*" or "%" height items will share&#010 any height not taken up by fixed-sized items.&#010 <P>&#010 <b>Managing Overflow</b>&#010 <P>&#010 Forms often contain labels, data values, or instructional text which can vary in&#010 size based on the skin, data values, or internationalization settings.  There are a few&#010 ways to deal with a form potentially varying in size:&#010 <ol>&#010 <li> Allow scrolling when necessary, using {@link com.smartgwt.client.widgets.Canvas#getOverflow overflow}, either&#010 on the immediate form, or on some parent.&#010 <li> Place the form in a Layout along with a component that can render any specified&#010 size, such as a {@link com.smartgwt.client.widgets.grid.ListGrid}.  In this case, the Layout will automatically shrink the&#010 grid in order to accomodate the form.&#010 <li> Ensure that the form can always render at a designed minimum size by reducing&#010 the number of cases of variable-sized text, and testing remaining cases across all&#010 supported skins.  For example, move help text into hovers on help icons, or clip &#010 long text values at a maximum length and provide a hover to see the rest.&#010 </ol>&#010&#010 Several examples of Form Layout are available ${isc.DocUtils.linkForExampleId('formsLayout', 'here')}.
 * @see com.smartgwt.client.widgets.form.DynamicForm#getItemLayout
 * @see com.smartgwt.client.widgets.form.fields.FormItem#getWidth
 * @see com.smartgwt.client.widgets.form.fields.FormItem#getHeight
 * @see com.smartgwt.client.widgets.form.fields.FormItem#getColSpan
 * @see com.smartgwt.client.widgets.form.fields.FormItem#getRowSpan
 * @see com.smartgwt.client.widgets.form.fields.FormItem#getStartRow
 * @see com.smartgwt.client.widgets.form.fields.FormItem#getEndRow
 * @see com.smartgwt.client.widgets.form.fields.ButtonItem#getStartRow
 * @see com.smartgwt.client.widgets.form.fields.ButtonItem#getEndRow
 */
public interface FormLayout {
}
