
package com.smartgwt.client.docs;

/**
 * The SmartGWT Server is a set of Java libraries, servlets and tools that provide the key&#010 server-side components needed to build a complete application in the modern web&#010 architecture.&#010 <P>&#010 The SmartGWT Server can be {@link com.smartgwt.client.docs.IscInstall 'integrated'} into any pre-existing Java&#010 application, and is designed to rapidly connect SmartGWT visual components to&#010 pre-existing Java business logic or persistence engines.  SmartGWT's Ajax request&#010 processing facilities can be easily integrated into Struts Actions,&#010 {@link com.smartgwt.client.docs.SpringIntegration 'Spring controllers'}, or custom servlets and JSPs.&#010 <P>&#010 Alternatively, the SmartGWT Server provides a complete SQL and Hibernate-based&#010 persistence engine for new applications, with out-of-the-box servlets for processing Ajax&#010 data requests.&#010 <P>&#010 The SmartGWT Server is optional, and SmartGWT's client-side Ajax engine can be&#010 integrated with any server that provides HTTP access, using XML, JSON, SOAP or proprietary&#010 data protocols.  However any server in a modern web application will be required to provide&#010 most or all of the features of the SmartGWT Server (described below), and the SmartGWT&#010 Server represents a best-of-breed implementation of these facilities with a long history of&#010 high-volume production deployments.&#010 <P>&#010 <h4>Server enforcement of {@link com.smartgwt.client.widgets.form.validator.Validator}</h4>&#010 <P>&#010 Data passed from the browser can be automatically validated by the SmartGWT Server.&#010 In contrast, when using {@link com.smartgwt.client.docs.ClientDataIntegration 'client-side integration'},&#010 data arrives as HTTP params or XML messages, and you must parse values into the correct&#010 types (eg java.util.Date) and validate them, or use a server framework that does so.&#010 <P>&#010 <h4>High Speed Data Delivery / Data Compression</h4>&#010 <P>&#010 The SmartGWT Server delivers data to and from the browser using a proprietary, maximally&#010 efficient protocol, providing simple Java APIs for sending and receiving data.&#010 <P>&#010 SmartGWT's data protocol is:&#010 <ul>&#010 <li> automatically compressed: provides 6-8x improvement in bandwidth utilization&#010 <li> efficient on the server: high speed data serialization for any Java Object&#010 <li> efficient in the browser: faster than ordinary XML or JSON data delivery&#010 <li> minimal: facilities for {@link com.smartgwt.client.data.DataSource#getDropExtraFields dropExtraFields} and&#010 {@link com.smartgwt.client.data.DataSourceField#getValueXPath valueXPath} only the data you want the browser to see&#010 </ul>&#010 <P>&#010 <h4>Transparent upload support</h4>&#010 <P>&#010 SmartGWT provides special client and server-side support for {@link com.smartgwt.client.docs.Upload 'file&#010 upload'}, which allows single and multiple-file HTTP uploads to be performed as a background&#010 Ajax request without reloading the page or launching sub-windows.&#010 <P>&#010 Uploaded files arrive at the SmartGWT server as Java InputStreams accessible from the&#010 DSRequest object, and can optionally be automatically stored via SmartGWT's SQL&#010 subsystem.&#010 <P>&#010 <h4>Transparent Queuing / "Batch" Operations</h4>&#010 <P>&#010 Any request transmitted to the SmartGWT Server can be combined into a "queue" transmitted&#010 as a single HTTP request, with in-order execution for all queued operations. &#010 {@link com.smartgwt.client.rpc.RPCManager#startQueue} starts a queue and&#010 {@link com.smartgwt.client.rpc.RPCManager#sendQueue} transmits it; queueing is transparent to the code&#010 that initiates the individual requests.  This enables:&#010 <ul>&#010 <li> re-use of data access operations across different screens&#010 <li> easy implementation of transaction boundaries&#010 <li> simplified saving and loading of screens with complex, master-detail views&#010 <li> guaranteed in-order processing of operations&#010 <li> more efficient network usage&#010 </ul>&#010 <P>&#010 <h4>Visual Builder</h4>&#010 <P>&#010 {@link com.smartgwt.client.docs.VisualBuilder 'Visual Builder'} is included with the SmartGWT Server, and uses&#010 server features such as automatic SQL binding to provide a rapid prototyping environment.&#010 <P>&#010 <h4>Automatic Bi-directional Java &lt; - &gt; JavaScript serialization and translation</h4>&#010 <P>&#010 Provides a powerful, type-safe {@link com.smartgwt.client.rpc.RPCRequest#getData data} for moving&#010 data between a Java server and the browser. &#010 <P>&#010 Any Java objects, including Java Beans, POJOs, Java Collections, XML DOMs and all Java&#010 primitives, with any level of nesting, can be automatically serialized and delivered as&#010 JavaScript Objects to the SmartGWT client-side components.&#010 <P>&#010 JavaScript Objects existing in the browser can likewise be automatically transmitted to a&#010 Java Server and translated to Java Objects, with any level of nesting and automatic&#010 preservation of primitive types.&#010 <P>&#010 <h4>SQL and Hibernate connectors</h4>&#010 <P>&#010 DataSource of serverType:"sql" or serverType:"hibernate" can generate and execute queries&#010 against popular SQL engines or against the Hibernate ORM system, providing SmartGWT's&#010 {@link com.smartgwt.client.widgets.DataBoundComponent}s with the four standard CRUD operations (create, retrieve, update,&#010 delete) without writing any server-side code.  For rapid prototyping, these DataSources can&#010 even generate SQL tables based on the DataSource declaration, using the&#010 {@link com.smartgwt.client.docs.AdminConsole} visual tool.&#010 <P>&#010 Server-side APIs allow server-side modification of the request before it is executed (for&#010 example, to enforce security) and post-processing of the request after execution (for&#010 example, to provide calculated values).&#010 <P>&#010 Both serverType:"sql" and serverType:"hibernate" support the field-operator-value queries&#010 that can be generated by using the {@link com.smartgwt.client.widgets.form.FilterBuilder} component (see&#010 ${isc.DocUtils.linkForExampleId('filterBuilderBracket', 'example')}).&#010 <P>&#010 <h4>Rich, Standardized Request / Response protocol</h4>&#010 <P>&#010 The SmartGWT Server provides a standardized request and response protocol designed for&#010 data-oriented "CRUD" operations (create, retrieve, update, delete).&#010 <P>&#010 This standardized protocol automatically handles {@link com.smartgwt.client.data.DSRequest} (paging&#010 parameters, requested sort order, original values of data being modified) and&#010 {@link com.smartgwt.client.data.DSResponse} (error handling, cache management, session expiration etc).&#010 <P>&#010 Similar to the impact of Struts on early web applications, this standardized protocol avoids&#010 developers in different groups inventing their own incompatible and redundant&#010 request/response protocols, and allows developers to more easily learn code they didn't&#010 author.&#010 <P>&#010 <h4>Bi-directional XPath binding to Java Objects</h4>&#010 <P>&#010 Most UI designs do not directly reflect the underlying Object model and so some degree of&#010 translation is necessary in order to populate UI components with data and apply user changes&#010 to the Java Object model.  This is often accomplished with brittle, difficult to understand&#010 data translation code sprinkled throughout the system, done in a different way for every&#010 screen or component.&#010 <P>&#010 SmartGWT provides a standard, {@link com.smartgwt.client.data.DataSourceField#getValueXPath valueXPath} to&#010 adapting any Java-based Object model to the requirements of the UI design.  Data relevant to&#010 the application UI is centrally extracted in the server-side {@link com.smartgwt.client.data.DataSource} layer, so&#010 that all UI components have a consistent, unified view of the data model for both loading&#010 <b>and</b> saving data.&#010 <P>&#010 <h4>Broadest possible browser support</h4>&#010 <P>&#010 The SmartGWT Server can compensate for facilities &#010 {@link com.smartgwt.client.docs.PlatformDependencies 'missing or disabled in certain browsers'},&#010 including ActiveX being disabled in IE6 and missing XML support in some versions&#010 of Apple's Safari browser.&#010 <P>&#010 <h4>Transparent Proxying</h4>&#010 <P>&#010 {@link com.smartgwt.client.rpc.RPCManager#sendProxied} allows SmartGWT applications to access web&#010 services, RSS feeds, HTML content and other data services in a secure manner regardless of&#010 where they are located: across the enterprise or publicly available.&#010 <P>&#010 <h4>Optional {@link com.smartgwt.client.docs.NetworkPerformance 'Network Performance'} Module</h4>&#010 <P>&#010 Provides:&#010 <ul>&#010 <li> compressed delivery of SmartGWT runtime, application logic and other assets such as CSS&#010 <li> {@link com.smartgwt.client..FileLoader} of SmartGWT and other assets for zero&#010 user-perceived load time&#010 <li> on-the-fly stripping, combining and obfuscation of JavaScript (application code and data)&#010 <li> browser cache control&#010 </ul>&#010 <P>&#010 <h4>Optional Messaging Module (aka server push)</h4>&#010 <P>&#010 The ${isc.DocUtils.linkForDocNode('messaging', 'Messaging')} module allows the server to "push" messages to the client, without&#010 client polling, for real-time monitoring/dashboarding applications.
 */
public interface IscServer {
}
