
package com.smartgwt.client.docs;

/**
 * Client-side processing of web services, XML parsing, and some UI loading mechanisms rely on&#010 a native in-browser XML parser and/or the XMLHttpRequest object - one or both of which will&#010 not be available if the end user disables ActiveX support in Internet Explorer.  Note that&#010 these features do not require plugins or downloads of any kind - IE simply exposes certain&#010 built-in functionality like the XML parser and XMLHttpRequest through the ActiveX&#010 interface.  Disabling ActiveX also disables all browser plugins such as Flash, Java, SVG, etc.&#010 <p>&#010 Barring ActiveX being disabled, the XMLHttpRequest object is available to SmartGWT on all&#010 supported browsers and an XML parser is available on all supported browsers except Safari&#010 versions prior to 3.0.3.&#010 <p>&#010 SmartGWT client-server communication is not affected by the lack of an XML parser or the&#010 XMLHttpRequest object, but the <code>xmlHttpRequest</code> transport will not be available&#010 if the XMLHttpRequest object is not available.  Instead, the <code>hiddenFrame</code> or the&#010 <code>scriptInclude</code> transports are used for client-server communication.&#010 <p>&#010 <b><u>XML Parser</u></b>&#010 <p>&#010 If an XML Parser is not available to SmartGWT, all client-side web service bindings and&#010 related methods will be unavailable.  Turning off ActiveX disables integration paths 2 and 3&#010 in the diagram below.  If you want to bind to web services and require deployment to IE&#010 without ActiveX (or you need to support Safari pre 3.0.3), you'll need to do all XML processing on the&#010 server and use either the SmartGWT DSRequest or JSON operation pathways (integration&#010 paths 1 and 4 in the diagram below).  See the discussion in {@link com.smartgwt.client.docs.ClientServerIntegration}&#010 for more information on the integration paths shown in the diagram below.&#010 <p>&#010 You call {@link com.smartgwt.client.data.XMLTools#nativeXMLAvailable} to check for the avialability of a native XML&#010 parser at runtime.&#010 <p>&#010 <img src="${isc.DocViewer.instance.referenceRoot}skin/ds_bindings.png" width=763 height=475>&#010 <p>&#010 <b><u>XMLHttpRequest</u></b>&#010 <p>&#010 The XMLHttpRequest object is used for the <code>xmlHttpRequest</code> {@link com.smartgwt.client.types.RPCTransport}.&#010 Safari, Mozilla, Firefox, and IE 7 provide a native XMLHttpRequest implementation that is&#010 not affected by ActiveX being disabled (although the native IE 7 implementation can still be&#010 explicitly disabled by the end user).  IE 5.5 and IE 6.0 rely on the ActiveX bridge to&#010 support XMLHttpRequest, so if ActiveX is disabled in these browsers, XMLHttpRequest will not&#010 be available.&#010 <p>&#010 The lack of the XMLHttpRequest objects affects UI loading features like {@link com.smartgwt.client.widgets.ViewLoader},&#010 and {@link com.smartgwt.client.widgets.HTMLFlow} when used in remote loading mode (via {@link com.smartgwt.client.widgets.HTMLFlow#getContentsURL contentsURL},&#010 {@link com.smartgwt.client.widgets.HTMLFlow#setContentsURL}, but does not affect the typical client/server communication&#010 pathways (integration paths 1 and 5 in the diagram above).&#010 <p>&#010 Also affected are low level features {@link com.smartgwt.client.rpc.RPCRequest#getServerOutputAsString serverOutputAsString},&#010 {@link com.smartgwt.client.rpc.RPCRequest#getEvalResult evalResult}, and {@link com.smartgwt.client.rpc.RPCResponse#getHttpResponseCode httpResponseCode}.&#010 <p>&#010 In all of the above cases, it is possible to use the <code>hiddenFrame</code> transport to&#010 support these features when XMLHttpRequest is not available.  SmartGWT will automatically&#010 send the request using the <code>hiddenFrame</code> transport when it detects that&#010 XMLHttpRequest is unavailable.  To support the above features, you'll need to use the&#010 RPCManager APIs on the server to send back the data that would normally be returned by&#010 XMLHttpRequest.  Since XMLHttpRequest cannot target URLs outside of the current domain, this&#010 strategy applies also to using the above features with cross-domain URLs.&#010 <p>&#010 You can call {@link com.smartgwt.client.rpc.RPCManager#xmlHttpRequestAvailable} to check for the availability of&#010 XMLHttpRequest at runtime.
 */
public interface PlatformDependencies {
}
