
package com.smartgwt.client.docs;

/**
 * For applications that require authentication and use session timeout, a background RPC may&#010 occur with an expired session.  The ideal handling of this scenario is that, with the attempted&#010 transaction still suspended, a modal dialog is used to re-authenticate the user, and then the&#010 original transaction is resumed without loss of data or context.  SmartGWT makes it easy to&#010 implement this ideal handling <i>without</i> having to implement session timeout handling in&#010 every codepath that contacts the server, by providing central notification of session timeout,&#010 and the ability to re-send a transaction that encountered session timeout.&#010 <P>&#010 When session timeout occurs, typical authentication systems intercept requests to protected&#010 resources and return a page that tells the user that login is required.  With a background RPC&#010 this page won't be shown to the user.&#010 <P>&#010 To enable SmartGWT to detect that session timeout has occurred, a snippet of HTML called the&#010 loginRequiredMarker must be added to the session timeout response sent by the authentication&#010 system.  The loginRequiredMarker is standardized and does not need to be customized for your&#010 deployment.  It can be added to an HTML page without visual effect, or if the response sent on&#010 session timeout is not an HTML page, simply embedded in any other type of response, or sent&#010 as the entirety of the response.  The loginRequiredMarker is in&#010 isomorphic/login/loginRequiredMarker.html.&#010 <P>&#010 When SmartGWT detects the loginRequired marker, the transaction that encountered session&#010 timeout is put on hold, and {@link com.smartgwt.client.rpc.RPCManager#loginRequired} is called.  At this point you&#010 have a few options:&#010 <ol>&#010 &#010 <li> Leave the SmartGWT application and take the user to the login page, by simply doing a&#010 <code>window.location.replace(<i>myLoginURL</i>)</code>, the simplest but least user friendly&#010 option.&#010 &#010 <li> Open a new browser window that goes to your plain HTML login form (or offer a link that&#010 opens such a browser window), using a modal dialog in the application page that prompts the&#010 user to login before continuing, then re-send the intercepted transaction&#010 ({@link com.smartgwt.client.rpc.RPCManager#resendTransaction} when the user indicates he has logged in.&#010 This is simple, does not drop context, but is not seamless.&#010 &#010 <li> Use a SmartGWT interface, typically a DynamicForm in a Window, to collect credentials,&#010 perform login as a background RPC, and on success re-send the intercepted transaction&#010 ({@link com.smartgwt.client.rpc.RPCManager#resendTransaction}.  A complete example of this, which assumes&#010 an authentication system that can take credentials as HTTP POST params, is included in the SDK&#010 as isomorphic/login/reloginFlow.js.&#010 &#010 </ol>&#010 <B>Authentication via background RPC form POST</B>&#010 <P>&#010 The approach shown in reloginFlow.js posts the credentials gathered from the user to&#010 {@link com.smartgwt.client.rpc.RPCManager#credentialsURL}.  To make this work with an authentication system that can&#010 accept credentials via HTTP POST:&#010 <ol>&#010 <li> set the RPCManager.credentialsURL to the URL where credentials should be POST'd&#010 <li> include reloginFlow.js in your page, modified, if necessary, so that the names of the&#010 USERNAME and PASSWORD params match what your authentication system uses&#010 <li> configure your authentication system to send back the loginSuccessMarker as part of a&#010 successful login response, and the loginRequiredMarker as part of a failed login response&#010 </ol>&#010 If your authentication system can accept POST'd credentials at any URL it protects, the last&#010 step may be as simple as configuring the loginSuccessMarker file itself as a protected&#010 resource (isomorphic/login/loginSuccess.html).&#010 <P>&#010 <B>Authentication via background SmartGWT server RPC/DMI</B>&#010 <P>&#010 If you are using the SmartGWT Java server and your authentication system allows you to mark&#010 a user as authenticated from Java, you can perform a normal RPC or DMI with the credentials&#010 gathered from the user and send back success or failure indications as normal RPC or DMI&#010 responses.  This can be useful if, in addition to logging in, you want to send back additional&#010 data.&#010 <P>&#010 <B>Advanced: concurrency</B>&#010 <P>&#010 If, after loginRequired() has fired and before the user has re-authenticated, you send&#010 additional RPCs to protected URLs, you will get additional loginRequired() notifications.  This&#010 may happen to applications that poll for data or periodically save without user action.  You&#010 may wish to avoid this by setting an application-specific flag to avoid firing requests during&#010 the relogin process.  However, you must ultimately either&#010 {@link com.smartgwt.client.rpc.RPCManager#resendTransaction} or {@link com.smartgwt.client.rpc.RPCManager#clearTransaction}&#010 every transaction for which loginRequired() fires, or you will have a memory leak due to&#010 suspended transactions.&#010 <P>&#010 Note also that there is no requirement that the relogin process blocks user interaction.&#010 Applications that access multiple services may choose to simply show an unobtrusive error&#010 indication such that the user can log back in at his liesure, or even log the user back in&#010 automatically.
 * @see com.smartgwt.client.data.DataSourceField#getChildTagName
 * @see com.smartgwt.client.rpc.RPCManager#loginRequired
 * @see com.smartgwt.client.rpc.RPCRequest#getContainsCredentials
 */
public interface Relogin {
}
