
package com.smartgwt.client.docs;

/**
 * The skinning mechanism is extremely powerful and gives you the ability to change&#010 internal functionality of components.  While this is useful for workarounds, you should&#010 think through any properties you override, considering what will happen with future&#010 versions of SmartGWT, where the defaults may change or be expanded.&#010 <P>&#010 The following kinds of overrides are generally very safe:&#010 <ul>&#010 <li> Change {@link com.smartgwt.client.widgets.Canvas#getStyleName styleName} or {@link com.smartgwt.client.widgets.Button#getBaseStyle baseStyle} to&#010 provide a custom CSS style or series of styles&#010 <li> Change a media path such as the {@link com.smartgwt.client.widgets.Img#getSrc src} of the &#010 {@link com.smartgwt.client.widgets.Window#getMinimizeButton minimizeButton}.&#010 <li> Change the size of any part of the UI that has a fixed pixel size, such as&#010 the height and width of the {@link com.smartgwt.client.widgets.Window#getMinimizeButton minimizeButton}, especially when this is done&#010 to match the size of media you have created&#010 <li> Set properties such as {@link com.smartgwt.client.widgets.Button#getShowRollOver showRollOver} that cause a component to&#010 visually react to more or fewer UI states (disabled, over, down, etc)&#010 </ul>&#010 The following should be very carefully considered:&#010 <ul>&#010 <li> Adding custom behaviors by passing in event handlers such as &#010 (eg {@link com.smartgwt.client.widgets.Canvas#addShowContextMenuHandler}).  If future versions of the&#010 component add more functionality, you may prevent new features from functioning, cause&#010 them to function only partially, or break.&#010 <P>&#010 If you want to ensure that you do not break new functionality added in future SmartGWT&#010 versions, be sure to call {@link com.smartgwt.client..Class#Super} for methods you override, and do not&#010 prevent events from bubbling.&#010 <P>&#010 If you want to ensure that <b>only</b> your custom behavior is used if a future version&#010 of a SmartGWT component adds functionality, override all methods involved in the&#010 interaction, even if your methods do nothing.  For example, for a custom drop&#010 interaction, override dropOver, dropMove, dropOut and drop, even if you do nothing on&#010 dropMove().  Then, do not call Super() if there is no superclass behavior required for&#010 the interaction you've implemented.  Also, for any event handlers (such as drop())&#010 return false if you consider your code to have completely handled the event (no&#010 parent component should react).&#010 </ul>&#010 The following are not recommended:&#010 <ul>&#010 <li> Providing a global {@link com.smartgwt.client.widgets.Canvas#getID ID} to a subcomponent (only works once).&#010 <li> Overriding {@link com.smartgwt.client.widgets.Canvas#getBackgroundColor backgroundColor}, {@link com.smartgwt.client.widgets.Canvas#getBorder border},&#010 {@link com.smartgwt.client.widgets.Canvas#getMargin margin}, {@link com.smartgwt.client.widgets.Canvas#getPadding padding}, or in general any single&#010 attribute otherwise controlled by CSS.  Future SmartGWT versions may change the base&#010 CSS style, rendering your single-property customization senseless.  Change the entire&#010 CSS style via {@link com.smartgwt.client.widgets.Canvas#getStyleName styleName} instead.&#010 </ul>
 */
public interface SafeSkinning {
}
