/*
 * SmartGWT (GWT for SmartClient)
 * Copyright 2008 and beyond, Isomorphic Software, Inc.
 *
 * SmartGWT is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation.  SmartGWT is also
 * available under typical commercial license terms - see
 * http://smartclient.com/license
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 */
 
package com.smartgwt.client.widgets;



import com.smartgwt.client.event.*;
import com.smartgwt.client.core.*;
import com.smartgwt.client.types.*;
import com.smartgwt.client.data.*;
import com.smartgwt.client.data.events.*;
import com.smartgwt.client.rpc.*;
import com.smartgwt.client.widgets.*;
import com.smartgwt.client.widgets.events.*;
import com.smartgwt.client.widgets.form.*;
import com.smartgwt.client.widgets.form.validator.*;
import com.smartgwt.client.widgets.form.fields.*;
import com.smartgwt.client.widgets.tile.*;
import com.smartgwt.client.widgets.tile.events.*;
import com.smartgwt.client.widgets.grid.*;
import com.smartgwt.client.widgets.grid.events.*;
import com.smartgwt.client.widgets.layout.*;
import com.smartgwt.client.widgets.menu.*;
import com.smartgwt.client.widgets.tab.*;
import com.smartgwt.client.widgets.toolbar.*;
import com.smartgwt.client.widgets.tree.*;
import com.smartgwt.client.widgets.tree.events.*;
import com.smartgwt.client.widgets.viewer.*;
import com.smartgwt.client.widgets.calendar.*;
import com.smartgwt.client.widgets.calendar.events.*;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.HashMap;

import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.user.client.Element;
import com.smartgwt.client.util.JSOHelper;
import com.smartgwt.client.util.EnumUtil;
import com.google.gwt.event.shared.*;
import com.google.gwt.event.shared.HasHandlers;
   /**
    * The StretchImg widget class implements a widget type that displays a list of multiple images&#010  that make up a single image.

    */
public class StretchImg extends StatefulCanvas {

    public static StretchImg getOrCreateRef(JavaScriptObject jsObj) {
        if(jsObj == null) return null;
        BaseWidget obj = BaseWidget.getRef(jsObj);
        if(obj != null) {
            return (StretchImg) obj;
        } else {
            return new StretchImg(jsObj);
        }
    }


    public StretchImg(){
        
    }

    public StretchImg(JavaScriptObject jsObj){
        super(jsObj);
    }

    protected native JavaScriptObject create()/*-{
        var config = this.@com.smartgwt.client.widgets.BaseWidget::getConfig()();
        var widget = $wnd.isc.StretchImg.create(config);
        this.@com.smartgwt.client.widgets.BaseWidget::doInit()();
        return widget;
    }-*/;
    // ********************* Properties / Attributes ***********************

    /**
    * Indicates whether the list of images is drawn vertically from top to bottom (true),&#010 or horizontally from left to right (false).
    *
    * @param vertical vertical Default value is true
    */
    public void setVertical(Boolean vertical) {
        setAttribute("vertical", vertical, true);
    }
    /**
     * Indicates whether the list of images is drawn vertically from top to bottom (true),&#010 or horizontally from left to right (false).
     *
     *
     * @return Boolean
     *
     */
    public Boolean getVertical()  {
        return getAttributeAsBoolean("vertical");
    }

    /**
    * If the default items are used, capSize is the size in pixels of the first and last&#010          images in this stretchImg.
    *
    * @param capSize capSize Default value is 2
    */
    public void setCapSize(int capSize) {
        setAttribute("capSize", capSize, true);
    }
    /**
     * If the default items are used, capSize is the size in pixels of the first and last&#010          images in this stretchImg.
     *
     *
     * @return int
     *
     */
    public int getCapSize()  {
        return getAttributeAsInt("capSize");
    }

    /**
    * The base URL for the image. &#010 <P>&#010 As with {@link com.smartgwt.client.widgets.Img#getSrc src}, the {@link com.smartgwt.client.types.State} of the component is added to this URL.  Then,&#010 the image segment name as specified by {@link com.smartgwt.client.widgets.StretchImg#getItems items} is added.&#010 <P>&#010 For example, for a stretchImg in "Over" state with a <code>src</code> of "button.png"&#010 and a segment name of "stretch", the resulting URL would be "button_Over_stretch.png".
    *
    * @param src src Default value is null
    */
    public void setSrc(String src) {
        setAttribute("src", src, true);
    }
    /**
     * The base URL for the image. &#010 <P>&#010 As with {@link com.smartgwt.client.widgets.Img#getSrc src}, the {@link com.smartgwt.client.types.State} of the component is added to this URL.  Then,&#010 the image segment name as specified by {@link com.smartgwt.client.widgets.StretchImg#getItems items} is added.&#010 <P>&#010 For example, for a stretchImg in "Over" state with a <code>src</code> of "button.png"&#010 and a segment name of "stretch", the resulting URL would be "button_Over_stretch.png".
     *
     *
     * @return String
     *
     */
    public String getSrc()  {
        return getAttributeAsString("src");
    }

    /**
    * Base URL for the image if {@link com.smartgwt.client.widgets.StretchImg#getVertical vertical} is false and &#010 {@link com.smartgwt.client.widgets.StretchImg#getSrc src} is unset.
    *
    * @param hSrc hSrc Default value is null
    */
    public void setHSrc(String hSrc) {
        setAttribute("hSrc", hSrc, true);
    }
    /**
     * Base URL for the image if {@link com.smartgwt.client.widgets.StretchImg#getVertical vertical} is false and &#010 {@link com.smartgwt.client.widgets.StretchImg#getSrc src} is unset.
     *
     *
     * @return String
     *
     */
    public String getHSrc()  {
        return getAttributeAsString("hSrc");
    }

    /**
    * Base URL for the image if {@link com.smartgwt.client.widgets.StretchImg#getVertical vertical} is true and &#010 {@link com.smartgwt.client.widgets.StretchImg#getSrc src} is unset.
    *
    * @param vSrc vSrc Default value is null
    */
    public void setVSrc(String vSrc) {
        setAttribute("vSrc", vSrc, true);
    }
    /**
     * Base URL for the image if {@link com.smartgwt.client.widgets.StretchImg#getVertical vertical} is true and &#010 {@link com.smartgwt.client.widgets.StretchImg#getSrc src} is unset.
     *
     *
     * @return String
     *
     */
    public String getVSrc()  {
        return getAttributeAsString("vSrc");
    }
             
    /**
    * Indicates whether the image should be tiled/cropped, stretched, or centered when the&#010          size of this widget does not match the size of the image. See ImageStyle for&#010          details.
    *
    * @param imageType imageType Default value is Img.STRETCH
    */
    public void setImageType(ImageStyle imageType) {
        setAttribute("imageType", imageType.getValue(), true);
    }
    /**
     * Indicates whether the image should be tiled/cropped, stretched, or centered when the&#010          size of this widget does not match the size of the image. See ImageStyle for&#010          details.
     *
     *
     * @return ImageStyle
     *
     */
    public ImageStyle getImageType()  {
        return (ImageStyle) EnumUtil.getEnum(ImageStyle.values(), getAttribute("imageType"));
    }

    /**
    * Should we show a "grip" image floating above the center of this widget?
    * <p><b>Note : </b> This is an advanced setting</p>
    *
    * @param showGrip showGrip Default value is null
    * @throws IllegalStateException this property cannot be changed after the component has been created
    */
    public void setShowGrip(Boolean showGrip)  throws IllegalStateException {
        setAttribute("showGrip", showGrip, false);
    }
    /**
     * Should we show a "grip" image floating above the center of this widget?
     *
     *
     * @return Boolean
     *
     */
    public Boolean getShowGrip()  {
        return getAttributeAsBoolean("showGrip");
    }

    /**
    * Determines whether any specified {@link com.smartgwt.client.widgets.StatefulCanvas#getTitle} will be &#010 displayed for this component.<br>&#010 Applies to Image-based components only, where the title will be rendered out in a label&#010 floating over the component
    * <p><b>Note : </b> This is an advanced setting</p>
    *
    * @param showTitle showTitle Default value is false
    */
    public void setShowTitle(Boolean showTitle) {
        setAttribute("showTitle", showTitle, true);
    }
    /**
     * Determines whether any specified {@link com.smartgwt.client.widgets.StatefulCanvas#getTitle} will be &#010 displayed for this component.<br>&#010 Applies to Image-based components only, where the title will be rendered out in a label&#010 floating over the component
     *
     *
     * @return Boolean
     *
     */
    public Boolean getShowTitle()  {
        return getAttributeAsBoolean("showTitle");
    }

    /**
    * If specified this css class will be applied to the individual item images within this StretchImg.&#010 May be overridden by specifying item-specific base styles to each object in the&#010 {@link com.smartgwt.client.widgets.StretchImg#getItems items}. This base style will have standard stateful suffixes&#010 appended to indicate the state of this component (as described in &#010 {@link com.smartgwt.client.widgets.StatefulCanvas#getBaseStyle baseStyle}).
    *
    * @param itemBaseStyle itemBaseStyle Default value is null
    */
    public void setItemBaseStyle(String itemBaseStyle) {
        setAttribute("itemBaseStyle", itemBaseStyle, true);
    }
    /**
     * If specified this css class will be applied to the individual item images within this StretchImg.&#010 May be overridden by specifying item-specific base styles to each object in the&#010 {@link com.smartgwt.client.widgets.StretchImg#getItems items}. This base style will have standard stateful suffixes&#010 appended to indicate the state of this component (as described in &#010 {@link com.smartgwt.client.widgets.StatefulCanvas#getBaseStyle baseStyle}).
     *
     *
     * @return String
     *
     */
    public String getItemBaseStyle()  {
        return getAttributeAsString("itemBaseStyle");
    }

    // ********************* Methods ***********************

        /**
         * Set the specified image's state to newState and update the displayed image given by&#010 whichPart, or set the state for all images to newState and update the displayed images&#010 if whichPart is not provided.&#010
         * @param newState name for the new state ("off", "down", etc)
         */
        public native void setState(String newState) /*-{
            var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
            self.setState(newState);
        }-*/;

        /**
         * Set the specified image's state to newState and update the displayed image given by&#010 whichPart, or set the state for all images to newState and update the displayed images&#010 if whichPart is not provided.&#010
         * @param newState name for the new state ("off", "down", etc)
     * @param whichPart name of the piece to set ("start", "stretch" or "end")           if not specified, sets them all
         */
        public native void setState(String newState, String whichPart) /*-{
            var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
            self.setState(newState, whichPart);
        }-*/;

    // ********************* Static Methods ***********************

}



